/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.generic;

import com.sap.cds.CdsDataStoreException;
import com.sap.cds.CdsVector;
import com.sap.cds.impl.parser.StructDataParser;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.jdbc.spi.ValueBinder;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CdsTypeUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractValueBinder
implements ValueBinder {
    private static final Logger logger = LoggerFactory.getLogger(AbstractValueBinder.class);
    protected static final ThreadLocal<Calendar> UTC = ThreadLocal.withInitial(() -> Calendar.getInstance(TimeZone.getTimeZone("UTC")));
    private final int timestampFractionalSeconds;
    private final ThreadLocal<Calendar> localCalendar;

    protected AbstractValueBinder(int timestampFractionalSeconds, TimeZone timeZone) {
        this.timestampFractionalSeconds = timestampFractionalSeconds;
        this.localCalendar = ThreadLocal.withInitial(() -> Calendar.getInstance(timeZone));
    }

    public <T> ValueBinder.Getter<T> getter(CdsBaseType cdsType, boolean isMediaType) {
        if (cdsType != null) {
            return this.getValueFromResult(cdsType, isMediaType);
        }
        return (result, i) -> result.getObject(i);
    }

    public <T> ValueBinder.Getter<T> getter(CdsStructuredType targetType, CqnSelectListValue slv) {
        CqnElementRef ref;
        CdsType type;
        if (slv.value().isRef() && (type = CdsModelUtils.element((CdsStructuredType)targetType, (CqnElementRef)(ref = slv.asRef())).getType()).isArrayed()) {
            CdsType itemsType = ((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType();
            return (result, i) -> this.parseListFromJson(result, i, itemsType);
        }
        Optional cdsType = CqnStatementUtils.getCdsType((CdsStructuredType)targetType, (CqnValue)slv.value());
        if (cdsType.isEmpty()) {
            logger.debug("Cannot determine CDS type of {}", (Object)slv.value());
        }
        return this.getter(cdsType.orElse(null), CqnStatementUtils.isMediaType((CdsStructuredType)targetType, (CqnSelectListItem)slv));
    }

    public <T> T getValue(ResultSet result, int i, CdsBaseType cdsType, boolean isMediaType) throws SQLException {
        return (T)this.getter(cdsType, isMediaType).get(result, i);
    }

    public void setValue(PreparedStatement pstmt, int i, CdsBaseType cdsType, Object value) throws SQLException {
        this.setter(cdsType).set(pstmt, i, value);
    }

    public ValueBinder.Setter setter(CdsBaseType cdsType) {
        if (cdsType == null) {
            return this::setValue;
        }
        switch (cdsType) {
            case DATE: {
                return this::setLocalDate;
            }
            case DATETIME: {
                return (pstmt, i, val) -> this.setInstant(pstmt, i, CdsTypeUtils.dateTime((Object)val));
            }
            case TIME: {
                return this::setLocalTime;
            }
            case TIMESTAMP: {
                return (pstmt, i, val) -> this.setInstant(pstmt, i, CdsTypeUtils.timestamp((Object)val, (int)this.timestampFractionalSeconds));
            }
            case LARGE_BINARY: {
                return this::setLargeBinary;
            }
            case HANA_CLOB: 
            case LARGE_STRING: {
                return this::setLargeString;
            }
            case VECTOR: {
                return this::setRealVector;
            }
            case MAP: {
                return this::setMap;
            }
        }
        return PreparedStatement::setObject;
    }

    protected void setValue(PreparedStatement pstmt, int i, Object value) throws SQLException {
        if (value instanceof Instant) {
            Instant instant = (Instant)value;
            this.setInstant(pstmt, i, instant);
        } else if (value instanceof LocalDate) {
            LocalDate date = (LocalDate)value;
            this.setLocalDate(pstmt, i, date);
        } else if (value instanceof LocalTime) {
            LocalTime time = (LocalTime)value;
            this.setLocalTime(pstmt, i, time);
        } else if (value instanceof ZonedDateTime) {
            ZonedDateTime time = (ZonedDateTime)value;
            this.setZonedDateTime(pstmt, i, time);
        } else if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            this.setInstant(pstmt, i, timestamp.toInstant());
        } else if (value instanceof Time) {
            Time time = (Time)value;
            this.setLocalTime(pstmt, i, time.toLocalTime());
        } else if (value instanceof Date) {
            Date date = (Date)value;
            this.setLocalDate(pstmt, i, date.toLocalDate());
        } else if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            pstmt.setBytes(i, bytes);
        } else if (value instanceof Reader) {
            Reader reader = (Reader)value;
            this.setLargeString(pstmt, i, reader);
        } else if (value instanceof InputStream) {
            InputStream stream = (InputStream)value;
            this.setLargeBinary(pstmt, i, stream);
        } else {
            pstmt.setObject(i, value);
        }
    }

    protected void setRealVector(PreparedStatement pstmt, int i, Object vector) throws SQLException {
        throw new UnsupportedOperationException("cds.Vector is not supported on this data store");
    }

    protected CdsVector getRealVector(ResultSet result, int i) throws SQLException {
        throw new UnsupportedOperationException("cds.Vector is not supported on this data store");
    }

    protected void setLocalTime(PreparedStatement pstmt, int i, Object localTime) throws SQLException {
        if (localTime instanceof LocalTime) {
            LocalTime time = (LocalTime)localTime;
            this.setLocalTime(pstmt, i, time);
        } else if (localTime instanceof String) {
            String string = (String)localTime;
            this.setLocalTime(pstmt, i, LocalTime.parse(string));
        } else if (localTime instanceof Time) {
            Time time = (Time)localTime;
            this.setLocalTime(pstmt, i, time.toLocalTime());
        } else {
            pstmt.setObject(i, localTime);
        }
    }

    protected abstract void setLocalTime(PreparedStatement var1, int var2, LocalTime var3) throws SQLException;

    protected void setLocalDate(PreparedStatement pstmt, int i, Object localDate) throws SQLException {
        if (localDate instanceof LocalDate) {
            LocalDate date = (LocalDate)localDate;
            this.setLocalDate(pstmt, i, date);
        } else if (localDate instanceof String) {
            String string = (String)localDate;
            this.setLocalDate(pstmt, i, LocalDate.parse(string));
        } else if (localDate instanceof Date) {
            Date date = (Date)localDate;
            this.setLocalDate(pstmt, i, date.toLocalDate());
        } else {
            pstmt.setObject(i, localDate);
        }
    }

    protected abstract void setLocalDate(PreparedStatement var1, int var2, LocalDate var3) throws SQLException;

    protected abstract void setInstant(PreparedStatement var1, int var2, Instant var3) throws SQLException;

    private void setLargeBinary(PreparedStatement pstmt, int i, Object largeBin) throws SQLException {
        if (largeBin instanceof InputStream) {
            InputStream stream = (InputStream)largeBin;
            this.setLargeBinary(pstmt, i, stream);
        } else {
            pstmt.setObject(i, largeBin);
        }
    }

    protected abstract void setLargeBinary(PreparedStatement var1, int var2, InputStream var3) throws SQLException;

    private void setZonedDateTime(PreparedStatement pstmt, int i, ZonedDateTime zonedDateTime) throws SQLException {
        this.setInstant(pstmt, i, CdsTypeUtils.dateTime((Instant)zonedDateTime.toInstant()));
    }

    protected abstract LocalTime getLocalTime(ResultSet var1, int var2) throws SQLException;

    protected abstract LocalDate getLocalDate(ResultSet var1, int var2) throws SQLException;

    protected abstract Instant getInstant(ResultSet var1, int var2) throws SQLException;

    private void setLargeString(PreparedStatement pstmt, int i, Object largeStr) throws SQLException {
        if (largeStr instanceof Reader) {
            Reader reader = (Reader)largeStr;
            this.setLargeString(pstmt, i, reader);
        } else {
            this.setString(pstmt, i, largeStr);
        }
    }

    protected abstract void setLargeString(PreparedStatement var1, int var2, Reader var3) throws SQLException;

    protected abstract Reader getLargeString(ResultSet var1, int var2) throws SQLException;

    protected abstract InputStream getLargeBinary(ResultSet var1, int var2) throws SQLException;

    protected Boolean getBoolean(ResultSet result, int i) throws SQLException {
        boolean bool = result.getBoolean(i);
        return result.wasNull() ? null : Boolean.valueOf(bool);
    }

    protected Double getDouble(ResultSet result, int i) throws SQLException {
        double dbl = result.getDouble(i);
        return result.wasNull() ? null : Double.valueOf(dbl);
    }

    protected Short getShort(ResultSet result, int i) throws SQLException {
        short int16 = result.getShort(i);
        return result.wasNull() ? null : Short.valueOf(int16);
    }

    protected Integer getInt(ResultSet result, int i) throws SQLException {
        int int32 = result.getInt(i);
        return result.wasNull() ? null : Integer.valueOf(int32);
    }

    protected Long getLong(ResultSet result, int i) throws SQLException {
        long int64 = result.getLong(i);
        return result.wasNull() ? null : Long.valueOf(int64);
    }

    private void setString(PreparedStatement pstmt, int i, Object string) throws SQLException {
        pstmt.setString(i, (String)string);
    }

    protected Float getFloat(ResultSet result, int i) throws SQLException {
        float real = result.getFloat(i);
        return result.wasNull() ? null : Float.valueOf(real);
    }

    protected void setMap(PreparedStatement pstmt, int i, Object value) throws SQLException {
        if (value == null) {
            this.setJson(pstmt, i, null);
        } else if (value instanceof Map) {
            byte[] bytes = Jsonizer.bytes((Object)value, (boolean)false);
            this.setJson(pstmt, i, bytes);
        } else {
            throw new CdsDataStoreException("Unsupported data format for cds.Map type: " + String.valueOf(value.getClass()));
        }
    }

    protected void setJson(PreparedStatement pstmt, int i, Object json) throws SQLException {
        if (json == null) {
            pstmt.setNull(i, 1111);
        } else if (json instanceof byte[]) {
            byte[] bytes = (byte[])json;
            pstmt.setBytes(i, bytes);
        } else if (json instanceof String) {
            String str = (String)json;
            pstmt.setString(i, str);
        } else {
            throw new CdsDataStoreException("Unsupported data format for JSON: " + String.valueOf(json.getClass()));
        }
    }

    protected List<?> parseListFromJson(ResultSet result, int i, CdsType rowType) throws SQLException {
        String json = this.getJson(result, i);
        if (json == null) {
            return null;
        }
        return StructDataParser.parseArrayOf((CdsType)rowType, (String)json);
    }

    protected Object parseObjectFromJson(ResultSet result, int i) throws SQLException {
        String json = this.getJson(result, i);
        if (json == null) {
            return null;
        }
        return StructDataParser.parse((String)json);
    }

    protected String getJson(ResultSet result, int i) throws SQLException {
        return result.getString(i);
    }

    private ValueBinder.Getter<?> getValueFromResult(CdsBaseType cdsType, boolean isMediaType) {
        switch (cdsType) {
            case BOOLEAN: {
                return this::getBoolean;
            }
            case DATE: {
                return this::getLocalDate;
            }
            case DATETIME: {
                return (result, i) -> CdsTypeUtils.dateTime((Instant)this.getInstant(result, i));
            }
            case DECIMAL: 
            case HANA_SMALLDECIMAL: 
            case DECIMAL_FLOAT: {
                return ResultSet::getBigDecimal;
            }
            case DOUBLE: {
                return this::getDouble;
            }
            case INTEGER: 
            case INT32: {
                return this::getInt;
            }
            case INTEGER64: 
            case INT64: {
                return this::getLong;
            }
            case LARGE_BINARY: {
                if (isMediaType) {
                    return this::getLargeBinary;
                }
            }
            case HANA_BINARY: 
            case BINARY: {
                return ResultSet::getBytes;
            }
            case HANA_CLOB: 
            case LARGE_STRING: {
                if (isMediaType) {
                    return this::getLargeString;
                }
            }
            case STRING: {
                return ResultSet::getString;
            }
            case TIME: {
                return this::getLocalTime;
            }
            case TIMESTAMP: {
                return (result, i) -> CdsTypeUtils.timestamp((Instant)this.getInstant(result, i), (int)this.timestampFractionalSeconds);
            }
            case UINT8: 
            case INT16: 
            case HANA_TINYINT: 
            case HANA_SMALLINT: {
                return this::getShort;
            }
            case HANA_REAL: {
                return this::getFloat;
            }
            case VECTOR: {
                return this::getRealVector;
            }
            case MAP: {
                return this::parseObjectFromJson;
            }
        }
        return (result, i) -> result.getObject(i);
    }

    protected Calendar getCalendarForDefaultTimeZone() {
        return this.localCalendar.get();
    }
}

