/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.generic;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.jdbc.generic.AbstractSearchResolver;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsSearchUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class GenericSearchResolver
extends AbstractSearchResolver {
    public GenericSearchResolver(DataStoreConfiguration config, CdsModel cdsModel, Locale locale) {
        super(config, cdsModel, locale);
    }

    public CqnPredicate resolve(CqnPredicate searchExpression, CdsStructuredType rowType, boolean exactSearch) {
        List searchableRefs = CdsSearchUtils.searchableElementRefs((CdsStructuredType)rowType).stream().toList();
        return CdsSearchUtils.searchToLikeExpression(searchableRefs, (CqnPredicate)searchExpression);
    }

    @Override
    protected void resolve(CqnSelect select, CqnPredicate search, CdsStructuredType targetType, Collection<CqnElementRef> searchableRefs) {
        boolean resolveLocalizedViaAssociation;
        HashSet<CqnElementRef> badRefs = new HashSet<CqnElementRef>();
        boolean languageIsGiven = this.locale != null;
        boolean bl = resolveLocalizedViaAssociation = languageIsGiven && LocaleUtils.hasLocalizedElements((CdsStructuredType)targetType, searchableRefs) && this.allLocalizedElementsAreReachableViaLocalizedAssociation(targetType, searchableRefs, badRefs) && !this.hasAliasedLocalizedElementsInView(targetType, searchableRefs, badRefs);
        if (!resolveLocalizedViaAssociation) {
            this.resolveUsingLocalizedViewWithLike(select, search, targetType, searchableRefs);
        } else {
            this.resolveUsingLocalizedAssociationWithLike(select, search, targetType, searchableRefs);
        }
    }

    @Override
    protected String defaultSearchMode() {
        return "localized-association";
    }
}

