/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.generic.hierarchies;

import com.sap.cds.CqnTableFunction;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.sql.CommonTableExpression;
import com.sap.cds.jdbc.generic.hierarchies.GenericSortByArrayColumnStrategy;
import com.sap.cds.jdbc.generic.hierarchies.RecursiveCteHierarchyFunctions;
import com.sap.cds.jdbc.generic.hierarchies.SortStrategy;
import com.sap.cds.jdbc.spi.FunctionMapper;
import com.sap.cds.jdbc.spi.TableFunctionDispatcher;
import com.sap.cds.jdbc.spi.TableFunctionMapper;
import com.sap.cds.ql.hana.CqnHierarchy;
import com.sap.cds.ql.hana.CqnHierarchyGenerator;
import com.sap.cds.ql.hana.CqnHierarchySubset;
import java.util.List;
import java.util.Map;

public class RecursiveCteHierarchyFunctionDispatcher
implements TableFunctionDispatcher {
    private final SortStrategy sortStrategy;

    public RecursiveCteHierarchyFunctionDispatcher(SortStrategy sortStrategy) {
        this.sortStrategy = sortStrategy;
    }

    public RecursiveCteHierarchyFunctionDispatcher(FunctionMapper functionMapper) {
        this(new GenericSortByArrayColumnStrategy(functionMapper));
    }

    public boolean handles(CqnTableFunction tf) {
        return tf instanceof CqnHierarchy || tf instanceof RecursiveCteHierarchyFunctions.ComputeDescendantCounts || tf instanceof RecursiveCteHierarchyFunctions.FilteredHierarchy || tf instanceof RecursiveCteHierarchyFunctions.ComputeDirectDescendants;
    }

    public TableFunctionMapper create(Object ctx, List params, CqnTableFunction tableFunction, Map<String, ?> cteMap) {
        Map<String, CommonTableExpression> ctes = cteMap;
        Context context = (Context)ctx;
        if (tableFunction instanceof CqnHierarchyGenerator) {
            CqnHierarchyGenerator hg = (CqnHierarchyGenerator)tableFunction;
            return new RecursiveCteHierarchyFunctions.Generator(context, ctes, params, hg, this.sortStrategy);
        }
        if (tableFunction instanceof CqnHierarchySubset) {
            CqnHierarchySubset s = (CqnHierarchySubset)tableFunction;
            return new RecursiveCteHierarchyFunctions.HierarchySubset(context, ctes, (List<PreparedCqnStmt.Parameter>)params, s);
        }
        if (tableFunction instanceof RecursiveCteHierarchyFunctions.ComputeDescendantCounts) {
            RecursiveCteHierarchyFunctions.ComputeDescendantCounts cdc = (RecursiveCteHierarchyFunctions.ComputeDescendantCounts)tableFunction;
            return cdc.renderer(context, ctes);
        }
        if (tableFunction instanceof RecursiveCteHierarchyFunctions.FilteredHierarchy) {
            RecursiveCteHierarchyFunctions.FilteredHierarchy fh = (RecursiveCteHierarchyFunctions.FilteredHierarchy)tableFunction;
            return fh.renderer(context, ctes);
        }
        if (tableFunction instanceof RecursiveCteHierarchyFunctions.ComputeDirectDescendants) {
            RecursiveCteHierarchyFunctions.ComputeDirectDescendants cdd = (RecursiveCteHierarchyFunctions.ComputeDirectDescendants)tableFunction;
            return cdd.renderer(context, ctes, params);
        }
        throw new UnsupportedOperationException("Unsupported table function: " + String.valueOf(tableFunction));
    }
}

