/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.h2;

import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.jdbc.generic.GenericStatementResolver;
import com.sap.cds.jdbc.generic.hierarchies.RecursiveCteHierarchyResolver;
import com.sap.cds.ql.Select;
import com.sap.cds.reflect.CdsModel;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class H2StatementResolver
extends GenericStatementResolver {
    public String upsert(String table, Stream<String> keyColumns, Stream<String> upsertColumns, Stream<String> upsertValues) {
        String columns = SQLHelper.commaSeparated(upsertColumns);
        String values = SQLHelper.commaSeparated(upsertValues);
        return Stream.of("MERGE INTO", table, columns, "VALUES", values).collect(Collectors.joining(" "));
    }

    public Optional<String> timeoutClause(int timeoutSeconds) {
        if (timeoutSeconds > 0) {
            return Optional.of("WAIT " + timeoutSeconds);
        }
        return Optional.of("NOWAIT");
    }

    @Override
    public Select<?> applyTransformations(CdsModel model, Select<?> select) {
        RecursiveCteHierarchyResolver resolver = new RecursiveCteHierarchyResolver(model, select);
        resolver.applyTransformations();
        return resolver.get();
    }
}

