/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana;

import com.sap.cds.CdsDataStoreException;
import com.sap.cds.CdsVector;
import com.sap.cds.impl.builder.model.RealVector;
import com.sap.cds.impl.util.RealVectorUtils;
import com.sap.cds.jdbc.generic.GenericBinder;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.TimeZone;

class HanaBinder
extends GenericBinder {
    HanaBinder(TimeZone timeZone) {
        super(7, timeZone);
    }

    @Override
    protected Reader getLargeString(ResultSet result, int i) throws SQLException {
        NClob nClob = result.getNClob(i);
        return null == nClob ? null : nClob.getCharacterStream();
    }

    @Override
    protected InputStream getLargeBinary(ResultSet result, int i) throws SQLException {
        Blob blob = result.getBlob(i);
        return null == blob ? null : blob.getBinaryStream();
    }

    @Override
    protected void setRealVector(PreparedStatement pstmt, int i, Object vector) throws SQLException {
        if (vector instanceof RealVector) {
            RealVector v = (RealVector)vector;
            vector = v.vector();
        }
        if (vector == null) {
            pstmt.setNull(i, -2);
        } else if (vector instanceof byte[]) {
            byte[] b = (byte[])vector;
            pstmt.setBytes(i, b);
        } else if (vector instanceof float[]) {
            float[] f = (float[])vector;
            pstmt.setBytes(i, RealVectorUtils.toByteArray((float[])f));
        } else if (vector instanceof String) {
            String s = (String)vector;
            pstmt.setBytes(i, RealVectorUtils.toByteArray((String)s));
        } else {
            throw new CdsDataStoreException(vector.getClass().getName() + " is not supported for type cds.Vector");
        }
    }

    @Override
    protected CdsVector getRealVector(ResultSet result, int i) throws SQLException {
        byte[] vector = result.getBytes(i);
        return RealVector.hanaRealVector((byte[])vector);
    }
}

