/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana;

import com.sap.cds.jdbc.generic.GenericScalarValueResolver;
import com.sap.cds.jdbc.hana.HanaPredicateMapper;
import com.sap.cds.jdbc.spi.ScalarValueResolver;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnParameter;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVector;
import com.sap.cds.reflect.CdsBaseType;

public class HanaScalarValueResolver
extends GenericScalarValueResolver {
    private static final String CAST_AS_REAL_VECTOR = "CAST(? AS REAL_VECTOR)";
    public static final ScalarValueResolver INSTANCE = new HanaScalarValueResolver();

    public HanaScalarValueResolver() {
        super(new HanaPredicateMapper());
    }

    public String parameter(CqnVector vector) {
        return CAST_AS_REAL_VECTOR;
    }

    public String parameter(CqnParameter p) {
        return p.type().filter(CdsBaseType.VECTOR.cdsName()::equals).map(t -> CAST_AS_REAL_VECTOR).orElse("?");
    }

    @Override
    public CqnValue selectListValue(CqnValue value) {
        if (!(value = super.selectListValue(value)).isLiteral() && value instanceof CqnPredicate) {
            CqnPredicate p = (CqnPredicate)value;
            value = CQL.when((CqnPredicate)p).then((CqnValue)CQL.TRUE).orElse((CqnValue)CQL.FALSE);
        }
        return value;
    }
}

