/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.postgresql;

import com.sap.cds.impl.parser.token.CqnPlainImpl;
import com.sap.cds.jdbc.generic.GenericFunctionMapper;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnPlain;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.List;
import java.util.Locale;

public class PostgreSqlFunctionMapper
extends GenericFunctionMapper {
    @Override
    public String toSql(String cqnFunc, List<String> args) {
        String function;
        return switch (function = cqnFunc.toLowerCase(Locale.US)) {
            case "matchespattern" -> this.genericFuncToSql("REGEXP_LIKE", args);
            case "indexof" -> this.genericFuncToSql("STRPOS", args) + " - 1";
            case "subarray" -> "(%s)[%s:%s]".formatted(args.get(0), args.get(1), args.get(2));
            default -> super.toSql(cqnFunc, args);
        };
    }

    @Override
    public Predicate like(CdsStructuredType rowType, CqnValue value, CqnValue pattern, String esc, boolean caseInsensitive) {
        CqnPlainImpl cast = rowType != null && value.isRef() && value.asRef().size() == 1 && rowType.getElement(value.asRef().firstSegment()).getType().isSimpleType(CdsBaseType.MAP) ? CqnPlainImpl.plain((String)"::text") : CqnPlainImpl.plain((String)"");
        return this.ilike(value, (CqnPlain)cast, pattern, esc, caseInsensitive);
    }

    public String pathOf(String column, CdsBaseType type) {
        Object sql = super.pathOf(column, type);
        if (type == CdsBaseType.STRING) {
            sql = (String)sql + "::varchar[]";
        }
        return sql;
    }
}

