/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.sqlite;

import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.jdbc.generic.GenericFunctionMapper;
import com.sap.cds.reflect.CdsBaseType;
import java.util.List;
import java.util.Locale;

public class SqliteFunctionMapper
extends GenericFunctionMapper {
    private static final String SLASH = SQLHelper.literal("/");
    private static final String ESCAPED = SQLHelper.literal("%2F");

    @Override
    public String toSql(String cqnFunc, List<String> args) {
        String func;
        return switch (func = cqnFunc.toLowerCase(Locale.US)) {
            case "substring" -> this.genericFuncToSql("substr", args);
            case "trim" -> this.genericFuncToSql("TRIM", List.of(args.get(0), UNICODE_WHITESPACE_SQL));
            default -> super.toSql(cqnFunc, args);
        };
    }

    public String pathOf(String column, CdsBaseType type) {
        return this.toSql("concat", new String[]{this.escapeSlash(column), SLASH});
    }

    public String appendPath(String path, String suffixColumn) {
        return this.toSql("concat", new String[]{path, this.escapeSlash(suffixColumn), SLASH});
    }

    public String pathStartsWith(String path, String prefix, String prefixLength) {
        return this.toSql("instr", new String[]{path, prefix}) + " = 1";
    }

    private String escapeSlash(String col) {
        return this.toSql("replace", new String[]{col, SLASH, ESCAPED});
    }
}

