package com.sap.cds.transaction.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class SQLProxyBuilder<T> {

	public static <T> SQLProxyBuilder<T> create(Class<?> clazz, T target) {
		return new SQLProxyBuilder<T>(clazz, target);
	}

	private Class<?> clazz;
	private T target;
	private Map<String, Call<?>> handlers = new HashMap<>();

	private SQLProxyBuilder(Class<?> clazz, T target) {
		this.clazz = clazz;
		this.target = target;
	}

	public <R> SQLProxyBuilder<T> handle(String methodName, Call<R> call) {
		handlers.put(methodName, call);
		return this;
	}

	@SuppressWarnings("unchecked")
	public T build() {
		ClassLoader cl = Connection.class.getClassLoader();
		Class<?>[] ifs = new Class<?>[] { clazz };
		InvocationHandler handler = new InvocationHandler() {
			@Override
			public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
				if (method.getParameterCount() == 0) {
					Call<?> call = handlers.get(method.getName());
					if (call != null) {
						return call.call();
					}
				}
				return method.invoke(target, args);
			}

		};
		return (T) Proxy.newProxyInstance(cl, ifs, handler);
	}

	@FunctionalInterface
	interface Call<R> {
		R call() throws SQLException;
	}

	public static final Call<Void> NOP = () -> null;

}
