/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.transaction.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class SQLProxyBuilder<T> {
    private Class<?> clazz;
    private T target;
    private Map<String, Call<?>> handlers = new HashMap();
    public static final Call<Void> NOP = () -> null;

    public static <T> SQLProxyBuilder<T> create(Class<?> clazz, T target) {
        return new SQLProxyBuilder<T>(clazz, target);
    }

    private SQLProxyBuilder(Class<?> clazz, T target) {
        this.clazz = clazz;
        this.target = target;
    }

    public <R> SQLProxyBuilder<T> handle(String methodName, Call<R> call) {
        this.handlers.put(methodName, call);
        return this;
    }

    public T build() {
        ClassLoader cl = Connection.class.getClassLoader();
        Class[] ifs = new Class[]{this.clazz};
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Call call;
                if (method.getParameterCount() == 0 && (call = (Call)SQLProxyBuilder.this.handlers.get(method.getName())) != null) {
                    return call.call();
                }
                return method.invoke(SQLProxyBuilder.this.target, args);
            }
        };
        return (T)Proxy.newProxyInstance(cl, ifs, handler);
    }

    @FunctionalInterface
    static interface Call<R> {
        public R call() throws SQLException;
    }
}

