package com.sap.cds.transaction.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Supplier;

import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cds.transaction.SystemException;
import com.sap.cds.transaction.spi.ContainerTransactionManager;
import com.sap.cds.transaction.spi.TransactionManagerFactory;

public class LocalTransactionManagerFactory implements TransactionManagerFactory<DataSource> {

	private static final Logger logger = LoggerFactory.getLogger(LocalTransactionManagerFactory.class);

	private final LocalTransactionManager mgr;
	private final Supplier<Connection> ds;

	public LocalTransactionManagerFactory(DataSource ds) {
		this(() -> getConnection(ds));
	}

	public LocalTransactionManagerFactory(Supplier<Connection> ds) {
		this.mgr = new LocalTransactionManager(logger, ds);
		this.ds = mgr.getConnectionSupplier();
	}

	@Override
	public ContainerTransactionManager getTransactionManger() {
		return mgr;
	}

	@Override
	public Supplier<Connection> getConnectionSupplier() {
		return ds::get;
	}

	private static Connection getConnection(DataSource ds) {
		try {
			return ds.getConnection();
		} catch (SQLException e) {
			throw new SystemException("cannot obtain connection", e);
		}
	}

}
