/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.transaction.impl;

import com.sap.cds.transaction.SystemException;
import com.sap.cds.transaction.impl.LocalTransactionManager;
import com.sap.cds.transaction.spi.ContainerTransactionManager;
import com.sap.cds.transaction.spi.TransactionManagerFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTransactionManagerFactory
implements TransactionManagerFactory<DataSource> {
    private static final Logger logger = LoggerFactory.getLogger(LocalTransactionManagerFactory.class);
    private final LocalTransactionManager mgr;
    private final Supplier<Connection> ds;

    public LocalTransactionManagerFactory(DataSource ds) {
        this(() -> LocalTransactionManagerFactory.getConnection(ds));
    }

    public LocalTransactionManagerFactory(Supplier<Connection> ds) {
        this.mgr = new LocalTransactionManager(logger, ds);
        this.ds = this.mgr.getConnectionSupplier();
    }

    public ContainerTransactionManager getTransactionManger() {
        return this.mgr;
    }

    public Supplier<Connection> getConnectionSupplier() {
        return this.ds::get;
    }

    private static Connection getConnection(DataSource ds) {
        try {
            return ds.getConnection();
        }
        catch (SQLException e) {
            throw new SystemException("cannot obtain connection", (Exception)e);
        }
    }
}

