/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.transaction.impl;

import com.sap.cds.transaction.RollbackException;
import com.sap.cds.transaction.SystemException;
import com.sap.cds.transaction.TransactionException;
import com.sap.cds.transaction.TransactionRequiredException;
import com.sap.cds.transaction.impl.SQLProxyBuilder;
import com.sap.cds.transaction.spi.ContainerTransactionManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class LocalTransactionManager
implements ContainerTransactionManager {
    private static final ThreadLocal<Tx> txHolder = new ThreadLocal();
    private final Supplier<Connection> ds;
    private final Logger logger;
    private final Supplier<Connection> managedDS;

    public LocalTransactionManager(Logger logger, Supplier<Connection> ds) {
        this.logger = logger;
        this.ds = ds;
        this.managedDS = LocalTransactionManager.createManagedDataSource(ds);
    }

    private static Supplier<Connection> createManagedDataSource(Supplier<Connection> ds2) {
        SQLProxyBuilder<Supplier<Connection>> builder = SQLProxyBuilder.create(Supplier.class, ds2);
        SQLProxyBuilder.Call<Connection> getConnection = () -> {
            Connection conn;
            Tx tx = txHolder.get();
            if (tx == null) {
                conn = (Connection)ds2.get();
                conn.setAutoCommit(true);
            } else {
                conn = tx.getConnection();
                conn = LocalTransactionManager.wrapConnection(conn);
            }
            return conn;
        };
        return builder.handle("get", getConnection).build();
    }

    private static Connection wrapConnection(Connection conn) {
        return SQLProxyBuilder.create(Connection.class, conn).handle("close", SQLProxyBuilder.NOP).build();
    }

    public void begin() {
        if (txHolder.get() != null) {
            throw new TransactionException("there is an active transaction");
        }
        Connection conn = this.ds.get();
        try {
            try {
                conn.setClientInfo("LOCALE", null);
            }
            catch (SQLException ex) {
                this.logger.info("setClientInfo not supprted", (Throwable)ex);
            }
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new SystemException("exception during setAutoCommit", (Exception)e);
        }
        txHolder.set(new Tx(conn));
    }

    public void commit() {
        Tx tx = this.getActiveTransaction();
        try {
            tx.commit();
        }
        finally {
            this.close(tx);
        }
    }

    public void rollback() {
        Tx tx = this.getActiveTransaction();
        try {
            tx.rollback();
        }
        finally {
            this.close(tx);
        }
    }

    private Tx getActiveTransaction() {
        Tx tx = txHolder.get();
        if (tx == null) {
            throw new TransactionRequiredException("no transaction is active");
        }
        return tx;
    }

    private void close(Tx tx) {
        txHolder.remove();
        try {
            tx.getConnection().close();
        }
        catch (SQLException e) {
            this.logger.error("Exception while closing connection", (Throwable)e);
        }
    }

    public boolean isActive() {
        Tx tx = txHolder.get();
        return tx != null;
    }

    public Supplier<Connection> getConnectionSupplier() {
        return this.managedDS;
    }

    public void setRollbackOnly() {
        Tx tx = this.getActiveTransaction();
        tx.setRollbackOnly();
    }

    public boolean isRollbackOnly() {
        Tx tx = this.getActiveTransaction();
        return tx.isRollbackOnly();
    }

    private static class Tx {
        private final Connection conn;
        private boolean rollbackOnly = false;

        public Tx(Connection conn) {
            this.conn = conn;
        }

        public void commit() {
            try {
                if (this.rollbackOnly) {
                    this.rollback();
                    throw new RollbackException("the transaction was marked for rollback only and has been rolled back");
                }
                this.conn.commit();
            }
            catch (SQLException e) {
                throw new RollbackException(e);
            }
        }

        public void rollback() {
            try {
                this.conn.rollback();
            }
            catch (SQLException e) {
                throw new SystemException("exception during rollback", (Exception)e);
            }
        }

        public Connection getConnection() {
            return this.conn;
        }

        public void setRollbackOnly() {
            this.rollbackOnly = true;
        }

        public boolean isRollbackOnly() {
            return this.rollbackOnly;
        }
    }
}

