/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.consumer;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataDeltaFeed;
import org.apache.olingo.odata2.core.commons.XmlHelper;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.aggregator.EntityPropertyInfo;
import org.apache.olingo.odata2.core.ep.consumer.XmlEntryConsumer;
import org.apache.olingo.odata2.core.ep.consumer.XmlFeedConsumer;
import org.apache.olingo.odata2.core.ep.consumer.XmlLinkConsumer;
import org.apache.olingo.odata2.core.ep.consumer.XmlPropertyConsumer;

public class XmlEntityConsumer {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ODataDeltaFeed readFeed(EdmEntitySet entitySet, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        ODataDeltaFeed oDataDeltaFeed;
        XMLStreamReader reader = null;
        EntityProviderException cachedException = null;
        try {
            reader = XmlHelper.createStreamReader(content);
            EntityInfoAggregator eia = EntityInfoAggregator.create(entitySet);
            XmlFeedConsumer xfc = new XmlFeedConsumer();
            oDataDeltaFeed = xfc.readFeed(reader, eia, properties);
            if (reader == null) return oDataDeltaFeed;
        }
        catch (EntityProviderException e) {
            try {
                cachedException = e;
                throw cachedException;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (XMLStreamException e2) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e2.getClass().getSimpleName()), (Throwable)e2);
                }
            }
        }
        try {
            reader.close();
            return oDataDeltaFeed;
        }
        catch (XMLStreamException e) {
            if (cachedException != null) {
                throw cachedException;
            }
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ODataEntry readEntry(EdmEntitySet entitySet, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        ODataEntry oDataEntry;
        XMLStreamReader reader = null;
        EntityProviderException cachedException = null;
        try {
            reader = XmlHelper.createStreamReader(content);
            EntityInfoAggregator eia = EntityInfoAggregator.create(entitySet);
            oDataEntry = new XmlEntryConsumer().readEntry(reader, eia, properties, false);
            if (reader == null) return oDataEntry;
        }
        catch (EntityProviderException e) {
            try {
                cachedException = e;
                throw cachedException;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (XMLStreamException e2) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e2.getClass().getSimpleName()), (Throwable)e2);
                }
            }
        }
        try {
            reader.close();
            return oDataEntry;
        }
        catch (XMLStreamException e) {
            if (cachedException != null) {
                throw cachedException;
            }
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    public Map<String, Object> readProperty(EdmProperty edmProperty, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        return this.readProperty(EntityInfoAggregator.create(edmProperty), content, properties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> readProperty(EntityPropertyInfo propertyInfo, InputStream content, EntityProviderReadProperties readProperties) throws EntityProviderException {
        Map<String, Object> map;
        XMLStreamReader reader = null;
        EntityProviderException cachedException = null;
        try {
            reader = XmlHelper.createStreamReader(content);
            map = new XmlPropertyConsumer().readProperty(reader, propertyInfo, readProperties);
            if (reader == null) return map;
        }
        catch (EntityProviderException e) {
            try {
                cachedException = e;
                throw cachedException;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (XMLStreamException e2) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e2.getClass().getSimpleName()), (Throwable)e2);
                }
            }
        }
        try {
            reader.close();
            return map;
        }
        catch (XMLStreamException e) {
            if (cachedException != null) {
                throw cachedException;
            }
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    public Object readPropertyValue(EdmProperty edmProperty, InputStream content) throws EntityProviderException {
        return this.readPropertyValue(edmProperty, content, null);
    }

    public Object readPropertyValue(EdmProperty edmProperty, InputStream content, Class<?> typeMapping) throws EntityProviderException {
        try {
            Map<String, Object> result;
            EntityProviderReadProperties.EntityProviderReadPropertiesBuilder propertiesBuilder = EntityProviderReadProperties.init().mergeSemantic(false);
            if (typeMapping == null) {
                result = this.readProperty(edmProperty, content, propertiesBuilder.build());
            } else {
                HashMap<String, Object> typeMappings = new HashMap<String, Object>();
                typeMappings.put(edmProperty.getName(), typeMapping);
                result = this.readProperty(edmProperty, content, propertiesBuilder.addTypeMappings(typeMappings).build());
            }
            return result.get(edmProperty.getName());
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object readCollection(EntityPropertyInfo info, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        List<?> list;
        XMLStreamReader reader = null;
        EntityProviderException cachedException = null;
        try {
            reader = XmlHelper.createStreamReader(content);
            list = new XmlPropertyConsumer().readCollection(reader, info, properties);
            if (reader == null) return list;
        }
        catch (EntityProviderException e) {
            try {
                cachedException = e;
                throw cachedException;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (XMLStreamException e2) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e2.getClass().getSimpleName()), (Throwable)e2);
                }
            }
        }
        try {
            reader.close();
            return list;
        }
        catch (XMLStreamException e) {
            if (cachedException != null) {
                throw cachedException;
            }
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readLink(EdmEntitySet entitySet, Object content) throws EntityProviderException {
        String string;
        XMLStreamReader reader = null;
        EntityProviderException cachedException = null;
        XmlLinkConsumer xlc = new XmlLinkConsumer();
        try {
            reader = XmlHelper.createStreamReader(content);
            string = xlc.readLink(reader, entitySet);
            if (reader == null) return string;
        }
        catch (EntityProviderException e) {
            try {
                cachedException = e;
                throw cachedException;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (XMLStreamException e2) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e2.getClass().getSimpleName()), (Throwable)e2);
                }
            }
        }
        try {
            reader.close();
            return string;
        }
        catch (XMLStreamException e) {
            if (cachedException != null) {
                throw cachedException;
            }
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> readLinks(EdmEntitySet entitySet, Object content) throws EntityProviderException {
        List<String> list;
        XMLStreamReader reader = null;
        EntityProviderException cachedException = null;
        XmlLinkConsumer xlc = new XmlLinkConsumer();
        try {
            reader = XmlHelper.createStreamReader(content);
            list = xlc.readLinks(reader, entitySet);
            if (reader == null) return list;
        }
        catch (EntityProviderException e) {
            try {
                cachedException = e;
                throw cachedException;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (XMLStreamException e2) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e2.getClass().getSimpleName()), (Throwable)e2);
                }
            }
        }
        try {
            reader.close();
            return list;
        }
        catch (XMLStreamException e) {
            if (cachedException != null) {
                throw cachedException;
            }
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }
}

