/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.consumer;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataDeltaFeed;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.aggregator.EntityPropertyInfo;
import org.apache.olingo.odata2.core.ep.consumer.JsonEntryConsumer;
import org.apache.olingo.odata2.core.ep.consumer.JsonFeedConsumer;
import org.apache.olingo.odata2.core.ep.consumer.JsonLinkConsumer;
import org.apache.olingo.odata2.core.ep.consumer.JsonPropertyConsumer;

public class JsonEntityConsumer {
    private static final String DEFAULT_CHARSET = "UTF-8";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ODataEntry readEntry(EdmEntitySet entitySet, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        ODataEntry oDataEntry;
        JsonReader reader = null;
        EntityProviderException cachedException = null;
        try {
            EntityInfoAggregator eia = EntityInfoAggregator.create(entitySet);
            reader = this.createJsonReader(content);
            oDataEntry = new JsonEntryConsumer(reader, eia, properties).readSingleEntry();
            if (reader == null) return oDataEntry;
        }
        catch (UnsupportedEncodingException e) {
            try {
                cachedException = new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
                throw cachedException;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e2.getClass().getSimpleName()), (Throwable)e2);
                }
            }
        }
        try {
            reader.close();
            return oDataEntry;
        }
        catch (IOException e) {
            if (cachedException != null) {
                throw cachedException;
            }
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    public ODataFeed readFeed(EdmEntitySet entitySet, InputStream content, EntityProviderReadProperties readProperties) throws EntityProviderException {
        return this.readDeltaFeed(entitySet, content, readProperties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ODataDeltaFeed readDeltaFeed(EdmEntitySet entitySet, InputStream content, EntityProviderReadProperties readProperties) throws EntityProviderException {
        ODataDeltaFeed oDataDeltaFeed;
        JsonReader reader = null;
        EntityProviderException cachedException = null;
        try {
            ODataDeltaFeed result;
            EntityInfoAggregator eia = EntityInfoAggregator.create(entitySet);
            reader = this.createJsonReader(content);
            JsonFeedConsumer jfc = new JsonFeedConsumer(reader, eia, readProperties);
            oDataDeltaFeed = result = jfc.readFeedStandalone();
            if (reader == null) return oDataDeltaFeed;
        }
        catch (UnsupportedEncodingException e) {
            try {
                cachedException = new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
                throw cachedException;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e2.getClass().getSimpleName()), (Throwable)e2);
                }
            }
        }
        try {
            reader.close();
            return oDataDeltaFeed;
        }
        catch (IOException e) {
            if (cachedException != null) {
                throw cachedException;
            }
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    public Map<String, Object> readProperty(EdmProperty edmProperty, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        return this.readProperty(EntityInfoAggregator.create(edmProperty), content, properties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> readProperty(EntityPropertyInfo propertyInfo, InputStream content, EntityProviderReadProperties readProperties) throws EntityProviderException {
        Map<String, Object> map;
        JsonReader reader = null;
        EntityProviderException cachedException = null;
        try {
            reader = this.createJsonReader(content);
            map = new JsonPropertyConsumer().readPropertyStandalone(reader, propertyInfo, readProperties);
            if (reader == null) return map;
        }
        catch (UnsupportedEncodingException e) {
            try {
                cachedException = new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
                throw cachedException;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e2.getClass().getSimpleName()), (Throwable)e2);
                }
            }
        }
        try {
            reader.close();
            return map;
        }
        catch (IOException e) {
            if (cachedException != null) {
                throw cachedException;
            }
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<?> readCollection(EntityPropertyInfo info, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        List<?> list;
        JsonReader reader = null;
        EntityProviderException cachedException = null;
        try {
            reader = this.createJsonReader(content);
            list = new JsonPropertyConsumer().readCollection(reader, info, properties);
            if (reader == null) return list;
        }
        catch (UnsupportedEncodingException e) {
            try {
                cachedException = new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
                throw cachedException;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e2.getClass().getSimpleName()), (Throwable)e2);
                }
            }
        }
        try {
            reader.close();
            return list;
        }
        catch (IOException e) {
            if (cachedException != null) {
                throw cachedException;
            }
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readLink(EdmEntitySet entitySet, Object content) throws EntityProviderException {
        String string;
        JsonReader reader = null;
        EntityProviderException cachedException = null;
        try {
            reader = this.createJsonReader(content);
            string = new JsonLinkConsumer().readLink(reader, entitySet);
            if (reader == null) return string;
        }
        catch (UnsupportedEncodingException e) {
            try {
                cachedException = new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
                throw cachedException;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e2.getClass().getSimpleName()), (Throwable)e2);
                }
            }
        }
        try {
            reader.close();
            return string;
        }
        catch (IOException e) {
            if (cachedException != null) {
                throw cachedException;
            }
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> readLinks(EdmEntitySet entitySet, Object content) throws EntityProviderException {
        List<String> list;
        JsonReader reader = null;
        EntityProviderException cachedException = null;
        try {
            reader = this.createJsonReader(content);
            list = new JsonLinkConsumer().readLinks(reader, entitySet);
            if (reader == null) return list;
        }
        catch (UnsupportedEncodingException e) {
            try {
                cachedException = new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
                throw cachedException;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e2.getClass().getSimpleName()), (Throwable)e2);
                }
            }
        }
        try {
            reader.close();
            return list;
        }
        catch (IOException e) {
            if (cachedException != null) {
                throw cachedException;
            }
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    private JsonReader createJsonReader(Object content) throws EntityProviderException, UnsupportedEncodingException {
        if (content == null) {
            throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent("Got not supported NULL object as content to de-serialize."));
        }
        if (content instanceof InputStream) {
            return new JsonReader((Reader)new InputStreamReader((InputStream)content, DEFAULT_CHARSET));
        }
        throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent("Found not supported content of class '" + content.getClass() + "' to de-serialize."));
    }
}

