/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.aggregator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.olingo.odata2.api.ep.EntityProviderException;

public class EntityTypeMapping {
    private static final EntityTypeMapping ENTITY_TYPE_MAPPING = new EntityTypeMapping();
    final String propertyName;
    final Class<?> mapping;
    final List<EntityTypeMapping> mappings;

    private EntityTypeMapping() {
        this(null, Object.class);
    }

    private EntityTypeMapping(String name, Class<?> mappingClass) {
        this.propertyName = name;
        this.mapping = mappingClass;
        this.mappings = Collections.emptyList();
    }

    private EntityTypeMapping(String name, List<EntityTypeMapping> typeMappings) {
        this.propertyName = name;
        this.mapping = EntityTypeMapping.class;
        ArrayList<EntityTypeMapping> tmp = new ArrayList<EntityTypeMapping>();
        for (EntityTypeMapping typeMapping : typeMappings) {
            tmp.add(typeMapping);
        }
        this.mappings = Collections.unmodifiableList(tmp);
    }

    public static EntityTypeMapping create(Map<String, Object> mappings) throws EntityProviderException {
        return EntityTypeMapping.create(null, mappings);
    }

    public static EntityTypeMapping create(String name, Map<String, Object> mappings) throws EntityProviderException {
        if (mappings == null) {
            return ENTITY_TYPE_MAPPING;
        }
        ArrayList<EntityTypeMapping> typeMappings = new ArrayList<EntityTypeMapping>();
        Set<Map.Entry<String, Object>> entries = mappings.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            EntityTypeMapping typeMapping;
            Object value = entry.getValue();
            if (value instanceof Map) {
                typeMapping = EntityTypeMapping.create(entry.getKey(), (Map)value);
            } else if (value instanceof Class) {
                typeMapping = new EntityTypeMapping(entry.getKey(), (Class)value);
            } else {
                throw new EntityProviderException(EntityProviderException.INVALID_MAPPING.addContent(entry.getKey()));
            }
            typeMappings.add(typeMapping);
        }
        return new EntityTypeMapping(name, typeMappings);
    }

    boolean isComplex() {
        return this.mappings != null && this.mapping == EntityTypeMapping.class;
    }

    public EntityTypeMapping getEntityTypeMapping(String name) {
        if (this.isComplex()) {
            for (EntityTypeMapping mappingValue : this.mappings) {
                if (!mappingValue.propertyName.equals(name)) continue;
                return mappingValue;
            }
        }
        return ENTITY_TYPE_MAPPING;
    }

    public Class<?> getMappingClass(String name) {
        if (this.isComplex()) {
            for (EntityTypeMapping mappingValue : this.mappings) {
                if (!mappingValue.propertyName.equals(name)) continue;
                return mappingValue.mapping;
            }
        }
        return null;
    }

    public String toString() {
        if (this.isComplex()) {
            return "{'" + this.propertyName + "'->" + this.mappings.toString() + "}";
        }
        return "{'" + this.propertyName + "' as " + (this.mapping == null ? "NULL" : this.mapping.getSimpleName()) + "}";
    }
}

