/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;

public class EdmDateTime
extends AbstractSimpleType {
    private static final Pattern PATTERN = Pattern.compile("(\\p{Digit}{1,4})-(\\p{Digit}{1,2})-(\\p{Digit}{1,2})T(\\p{Digit}{1,2}):(\\p{Digit}{1,2})(?::(\\p{Digit}{1,2})(\\.(\\p{Digit}{0,9}?)0*)?)?");
    private static final Pattern JSON_PATTERN = Pattern.compile("/Date\\((-?\\p{Digit}+)\\)/");
    private static final EdmDateTime instance = new EdmDateTime();

    public static EdmDateTime getInstance() {
        return instance;
    }

    @Override
    public Class<?> getDefaultType() {
        return Calendar.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected <T> T internalValueOfString(String value, EdmLiteralKind literalKind, EdmFacets facets, Class<T> returnType) throws EdmSimpleTypeException {
        String valueString;
        Matcher matcher;
        if (literalKind == EdmLiteralKind.JSON && (matcher = JSON_PATTERN.matcher(value)).matches()) {
            long millis;
            try {
                millis = Long.parseLong(matcher.group(1));
            }
            catch (NumberFormatException e) {
                throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value), (Throwable)e);
            }
            if (returnType.isAssignableFrom(Long.class)) {
                return returnType.cast(millis);
            }
            if (returnType.isAssignableFrom(Date.class)) {
                return returnType.cast(new Date(millis));
            }
            if (!returnType.isAssignableFrom(Calendar.class)) throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(returnType));
            Calendar dateTimeValue = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            dateTimeValue.clear();
            dateTimeValue.setTimeInMillis(millis);
            return returnType.cast(dateTimeValue);
        }
        Calendar dateTimeValue = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        dateTimeValue.clear();
        if (literalKind == EdmLiteralKind.URI) {
            if (value.length() <= 10 || !value.toLowerCase().startsWith("datetime'") || !value.endsWith("'")) throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value));
            valueString = value.substring(9, value.length() - 1);
        } else {
            valueString = value;
        }
        Matcher matcher2 = PATTERN.matcher(valueString);
        if (!matcher2.matches()) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value));
        }
        dateTimeValue.set(Short.parseShort(matcher2.group(1)), Byte.parseByte(matcher2.group(2)) - 1, Byte.parseByte(matcher2.group(3)), Byte.parseByte(matcher2.group(4)), Byte.parseByte(matcher2.group(5)), matcher2.group(6) == null ? 0 : (int)Byte.parseByte(matcher2.group(6)));
        int nanoSeconds = 0;
        if (matcher2.group(7) != null) {
            if (matcher2.group(7).length() == 1 || matcher2.group(7).length() > 10) {
                throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value));
            }
            String decimals = matcher2.group(8);
            if (facets != null && facets.getPrecision() != null && facets.getPrecision() < decimals.length()) {
                throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_FACETS_NOT_MATCHED.addContent(value, facets));
            }
            nanoSeconds = Integer.parseInt(decimals + "000000000".substring(decimals.length()));
            if (!returnType.isAssignableFrom(Timestamp.class)) {
                if (nanoSeconds % 1000000 == 0) {
                    dateTimeValue.set(14, nanoSeconds / 1000000);
                }
            } else if (returnType.isAssignableFrom(Timestamp.class)) {
                Timestamp tmStamp = new Timestamp(dateTimeValue.getTimeInMillis());
                tmStamp.setNanos(nanoSeconds);
                return returnType.cast(tmStamp);
            }
        }
        dateTimeValue.setLenient(false);
        try {
            dateTimeValue.get(14);
        }
        catch (IllegalArgumentException e) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value), (Throwable)e);
        }
        dateTimeValue.setLenient(true);
        if (returnType.isAssignableFrom(Calendar.class)) {
            return returnType.cast(dateTimeValue);
        }
        if (returnType.isAssignableFrom(Long.class)) {
            return returnType.cast(dateTimeValue.getTimeInMillis());
        }
        if (returnType.isAssignableFrom(Date.class)) {
            return returnType.cast(dateTimeValue.getTime());
        }
        if (!returnType.isAssignableFrom(Timestamp.class)) throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(returnType));
        Timestamp timestamp = new Timestamp(dateTimeValue.getTimeInMillis());
        if (literalKind == EdmLiteralKind.JSON) return returnType.cast(timestamp);
        timestamp.setNanos(nanoSeconds);
        return returnType.cast(timestamp);
    }

    @Override
    protected <T> String internalValueToString(T value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        long timeInMillis;
        if (value instanceof Date) {
            timeInMillis = ((Date)value).getTime();
        } else if (value instanceof Calendar) {
            timeInMillis = ((Calendar)value).getTimeInMillis();
        } else if (value instanceof Long) {
            timeInMillis = (Long)value;
        } else {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(value.getClass()));
        }
        if (literalKind == EdmLiteralKind.JSON) {
            if (value instanceof Timestamp && ((Timestamp)value).getNanos() % 1000000 != 0) {
                throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_ILLEGAL_CONTENT.addContent(value));
            }
            return "/Date(" + timeInMillis + ")/";
        }
        Calendar dateTimeValue = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        dateTimeValue.setTimeInMillis(timeInMillis);
        StringBuilder result = new StringBuilder(29);
        int year = dateTimeValue.get(1);
        EdmDateTime.appendTwoDigits(result, year / 100);
        EdmDateTime.appendTwoDigits(result, year % 100);
        result.append('-');
        EdmDateTime.appendTwoDigits(result, dateTimeValue.get(2) + 1);
        result.append('-');
        EdmDateTime.appendTwoDigits(result, dateTimeValue.get(5));
        result.append('T');
        EdmDateTime.appendTwoDigits(result, dateTimeValue.get(11));
        result.append(':');
        EdmDateTime.appendTwoDigits(result, dateTimeValue.get(12));
        result.append(':');
        EdmDateTime.appendTwoDigits(result, dateTimeValue.get(13));
        int fractionalSecs = value instanceof Timestamp ? ((Timestamp)value).getNanos() : dateTimeValue.get(14);
        try {
            EdmDateTime.appendFractionalSeconds(result, fractionalSecs, value instanceof Timestamp, facets);
        }
        catch (IllegalArgumentException e) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_FACETS_NOT_MATCHED.addContent(value, facets), (Throwable)e);
        }
        return result.toString();
    }

    private static void appendTwoDigits(StringBuilder result, int number) {
        result.append((char)(48 + number / 10));
        result.append((char)(48 + number % 10));
    }

    protected static void appendFractionalSeconds(StringBuilder result, int fractionalSeconds, boolean isNano, EdmFacets facets) throws IllegalArgumentException {
        Integer precision;
        int significantDigits = 0;
        if (fractionalSeconds > 0) {
            significantDigits = isNano ? 9 : 3;
            int output = fractionalSeconds;
            while (output % 10 == 0) {
                output /= 10;
                --significantDigits;
            }
            result.append('.');
            for (int d = 100 * (isNano ? 1000000 : 1); d > 0; d /= 10) {
                byte digit = (byte)(fractionalSeconds % (d * 10) / d);
                if (digit <= 0 && fractionalSeconds % d <= 0) continue;
                result.append((char)(48 + digit));
            }
        }
        Integer n = precision = facets == null || facets.getPrecision() == null ? null : facets.getPrecision();
        if (precision != null) {
            if (precision < significantDigits) {
                throw new IllegalArgumentException();
            }
            if (significantDigits == 0 && precision > 0) {
                result.append('.');
            }
            for (int i = significantDigits; i < precision; ++i) {
                result.append('0');
            }
        }
    }

    @Override
    public String toUriLiteral(String literal) throws EdmSimpleTypeException {
        return "datetime'" + literal + "'";
    }
}

