/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.api.processor;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.uri.PathInfo;

public class ODataErrorContext {
    private String contentType;
    private HttpStatusCodes httpStatus;
    private Exception exception;
    private Map<String, List<String>> requestHeaders;
    private PathInfo pathInfo;
    private URI requestUri;
    private String errorCode;
    private Locale locale;
    private String message;
    private String innerError;
    private String severity;
    private String target;
    private Collection<ODataErrorContext> errorDetails = new ArrayList<ODataErrorContext>();

    public ODataErrorContext() {
        this.requestHeaders = new HashMap<String, List<String>>();
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public HttpStatusCodes getHttpStatus() {
        return this.httpStatus;
    }

    public void setHttpStatus(HttpStatusCodes status) {
        this.httpStatus = status;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void putRequestHeader(String key, List<String> value) {
        this.requestHeaders.put(key, value);
    }

    public Map<String, List<String>> getRequestHeaders() {
        return Collections.unmodifiableMap(this.requestHeaders);
    }

    public List<String> getRequestHeader(String name) {
        return this.requestHeaders.get(name);
    }

    public void setRequestUri(URI requestUri) {
        this.requestUri = requestUri;
    }

    public URI getRequestUri() {
        return this.requestUri;
    }

    public String getInnerError() {
        return this.innerError;
    }

    public void setInnerError(String innerError) {
        this.innerError = innerError;
    }

    public Collection<ODataErrorContext> getErrorDetails() {
        return this.errorDetails;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setErrorDetails(Collection<ODataErrorContext> errorDetails) {
        this.errorDetails = errorDetails;
    }

    public PathInfo getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(PathInfo pathInfo) {
        this.pathInfo = pathInfo;
    }
}

