/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.consumer;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.core.ep.consumer.JsonFeedConsumer;
import org.apache.olingo.odata2.core.ep.feed.FeedMetadataImpl;
import org.apache.olingo.odata2.core.ep.util.JsonExceptionHandler;

public class JsonLinkConsumer {
    public String readLink(JsonReader reader, EdmEntitySet entitySet) throws EntityProviderException {
        String result = null;
        try {
            reader.beginObject();
            String nextName = reader.nextName();
            boolean wrapped = "d".equals(nextName);
            if (wrapped) {
                reader.beginObject();
                nextName = reader.nextName();
            }
            if (!"uri".equals(nextName) || reader.peek() != JsonToken.STRING) {
                throw new EntityProviderException(EntityProviderException.INVALID_CONTENT.addContent("d or uri").addContent(nextName));
            }
            result = reader.nextString();
            reader.endObject();
            if (wrapped) {
                reader.endObject();
            }
            reader.peek();
        }
        catch (IOException e) {
            JsonExceptionHandler.handle(e);
        }
        catch (IllegalStateException e) {
            JsonExceptionHandler.handle(e);
        }
        return result;
    }

    public List<String> readLinks(JsonReader reader, EdmEntitySet entitySet) throws EntityProviderException {
        List<String> links = null;
        int openedObjects = 0;
        try {
            String nextName;
            if (reader.peek() == JsonToken.BEGIN_ARRAY) {
                nextName = "results";
            } else {
                reader.beginObject();
                ++openedObjects;
                nextName = reader.nextName();
            }
            if ("d".equals(nextName)) {
                if (reader.peek() == JsonToken.BEGIN_ARRAY) {
                    nextName = "results";
                } else {
                    reader.beginObject();
                    ++openedObjects;
                    nextName = reader.nextName();
                }
            }
            FeedMetadataImpl feedMetadata = new FeedMetadataImpl();
            if ("__count".equals(nextName)) {
                JsonFeedConsumer.readInlineCount(reader, feedMetadata);
                nextName = reader.nextName();
            }
            if (!"results".equals(nextName)) {
                throw new EntityProviderException(EntityProviderException.INVALID_CONTENT.addContent("results").addContent(nextName));
            }
            links = this.readLinksArray(reader);
            if (reader.hasNext() && reader.peek() == JsonToken.NAME) {
                if ("__count".equals(reader.nextName())) {
                    JsonFeedConsumer.readInlineCount(reader, feedMetadata);
                } else {
                    throw new EntityProviderException(EntityProviderException.INVALID_CONTENT.addContent("__count").addContent(nextName));
                }
            }
            while (openedObjects > 0) {
                reader.endObject();
                --openedObjects;
            }
            reader.peek();
        }
        catch (IOException e) {
            JsonExceptionHandler.handle(e);
        }
        catch (IllegalStateException e) {
            JsonExceptionHandler.handle(e);
        }
        return links;
    }

    private List<String> readLinksArray(JsonReader reader) throws IOException, EntityProviderException {
        ArrayList<String> links = new ArrayList<String>();
        reader.beginArray();
        while (reader.hasNext()) {
            reader.beginObject();
            String nextName = reader.nextName();
            if (!"uri".equals(nextName) || reader.peek() != JsonToken.STRING) {
                throw new EntityProviderException(EntityProviderException.INVALID_CONTENT.addContent("uri").addContent(nextName));
            }
            links.add(reader.nextString());
            reader.endObject();
        }
        reader.endArray();
        return links;
    }
}

