/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;
import org.apache.olingo.odata2.core.edm.Bit;
import org.apache.olingo.odata2.core.edm.EdmByte;
import org.apache.olingo.odata2.core.edm.EdmDouble;
import org.apache.olingo.odata2.core.edm.EdmInt16;
import org.apache.olingo.odata2.core.edm.EdmInt32;
import org.apache.olingo.odata2.core.edm.EdmInt64;
import org.apache.olingo.odata2.core.edm.EdmSByte;
import org.apache.olingo.odata2.core.edm.EdmSingle;
import org.apache.olingo.odata2.core.edm.Uint7;

public class EdmDecimal
extends AbstractSimpleType {
    private static final Pattern PATTERN = Pattern.compile("(?:\\+|-)?(?:0*(\\p{Digit}+?))(?:\\.(\\p{Digit}+?)0*)?(M|m)?");
    private static final EdmDecimal instance = new EdmDecimal();

    public static EdmDecimal getInstance() {
        return instance;
    }

    @Override
    public boolean isCompatible(EdmSimpleType simpleType) {
        return simpleType instanceof Bit || simpleType instanceof Uint7 || simpleType instanceof EdmByte || simpleType instanceof EdmSByte || simpleType instanceof EdmInt16 || simpleType instanceof EdmInt32 || simpleType instanceof EdmInt64 || simpleType instanceof EdmSingle || simpleType instanceof EdmDouble || simpleType instanceof EdmDecimal;
    }

    @Override
    public Class<?> getDefaultType() {
        return BigDecimal.class;
    }

    @Override
    public boolean validate(String value, EdmLiteralKind literalKind, EdmFacets facets) {
        if (value == null) {
            return facets == null || facets.isNullable() == null || facets.isNullable() != false;
        }
        if (literalKind == null) {
            return false;
        }
        return EdmDecimal.validateLiteral(value, literalKind) && EdmDecimal.validatePrecisionAndScale(value, facets);
    }

    private static boolean validateLiteral(String value, EdmLiteralKind literalKind) {
        Matcher matcher = PATTERN.matcher(value);
        return matcher.matches() && literalKind == EdmLiteralKind.URI != (matcher.group(3) == null);
    }

    private static boolean validatePrecisionAndScale(String value, EdmFacets facets) {
        if (facets == null || facets.getPrecision() == null && facets.getScale() == null) {
            return true;
        }
        Matcher matcher = PATTERN.matcher(value);
        matcher.matches();
        int significantIntegerDigits = "0".equals(matcher.group(1)) ? 0 : matcher.group(1).length();
        int decimals = matcher.group(2) == null ? 0 : matcher.group(2).length();
        return !(facets.getPrecision() != null && facets.getPrecision() < significantIntegerDigits + decimals || facets.getScale() != null && facets.getScale() < decimals);
    }

    @Override
    protected <T> T internalValueOfString(String value, EdmLiteralKind literalKind, EdmFacets facets, Class<T> returnType) throws EdmSimpleTypeException {
        if (!EdmDecimal.validateLiteral(value, literalKind)) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value));
        }
        if (!EdmDecimal.validatePrecisionAndScale(value, facets)) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_FACETS_NOT_MATCHED.addContent(value, facets));
        }
        BigDecimal valueBigDecimal = new BigDecimal(literalKind == EdmLiteralKind.URI ? value.substring(0, value.length() - 1) : value);
        if (returnType.isAssignableFrom(BigDecimal.class)) {
            return returnType.cast(valueBigDecimal);
        }
        if (returnType.isAssignableFrom(Double.class)) {
            if (BigDecimal.valueOf(valueBigDecimal.doubleValue()).compareTo(valueBigDecimal) == 0) {
                return returnType.cast(valueBigDecimal.doubleValue());
            }
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_UNCONVERTIBLE_TO_VALUE_TYPE.addContent(value, returnType));
        }
        if (returnType.isAssignableFrom(Float.class)) {
            if (BigDecimal.valueOf(valueBigDecimal.floatValue()).compareTo(valueBigDecimal) == 0) {
                return returnType.cast(Float.valueOf(valueBigDecimal.floatValue()));
            }
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_UNCONVERTIBLE_TO_VALUE_TYPE.addContent(value, returnType));
        }
        try {
            if (returnType.isAssignableFrom(BigInteger.class)) {
                return returnType.cast(valueBigDecimal.toBigIntegerExact());
            }
            if (returnType.isAssignableFrom(Long.class)) {
                return returnType.cast(valueBigDecimal.longValueExact());
            }
            if (returnType.isAssignableFrom(Integer.class)) {
                return returnType.cast(valueBigDecimal.intValueExact());
            }
            if (returnType.isAssignableFrom(Short.class)) {
                return returnType.cast(valueBigDecimal.shortValueExact());
            }
            if (returnType.isAssignableFrom(Byte.class)) {
                return returnType.cast(valueBigDecimal.byteValueExact());
            }
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(returnType));
        }
        catch (ArithmeticException e) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_UNCONVERTIBLE_TO_VALUE_TYPE.addContent(value, returnType), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected <T> String internalValueToString(T value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        BigDecimal bigDecimalValue;
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof BigInteger) {
            String result = value.toString();
            int digits = result.startsWith("-") ? result.length() - 1 : result.length();
            if (facets == null) return result;
            if (facets.getPrecision() == null) return result;
            if (facets.getPrecision() >= digits) return result;
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_FACETS_NOT_MATCHED.addContent(value, facets));
        }
        if (!(value instanceof Double) && !(value instanceof Float) && !(value instanceof BigDecimal)) throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(value.getClass()));
        try {
            bigDecimalValue = value instanceof Double ? BigDecimal.valueOf((Double)value) : (value instanceof Float ? BigDecimal.valueOf(((Float)value).floatValue()) : (BigDecimal)value);
        }
        catch (NumberFormatException e) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_ILLEGAL_CONTENT.addContent(value), (Throwable)e);
        }
        int digits = bigDecimalValue.scale() >= 0 ? Math.max(bigDecimalValue.precision(), bigDecimalValue.scale()) : bigDecimalValue.precision() - bigDecimalValue.scale();
        if (facets == null) return bigDecimalValue.toPlainString();
        if (facets.getPrecision() != null && facets.getPrecision() < digits) throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_FACETS_NOT_MATCHED.addContent(value, facets));
        if (facets.getScale() == null) return bigDecimalValue.toPlainString();
        if (facets.getScale() < bigDecimalValue.scale()) throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_FACETS_NOT_MATCHED.addContent(value, facets));
        return bigDecimalValue.toPlainString();
    }

    @Override
    public String toUriLiteral(String literal) throws EdmSimpleTypeException {
        return literal + "M";
    }
}

