/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core;

import java.io.InputStream;
import org.apache.olingo.odata2.api.ODataService;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.commons.ODataHttpMethod;
import org.apache.olingo.odata2.api.exception.ODataBadRequestException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataMethodNotAllowedException;
import org.apache.olingo.odata2.api.processor.ODataProcessor;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.processor.part.BatchProcessor;
import org.apache.olingo.odata2.api.processor.part.EntityComplexPropertyProcessor;
import org.apache.olingo.odata2.api.processor.part.EntityLinkProcessor;
import org.apache.olingo.odata2.api.processor.part.EntityLinksProcessor;
import org.apache.olingo.odata2.api.processor.part.EntityMediaProcessor;
import org.apache.olingo.odata2.api.processor.part.EntityProcessor;
import org.apache.olingo.odata2.api.processor.part.EntitySetProcessor;
import org.apache.olingo.odata2.api.processor.part.EntitySimplePropertyProcessor;
import org.apache.olingo.odata2.api.processor.part.EntitySimplePropertyValueProcessor;
import org.apache.olingo.odata2.api.processor.part.FunctionImportProcessor;
import org.apache.olingo.odata2.api.processor.part.FunctionImportValueProcessor;
import org.apache.olingo.odata2.api.processor.part.MetadataProcessor;
import org.apache.olingo.odata2.api.processor.part.ServiceDocumentProcessor;
import org.apache.olingo.odata2.core.batch.BatchHandlerImpl;
import org.apache.olingo.odata2.core.exception.ODataRuntimeException;
import org.apache.olingo.odata2.core.uri.UriInfoImpl;
import org.apache.olingo.odata2.core.uri.UriType;

public class Dispatcher {
    private final ODataService service;
    private final ODataServiceFactory serviceFactory;

    public Dispatcher(ODataServiceFactory serviceFactory, ODataService service) {
        this.service = service;
        this.serviceFactory = serviceFactory;
    }

    public ODataResponse dispatch(ODataHttpMethod method, UriInfoImpl uriInfo, InputStream content, String requestContentType, String contentType) throws ODataException {
        switch (uriInfo.getUriType()) {
            case URI0: {
                if (method == ODataHttpMethod.GET) {
                    return this.service.getServiceDocumentProcessor().readServiceDocument(uriInfo, contentType);
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI1: 
            case URI6B: {
                switch (method) {
                    case GET: {
                        return this.service.getEntitySetProcessor().readEntitySet(uriInfo, contentType);
                    }
                    case POST: {
                        return this.service.getEntitySetProcessor().createEntity(uriInfo, content, requestContentType, contentType);
                    }
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI2: {
                switch (method) {
                    case GET: {
                        return this.service.getEntityProcessor().readEntity(uriInfo, contentType);
                    }
                    case PUT: {
                        return this.service.getEntityProcessor().updateEntity(uriInfo, content, requestContentType, false, contentType);
                    }
                    case PATCH: 
                    case MERGE: {
                        return this.service.getEntityProcessor().updateEntity(uriInfo, content, requestContentType, true, contentType);
                    }
                    case DELETE: {
                        return this.service.getEntityProcessor().deleteEntity(uriInfo, contentType);
                    }
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI3: {
                switch (method) {
                    case GET: {
                        return this.service.getEntityComplexPropertyProcessor().readEntityComplexProperty(uriInfo, contentType);
                    }
                    case PUT: {
                        return this.service.getEntityComplexPropertyProcessor().updateEntityComplexProperty(uriInfo, content, requestContentType, false, contentType);
                    }
                    case PATCH: 
                    case MERGE: {
                        return this.service.getEntityComplexPropertyProcessor().updateEntityComplexProperty(uriInfo, content, requestContentType, true, contentType);
                    }
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI4: 
            case URI5: {
                switch (method) {
                    case GET: {
                        if (uriInfo.isValue()) {
                            return this.service.getEntitySimplePropertyValueProcessor().readEntitySimplePropertyValue(uriInfo, contentType);
                        }
                        return this.service.getEntitySimplePropertyProcessor().readEntitySimpleProperty(uriInfo, contentType);
                    }
                    case PUT: 
                    case PATCH: 
                    case MERGE: {
                        if (uriInfo.isValue()) {
                            return this.service.getEntitySimplePropertyValueProcessor().updateEntitySimplePropertyValue(uriInfo, content, requestContentType, contentType);
                        }
                        return this.service.getEntitySimplePropertyProcessor().updateEntitySimpleProperty(uriInfo, content, requestContentType, contentType);
                    }
                    case DELETE: {
                        if (uriInfo.isValue()) {
                            return this.service.getEntitySimplePropertyValueProcessor().deleteEntitySimplePropertyValue(uriInfo, contentType);
                        }
                        throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
                    }
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI6A: {
                switch (method) {
                    case GET: {
                        return this.service.getEntityProcessor().readEntity(uriInfo, contentType);
                    }
                    case PUT: 
                    case PATCH: 
                    case MERGE: 
                    case DELETE: {
                        throw new ODataBadRequestException(ODataBadRequestException.NOTSUPPORTED);
                    }
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI7A: {
                switch (method) {
                    case GET: {
                        return this.service.getEntityLinkProcessor().readEntityLink(uriInfo, contentType);
                    }
                    case PUT: 
                    case PATCH: 
                    case MERGE: {
                        return this.service.getEntityLinkProcessor().updateEntityLink(uriInfo, content, requestContentType, contentType);
                    }
                    case DELETE: {
                        return this.service.getEntityLinkProcessor().deleteEntityLink(uriInfo, contentType);
                    }
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI7B: {
                switch (method) {
                    case GET: {
                        return this.service.getEntityLinksProcessor().readEntityLinks(uriInfo, contentType);
                    }
                    case POST: {
                        return this.service.getEntityLinksProcessor().createEntityLink(uriInfo, content, requestContentType, contentType);
                    }
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI8: {
                if (method == ODataHttpMethod.GET) {
                    return this.service.getMetadataProcessor().readMetadata(uriInfo, contentType);
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI9: {
                if (method == ODataHttpMethod.POST) {
                    BatchHandlerImpl handler = new BatchHandlerImpl(this.serviceFactory, this.service);
                    return this.service.getBatchProcessor().executeBatch(handler, requestContentType, content);
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI10: 
            case URI10a: 
            case URI11: 
            case URI12: 
            case URI13: {
                return this.service.getFunctionImportProcessor().executeFunctionImport(uriInfo, contentType);
            }
            case URI14: {
                if (uriInfo.isValue()) {
                    return this.service.getFunctionImportValueProcessor().executeFunctionImportValue(uriInfo, contentType);
                }
                return this.service.getFunctionImportProcessor().executeFunctionImport(uriInfo, contentType);
            }
            case URI15: {
                if (method == ODataHttpMethod.GET) {
                    return this.service.getEntitySetProcessor().countEntitySet(uriInfo, contentType);
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI16: {
                if (method == ODataHttpMethod.GET) {
                    return this.service.getEntityProcessor().existsEntity(uriInfo, contentType);
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI17: {
                switch (method) {
                    case GET: {
                        return this.service.getEntityMediaProcessor().readEntityMedia(uriInfo, contentType);
                    }
                    case PUT: {
                        return this.service.getEntityMediaProcessor().updateEntityMedia(uriInfo, content, requestContentType, contentType);
                    }
                    case DELETE: {
                        return this.service.getEntityMediaProcessor().deleteEntityMedia(uriInfo, contentType);
                    }
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI50A: {
                if (method == ODataHttpMethod.GET) {
                    return this.service.getEntityLinkProcessor().existsEntityLink(uriInfo, contentType);
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI50B: {
                if (method == ODataHttpMethod.GET) {
                    return this.service.getEntityLinksProcessor().countEntityLinks(uriInfo, contentType);
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
        }
        throw new ODataRuntimeException("Unknown or not implemented URI type: " + uriInfo.getUriType());
    }

    protected static Class<? extends ODataProcessor> mapUriTypeToProcessorFeature(UriInfoImpl uriInfo) {
        return switch (uriInfo.getUriType()) {
            case UriType.URI0 -> ServiceDocumentProcessor.class;
            case UriType.URI1, UriType.URI6B, UriType.URI15 -> EntitySetProcessor.class;
            case UriType.URI2, UriType.URI6A, UriType.URI16 -> EntityProcessor.class;
            case UriType.URI3 -> EntityComplexPropertyProcessor.class;
            case UriType.URI4, UriType.URI5 -> uriInfo.isValue() ? EntitySimplePropertyValueProcessor.class : EntitySimplePropertyProcessor.class;
            case UriType.URI7A, UriType.URI50A -> EntityLinkProcessor.class;
            case UriType.URI7B, UriType.URI50B -> EntityLinksProcessor.class;
            case UriType.URI8 -> MetadataProcessor.class;
            case UriType.URI9 -> BatchProcessor.class;
            case UriType.URI10, UriType.URI10a, UriType.URI11, UriType.URI12, UriType.URI13 -> FunctionImportProcessor.class;
            case UriType.URI14 -> uriInfo.isValue() ? FunctionImportValueProcessor.class : FunctionImportProcessor.class;
            case UriType.URI17 -> EntityMediaProcessor.class;
            default -> throw new ODataRuntimeException("Unknown or not implemented URI type: " + uriInfo.getUriType());
        };
    }
}

