/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import java.math.BigInteger;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;
import org.apache.olingo.odata2.core.edm.Bit;
import org.apache.olingo.odata2.core.edm.EdmByte;
import org.apache.olingo.odata2.core.edm.EdmInt16;
import org.apache.olingo.odata2.core.edm.EdmInt32;
import org.apache.olingo.odata2.core.edm.EdmSByte;
import org.apache.olingo.odata2.core.edm.Uint7;

public class EdmInt64
extends AbstractSimpleType {
    private static final EdmInt64 instance = new EdmInt64();

    public static EdmInt64 getInstance() {
        return instance;
    }

    @Override
    public boolean isCompatible(EdmSimpleType simpleType) {
        return simpleType instanceof Bit || simpleType instanceof Uint7 || simpleType instanceof EdmByte || simpleType instanceof EdmSByte || simpleType instanceof EdmInt16 || simpleType instanceof EdmInt32 || simpleType instanceof EdmInt64;
    }

    @Override
    public Class<?> getDefaultType() {
        return Long.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected <T> T internalValueOfString(String value, EdmLiteralKind literalKind, EdmFacets facets, Class<T> returnType) throws EdmSimpleTypeException {
        Long valueLong;
        try {
            if (literalKind == EdmLiteralKind.URI) {
                if (!value.endsWith("L") && !value.endsWith("l")) throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value));
                valueLong = Long.parseLong(value.substring(0, value.length() - 1));
            } else {
                valueLong = Long.parseLong(value);
            }
        }
        catch (NumberFormatException e) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value), (Throwable)e);
        }
        if (returnType.isAssignableFrom(Long.class)) {
            return returnType.cast(valueLong);
        }
        if (returnType.isAssignableFrom(Byte.class)) {
            if (valueLong < -128L || valueLong > 127L) throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_UNCONVERTIBLE_TO_VALUE_TYPE.addContent(value, returnType));
            return returnType.cast(valueLong.byteValue());
        }
        if (returnType.isAssignableFrom(Short.class)) {
            if (valueLong < -32768L || valueLong > 32767L) throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_UNCONVERTIBLE_TO_VALUE_TYPE.addContent(value, returnType));
            return returnType.cast(valueLong.shortValue());
        }
        if (returnType.isAssignableFrom(Integer.class)) {
            if (valueLong < Integer.MIN_VALUE || valueLong > Integer.MAX_VALUE) throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_UNCONVERTIBLE_TO_VALUE_TYPE.addContent(value, returnType));
            return returnType.cast(valueLong.intValue());
        }
        if (!returnType.isAssignableFrom(BigInteger.class)) throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(returnType));
        return returnType.cast(BigInteger.valueOf(valueLong));
    }

    @Override
    protected <T> String internalValueToString(T value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return value.toString();
        }
        if (value instanceof BigInteger) {
            if (((BigInteger)value).bitLength() < 64) {
                return value.toString();
            }
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_ILLEGAL_CONTENT.addContent(value));
        }
        throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(value.getClass()));
    }

    @Override
    public String toUriLiteral(String literal) {
        return literal + "L";
    }
}

