/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm.provider;

import org.apache.olingo.odata2.api.edm.EdmAnnotatable;
import org.apache.olingo.odata2.api.edm.EdmAnnotations;
import org.apache.olingo.odata2.api.edm.EdmAssociation;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.edm.provider.NavigationProperty;
import org.apache.olingo.odata2.core.edm.provider.EdmAnnotationsImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmAssociationImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmTypedImplProv;

public class EdmNavigationPropertyImplProv
extends EdmTypedImplProv
implements EdmNavigationProperty,
EdmAnnotatable {
    private NavigationProperty navigationProperty;
    private EdmAnnotations annotations;

    public EdmNavigationPropertyImplProv(EdmImplProv edm, NavigationProperty property) throws EdmException {
        super(edm, property.getName(), null, null);
        this.navigationProperty = property;
    }

    @Override
    public EdmType getType() throws EdmException {
        return this.getRelationship().getEnd(this.navigationProperty.getToRole()).getEntityType();
    }

    @Override
    public EdmMultiplicity getMultiplicity() throws EdmException {
        return ((EdmAssociationImplProv)this.getRelationship()).getEndMultiplicity(this.navigationProperty.getToRole());
    }

    @Override
    public EdmAssociation getRelationship() throws EdmException {
        FullQualifiedName relationship = this.navigationProperty.getRelationship();
        return this.edm.getAssociation(relationship.getNamespace(), relationship.getName());
    }

    @Override
    public String getFromRole() throws EdmException {
        return this.navigationProperty.getFromRole();
    }

    @Override
    public String getToRole() throws EdmException {
        return this.navigationProperty.getToRole();
    }

    @Override
    public EdmAnnotations getAnnotations() throws EdmException {
        if (this.annotations == null) {
            this.annotations = new EdmAnnotationsImplProv(this.navigationProperty.getAnnotationAttributes(), this.navigationProperty.getAnnotationElements());
        }
        return this.annotations;
    }

    @Override
    public EdmMapping getMapping() throws EdmException {
        return this.navigationProperty.getMapping();
    }
}

