/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.commons;

import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerFactory;
import org.apache.olingo.odata2.api.ep.EntityProviderException;

public class XmlHelper {
    private static final String DEFAULT_CHARSET = "UTF-8";

    public static XMLInputFactory getXMLInputFactory() {
        return XmlInputFactoryHolder.INSTANCE;
    }

    public static XMLOutputFactory getXMLOutputFactory() {
        return XmlOutputFactoryHolder.INSTANCE;
    }

    public static TransformerFactory getTransformerFactory() {
        return TransformerFactoryHolder.INSTANCE;
    }

    public static XMLStreamReader createStreamReader(Object content) throws EntityProviderException {
        if (content == null) {
            throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent("Got not allowed NULL parameter for creation of XMLStreamReader."));
        }
        try {
            XMLStreamReader streamReader;
            XMLInputFactory factory = XmlHelper.getXMLInputFactory();
            factory.setProperty("javax.xml.stream.isValidating", false);
            factory.setProperty("javax.xml.stream.isNamespaceAware", true);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            factory.setProperty("javax.xml.stream.supportDTD", false);
            if (content instanceof InputStream) {
                streamReader = factory.createXMLStreamReader((InputStream)content, DEFAULT_CHARSET);
                String characterEncodingInContent = streamReader.getCharacterEncodingScheme();
                if (characterEncodingInContent != null && !DEFAULT_CHARSET.equalsIgnoreCase(characterEncodingInContent)) {
                    throw new EntityProviderException(EntityProviderException.UNSUPPORTED_CHARACTER_ENCODING.addContent(characterEncodingInContent));
                }
            } else {
                throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent("Found not supported content of class '" + content.getClass() + "' to de-serialize."));
            }
            return streamReader;
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    static class XmlInputFactoryHolder {
        private static final XMLInputFactory INSTANCE = XMLInputFactory.newInstance();

        XmlInputFactoryHolder() {
        }
    }

    static class XmlOutputFactoryHolder {
        private static final XMLOutputFactory INSTANCE = XMLOutputFactory.newInstance();

        XmlOutputFactoryHolder() {
        }
    }

    static class TransformerFactoryHolder {
        private static final TransformerFactory INSTANCE = TransformerFactory.newInstance();

        TransformerFactoryHolder() {
        }
    }
}

