/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm.provider;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmNamed;
import org.apache.olingo.odata2.core.edm.provider.EdmImplProv;

public abstract class EdmNamedImplProv
implements EdmNamed {
    private static final Pattern PATTERN_VALID_NAME = Pattern.compile("\\A[_\\p{L}\\p{Nl}][_\\p{L}\\p{Nl}\\p{Nd}\\p{Mn}\\p{Mc}\\p{Pc}\\p{Cf}]{0,}\\Z");
    protected EdmImplProv edm;
    private String name;

    public EdmNamedImplProv(EdmImplProv edm, String name) throws EdmException {
        this.edm = edm;
        this.name = this.getValidatedName(name);
    }

    @Override
    public String getName() throws EdmException {
        return this.name;
    }

    private String getValidatedName(String name) throws EdmException {
        Matcher matcher = PATTERN_VALID_NAME.matcher(name);
        if (matcher.matches()) {
            return name;
        }
        throw new EdmException(EdmException.NAMINGERROR.addContent(name));
    }
}

