/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.producer;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.core.ep.EntityProviderProducerException;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.producer.AtomEntryEntityProducer;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;

public class JsonLinkEntityProducer {
    private final EntityProviderWriteProperties properties;

    public JsonLinkEntityProducer(EntityProviderWriteProperties properties) throws EntityProviderException {
        this.properties = properties == null ? EntityProviderWriteProperties.serviceRoot(null).build() : properties;
    }

    public void append(Writer writer, EntityInfoAggregator entityInfo, Map<String, Object> data) throws EntityProviderException {
        JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
        String uri = (this.properties.getServiceRoot() == null ? "" : this.properties.getServiceRoot().toASCIIString()) + AtomEntryEntityProducer.createSelfLink(entityInfo, data, null);
        try {
            if (!this.properties.isOmitJsonWrapper()) {
                jsonStreamWriter.beginObject().name("d");
            }
            JsonLinkEntityProducer.appendUri(jsonStreamWriter, uri);
            if (!this.properties.isOmitJsonWrapper()) {
                jsonStreamWriter.endObject();
            }
        }
        catch (IOException e) {
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    protected static void appendUri(JsonStreamWriter jsonStreamWriter, String uri) throws IOException {
        jsonStreamWriter.beginObject().namedStringValue("uri", uri).endObject();
    }
}

