/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.client.api.edm.xml.DataServices;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlAbstractEdmItem;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;

@JsonDeserialize(using=DataServicesDeserializer.class)
class ClientCsdlDataServices
extends CsdlAbstractEdmItem
implements Serializable,
DataServices {
    private static final long serialVersionUID = 4200317286476885204L;
    private final List<CsdlSchema> schemas = new ArrayList<CsdlSchema>();
    private String dataServiceVersion;
    private String maxDataServiceVersion;

    ClientCsdlDataServices() {
    }

    @Override
    public String getDataServiceVersion() {
        return this.dataServiceVersion;
    }

    public void setDataServiceVersion(String version) {
        this.dataServiceVersion = version;
    }

    @Override
    public String getMaxDataServiceVersion() {
        return this.maxDataServiceVersion;
    }

    public void setMaxDataServiceVersion(String version) {
        this.maxDataServiceVersion = version;
    }

    @Override
    public List<CsdlSchema> getSchemas() {
        return this.schemas;
    }

    static class DataServicesDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlDataServices> {
        DataServicesDeserializer() {
        }

        @Override
        protected ClientCsdlDataServices doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlDataServices dataServices = new ClientCsdlDataServices();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("DataServiceVersion".equals(jp.getCurrentName())) {
                        dataServices.setDataServiceVersion(jp.nextTextValue());
                    } else if ("MaxDataServiceVersion".equals(jp.getCurrentName())) {
                        dataServices.setMaxDataServiceVersion(jp.nextTextValue());
                    } else if ("Schema".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        dataServices.getSchemas().add((CsdlSchema)jp.readValueAs(ClientCsdlSchema.class));
                    }
                }
                jp.nextToken();
            }
            return dataServices;
        }
    }
}

