/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.annotation;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.client.core.edm.xml.annotation.ClientCsdlDynamicExpression;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlIsOf;

@JsonDeserialize(using=IsOfDeserializer.class)
class ClientCsdlIsOf
extends CsdlIsOf
implements Serializable {
    private static final long serialVersionUID = -893355856129761174L;

    ClientCsdlIsOf() {
    }

    static class IsOfDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlIsOf> {
        IsOfDeserializer() {
        }

        @Override
        protected ClientCsdlIsOf doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlIsOf isof = new ClientCsdlIsOf();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Type".equals(jp.getCurrentName())) {
                        isof.setType(jp.nextTextValue());
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        isof.getAnnotations().add((CsdlAnnotation)jp.readValueAs(ClientCsdlAnnotation.class));
                    } else if ("MaxLength".equals(jp.getCurrentName())) {
                        String maxLenght = jp.nextTextValue();
                        isof.setMaxLength("max".equalsIgnoreCase(maxLenght) ? Integer.MAX_VALUE : Integer.valueOf(maxLenght));
                    } else if ("Precision".equals(jp.getCurrentName())) {
                        isof.setPrecision(Integer.valueOf(jp.nextTextValue()));
                    } else if ("Scale".equals(jp.getCurrentName())) {
                        String scale = jp.nextTextValue();
                        isof.setScale("variable".equalsIgnoreCase(scale) || "floating".equalsIgnoreCase(scale) ? 0 : Integer.valueOf(scale));
                    } else if ("SRID".equals(jp.getCurrentName())) {
                        String srid = jp.nextTextValue();
                        if (srid != null) {
                            isof.setSrid(SRID.valueOf(srid));
                        }
                    } else {
                        isof.setValue((CsdlExpression)jp.readValueAs(ClientCsdlDynamicExpression.class));
                    }
                }
                jp.nextToken();
            }
            return isof;
        }
    }
}

