/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.http;

import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.olingo.client.api.http.HttpClientFactory;
import org.apache.olingo.client.api.http.WrappingHttpClientFactory;
import org.apache.olingo.client.core.http.AbstractHttpClientFactory;
import org.apache.olingo.client.core.http.DefaultHttpClientFactory;
import org.apache.olingo.client.core.http.OAuth2Exception;
import org.apache.olingo.commons.api.http.HttpMethod;

public abstract class AbstractOAuth2HttpClientFactory
extends AbstractHttpClientFactory
implements WrappingHttpClientFactory {
    protected final DefaultHttpClientFactory wrapped;
    protected final URI oauth2GrantServiceURI;
    protected final URI oauth2TokenServiceURI;
    protected HttpUriRequest currentRequest;
    private DefaultHttpClient httpClient;

    public AbstractOAuth2HttpClientFactory(URI oauth2GrantServiceURI, URI oauth2TokenServiceURI) {
        this(new DefaultHttpClientFactory(), oauth2GrantServiceURI, oauth2TokenServiceURI);
    }

    public AbstractOAuth2HttpClientFactory(DefaultHttpClientFactory wrapped, URI oauth2GrantServiceURI, URI oauth2TokenServiceURI) {
        this.wrapped = wrapped;
        this.oauth2GrantServiceURI = oauth2GrantServiceURI;
        this.oauth2TokenServiceURI = oauth2TokenServiceURI;
    }

    @Override
    public HttpClientFactory getWrappedHttpClientFactory() {
        return this.wrapped;
    }

    protected abstract boolean isInited() throws OAuth2Exception;

    protected abstract void init() throws OAuth2Exception;

    protected void accessToken(HttpClientBuilder clientBuilder) throws OAuth2Exception {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.getParams().setParameter("http.useragent", (Object)USER_AGENT);
        this.accessToken(httpClient);
        httpClient.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                AbstractOAuth2HttpClientFactory.this.currentRequest = request instanceof HttpUriRequest ? (HttpUriRequest)request : null;
            }
        });
        this.setHttpClient(httpClient);
    }

    private void setHttpClient(DefaultHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    private DefaultHttpClient getHttpClient() {
        return this.httpClient;
    }

    protected void refreshToken(HttpClientBuilder client) throws OAuth2Exception {
        DefaultHttpClient httpClient = this.getHttpClient();
        this.refreshToken(httpClient);
        this.setHttpClient(httpClient);
    }

    @Deprecated
    protected abstract void accessToken(DefaultHttpClient var1) throws OAuth2Exception;

    @Deprecated
    protected abstract void refreshToken(DefaultHttpClient var1) throws OAuth2Exception;

    @Override
    public HttpClient create(HttpMethod method, URI uri) {
        if (!this.isInited()) {
            this.init();
        }
        try {
            Class.forName("org.apache.http.impl.client.HttpClientBuilder");
            final HttpClientBuilder clientBuilder = HttpClientBuilder.create();
            clientBuilder.setUserAgent(USER_AGENT);
            this.accessToken(clientBuilder);
            if (null == this.httpClient) {
                clientBuilder.addInterceptorFirst(new HttpRequestInterceptor(){

                    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                        AbstractOAuth2HttpClientFactory.this.currentRequest = request instanceof HttpUriRequest ? (HttpUriRequest)request : null;
                    }
                });
                clientBuilder.addInterceptorFirst(new HttpResponseInterceptor(){

                    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                        if (response.getStatusLine().getStatusCode() == 401) {
                            AbstractOAuth2HttpClientFactory.this.refreshToken(clientBuilder);
                            if (AbstractOAuth2HttpClientFactory.this.currentRequest != null) {
                                clientBuilder.build().execute(AbstractOAuth2HttpClientFactory.this.currentRequest);
                            }
                        }
                    }
                });
                return clientBuilder.build();
            }
            this.httpClient.addResponseInterceptor(new HttpResponseInterceptor(){

                public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                    if (response.getStatusLine().getStatusCode() == 401) {
                        AbstractOAuth2HttpClientFactory.this.refreshToken(AbstractOAuth2HttpClientFactory.this.httpClient);
                        if (AbstractOAuth2HttpClientFactory.this.currentRequest != null) {
                            AbstractOAuth2HttpClientFactory.this.httpClient.execute(AbstractOAuth2HttpClientFactory.this.currentRequest);
                        }
                    }
                }
            });
            return this.httpClient;
        }
        catch (ClassNotFoundException e) {
            final DefaultHttpClient _httpClient = new DefaultHttpClient();
            _httpClient.getParams().setParameter("http.useragent", (Object)USER_AGENT);
            this.accessToken(_httpClient);
            _httpClient.addRequestInterceptor(new HttpRequestInterceptor(){

                public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                    AbstractOAuth2HttpClientFactory.this.currentRequest = request instanceof HttpUriRequest ? (HttpUriRequest)request : null;
                }
            });
            _httpClient.addResponseInterceptor(new HttpResponseInterceptor(){

                public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                    if (response.getStatusLine().getStatusCode() == 401) {
                        AbstractOAuth2HttpClientFactory.this.refreshToken(_httpClient);
                        if (AbstractOAuth2HttpClientFactory.this.currentRequest != null) {
                            _httpClient.execute(AbstractOAuth2HttpClientFactory.this.currentRequest);
                        }
                    }
                }
            });
            return _httpClient;
        }
    }

    @Override
    public void close(HttpClient httpClient) {
        this.wrapped.close(httpClient);
    }
}

