/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.edm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

public enum EdmTermTypeKind {
    AnnotationPath,
    PropertyPath,
    NavigationPropertyPath,
    AnyPropertyPath,
    ModelElementPath;

    private static Map<String, EdmTermTypeKind> VALUES_BY_NAME;

    public static EdmTermTypeKind getByName(String name) {
        return VALUES_BY_NAME.get(name);
    }

    public FullQualifiedName getFullQualifiedName() {
        return new FullQualifiedName("Edm", this.toString());
    }

    public static EdmTermTypeKind valueOfFQN(FullQualifiedName fqn) {
        if ("Edm".equals(fqn.getNamespace())) {
            return EdmTermTypeKind.valueOf(fqn.getName());
        }
        throw new IllegalArgumentException(fqn + " does not look like an EDM primitive type.");
    }

    public static EdmTermTypeKind valueOfFQN(String fqn) {
        if (!fqn.startsWith("Edm.")) {
            throw new IllegalArgumentException(fqn + " does not look like an Edm primitive type");
        }
        return EdmTermTypeKind.valueOf(fqn.substring(4));
    }

    static {
        HashMap<String, EdmTermTypeKind> valuesByName = new HashMap<String, EdmTermTypeKind>();
        for (EdmTermTypeKind value : EdmTermTypeKind.values()) {
            valuesByName.put(value.name(), value);
        }
        VALUES_BY_NAME = Collections.unmodifiableMap(valuesByName);
    }
}

