/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmAnnotations;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmSchema;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlAliasInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotations;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainerInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlOperation;
import org.apache.olingo.commons.api.edm.provider.CsdlParameter;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlStructuralType;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;
import org.apache.olingo.commons.api.edm.provider.CsdlTypeDefinition;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.core.edm.AbstractEdm;
import org.apache.olingo.commons.core.edm.EdmActionImpl;
import org.apache.olingo.commons.core.edm.EdmAnnotationsImpl;
import org.apache.olingo.commons.core.edm.EdmComplexTypeImpl;
import org.apache.olingo.commons.core.edm.EdmEntityContainerImpl;
import org.apache.olingo.commons.core.edm.EdmEntityTypeImpl;
import org.apache.olingo.commons.core.edm.EdmEnumTypeImpl;
import org.apache.olingo.commons.core.edm.EdmFunctionImpl;
import org.apache.olingo.commons.core.edm.EdmSchemaImpl;
import org.apache.olingo.commons.core.edm.EdmTermImpl;
import org.apache.olingo.commons.core.edm.EdmTypeDefinitionImpl;

public class EdmProviderImpl
extends AbstractEdm {
    private final CsdlEdmProvider provider;
    private final Map<FullQualifiedName, List<CsdlAction>> actionsMap = Collections.synchronizedMap(new HashMap());
    private final Map<FullQualifiedName, List<CsdlFunction>> functionsMap = Collections.synchronizedMap(new HashMap());
    private List<CsdlSchema> termSchemaDefinition = new ArrayList<CsdlSchema>();
    private final String SLASH = "/";
    private final String DOT = ".";

    public EdmProviderImpl(CsdlEdmProvider provider) {
        this.provider = provider;
    }

    public EdmProviderImpl(CsdlEdmProvider provider, List<CsdlSchema> termSchemaDefinition) {
        this.provider = provider;
        this.termSchemaDefinition = termSchemaDefinition;
        this.populateAnnotationMap();
    }

    @Override
    public EdmEntityContainer createEntityContainer(FullQualifiedName containerName) {
        try {
            CsdlEntityContainerInfo entityContainerInfo = this.provider.getEntityContainerInfo(containerName);
            if (entityContainerInfo != null) {
                CsdlEntityContainer entityContainer = this.provider.getEntityContainer();
                this.addEntityContainerAnnotations(entityContainer, entityContainerInfo.getContainerName());
                return new EdmEntityContainerImpl(this, this.provider, entityContainerInfo.getContainerName(), entityContainer);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
    }

    public void addEntityContainerAnnotations(CsdlEntityContainer csdlEntityContainer, FullQualifiedName containerName) {
        String aliasName = this.getAliasInfo(containerName.getNamespace());
        List<CsdlAnnotation> annotations = this.getAnnotationsMap().get(containerName.getFullQualifiedNameAsString());
        List<CsdlAnnotation> annotationsOnAlias = this.getAnnotationsMap().get(aliasName + "." + containerName.getName());
        this.addAnnotationsOnEntityContainer(csdlEntityContainer, annotations);
        this.addAnnotationsOnEntityContainer(csdlEntityContainer, annotationsOnAlias);
    }

    private void addAnnotationsOnEntityContainer(CsdlEntityContainer csdlEntityContainer, List<CsdlAnnotation> annotations) {
        if (null != annotations) {
            for (CsdlAnnotation annotation : annotations) {
                if (this.compareAnnotations(csdlEntityContainer.getAnnotations(), annotation)) continue;
                csdlEntityContainer.getAnnotations().add(annotation);
            }
        }
    }

    @Override
    public EdmEnumType createEnumType(FullQualifiedName enumName) {
        try {
            CsdlEnumType enumType = this.provider.getEnumType(enumName);
            if (enumType != null) {
                this.addEnumTypeAnnotations(enumType, enumName);
                return new EdmEnumTypeImpl((Edm)this, enumName, enumType);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
    }

    public void addEnumTypeAnnotations(CsdlEnumType enumType, FullQualifiedName enumName) {
        String aliasName = this.getAliasInfo(enumName.getNamespace());
        List<CsdlAnnotation> annotations = this.getAnnotationsMap().get(enumName.getFullQualifiedNameAsString());
        List<CsdlAnnotation> annotationsOnAlias = this.getAnnotationsMap().get(aliasName + "." + enumName.getName());
        this.addAnnotationsOnEnumTypes(enumType, annotations);
        this.addAnnotationsOnEnumTypes(enumType, annotationsOnAlias);
    }

    private void addAnnotationsOnEnumTypes(CsdlEnumType enumType, List<CsdlAnnotation> annotations) {
        if (null != annotations) {
            for (CsdlAnnotation annotation : annotations) {
                if (this.compareAnnotations(enumType.getAnnotations(), annotation)) continue;
                enumType.getAnnotations().add(annotation);
            }
        }
    }

    @Override
    public EdmTypeDefinition createTypeDefinition(FullQualifiedName typeDefinitionName) {
        try {
            CsdlTypeDefinition typeDefinition = this.provider.getTypeDefinition(typeDefinitionName);
            if (typeDefinition != null) {
                this.addTypeDefnAnnotations(typeDefinition, typeDefinitionName);
                return new EdmTypeDefinitionImpl((Edm)this, typeDefinitionName, typeDefinition);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
    }

    public void addTypeDefnAnnotations(CsdlTypeDefinition typeDefinition, FullQualifiedName typeDefinitionName) {
        String aliasName = this.getAliasInfo(typeDefinitionName.getNamespace());
        List<CsdlAnnotation> annotations = this.getAnnotationsMap().get(typeDefinitionName.getFullQualifiedNameAsString());
        List<CsdlAnnotation> annotationsOnAlias = this.getAnnotationsMap().get(aliasName + "." + typeDefinitionName.getName());
        this.addAnnotationsOnTypeDefinitions(typeDefinition, annotations);
        this.addAnnotationsOnTypeDefinitions(typeDefinition, annotationsOnAlias);
    }

    private void addAnnotationsOnTypeDefinitions(CsdlTypeDefinition typeDefinition, List<CsdlAnnotation> annotations) {
        if (null != annotations) {
            for (CsdlAnnotation annotation : annotations) {
                if (this.compareAnnotations(typeDefinition.getAnnotations(), annotation)) continue;
                typeDefinition.getAnnotations().add(annotation);
            }
        }
    }

    @Override
    public EdmEntityType createEntityType(FullQualifiedName entityTypeName) {
        try {
            CsdlEntityType entityType = this.provider.getEntityType(entityTypeName);
            if (entityType != null) {
                List<CsdlAnnotation> annotations = this.getAnnotationsMap().get(entityTypeName.getFullQualifiedNameAsString());
                String aliasName = this.getAliasInfo(entityTypeName.getNamespace());
                List<CsdlAnnotation> annotationsOnAlias = this.getAnnotationsMap().get(aliasName + "." + entityTypeName.getName());
                this.addAnnotationsOnStructuralType(entityType, annotations);
                this.addAnnotationsOnStructuralType(entityType, annotationsOnAlias);
                if (!this.isEntityDerivedFromES()) {
                    this.addStructuralTypeAnnotations(entityType, entityTypeName, this.provider.getEntityContainer());
                }
                return new EdmEntityTypeImpl((Edm)this, entityTypeName, entityType);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
    }

    private void addAnnotationsOnStructuralType(CsdlStructuralType structuralType, List<CsdlAnnotation> annotations) {
        if (null != annotations && !annotations.isEmpty()) {
            for (CsdlAnnotation annotation : annotations) {
                if (this.compareAnnotations(structuralType.getAnnotations(), annotation)) continue;
                structuralType.getAnnotations().add(annotation);
            }
        }
    }

    private void populateAnnotationMap() {
        for (CsdlSchema schema : this.termSchemaDefinition) {
            this.fetchAnnotationsInMetadataAndExternalFile(schema);
        }
        try {
            if (null != this.provider.getSchemas()) {
                for (CsdlSchema schema : this.provider.getSchemas()) {
                    this.fetchAnnotationsInMetadataAndExternalFile(schema);
                }
            }
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
    }

    private void fetchAnnotationsInMetadataAndExternalFile(CsdlSchema schema) {
        List<CsdlAnnotations> annotationGrps = schema.getAnnotationGroups();
        for (CsdlAnnotations annotationGrp : annotationGrps) {
            if (!this.getAnnotationsMap().containsKey(annotationGrp.getTarget())) {
                this.getAnnotationsMap().put(annotationGrp.getTarget(), annotationGrp.getAnnotations());
                continue;
            }
            List<CsdlAnnotation> annotations = this.getAnnotationsMap().get(annotationGrp.getTarget());
            ArrayList<CsdlAnnotation> newAnnotations = new ArrayList<CsdlAnnotation>();
            for (CsdlAnnotation annotation : annotationGrp.getAnnotations()) {
                if (this.compareAnnotations(annotations, annotation)) continue;
                newAnnotations.add(annotation);
            }
            if (newAnnotations.isEmpty()) continue;
            this.getAnnotationsMap().get(annotationGrp.getTarget()).addAll(newAnnotations);
        }
    }

    public void addStructuralTypeAnnotations(CsdlStructuralType structuralType, FullQualifiedName typeName, CsdlEntityContainer csdlEntityContainer) {
        this.updateAnnotationsOnStructuralProperties(structuralType, typeName, csdlEntityContainer);
        this.updateAnnotationsOnStructuralNavProperties(structuralType, typeName, csdlEntityContainer);
    }

    private String getAliasInfo(String namespace) {
        try {
            if (null != this.provider.getAliasInfos()) {
                for (CsdlAliasInfo aliasInfo : this.provider.getAliasInfos()) {
                    if (null == aliasInfo.getNamespace() || !aliasInfo.getNamespace().equalsIgnoreCase(namespace)) continue;
                    return aliasInfo.getAlias();
                }
            }
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
        return null;
    }

    private void updateAnnotationsOnStructuralNavProperties(CsdlStructuralType structuralType, FullQualifiedName typeName, CsdlEntityContainer csdlEntityContainer) {
        ArrayList<CsdlEntitySet> entitySets;
        List<CsdlNavigationProperty> navProperties = structuralType.getNavigationProperties();
        String containerName = null;
        String schemaName = null;
        String entitySetName = null;
        ArrayList<CsdlEntitySet> arrayList = entitySets = csdlEntityContainer != null ? csdlEntityContainer.getEntitySets() : new ArrayList<CsdlEntitySet>();
        if (structuralType instanceof CsdlComplexType) {
            this.removeAnnotationsAddedToCTNavPropFromES(structuralType, typeName, csdlEntityContainer, navProperties, entitySets);
        } else {
            for (CsdlEntitySet entitySet : entitySets) {
                entitySetName = entitySet.getName();
                String entityTypeName = entitySet.getTypeFQN().getFullQualifiedNameAsString();
                if (null != entityTypeName && entityTypeName.equalsIgnoreCase(typeName.getFullQualifiedNameAsString())) {
                    containerName = csdlEntityContainer.getName();
                    schemaName = typeName.getNamespace();
                }
                for (CsdlNavigationProperty navProperty : navProperties) {
                    List<CsdlAnnotation> annotPropDerivedFromES = this.getAnnotationsMap().get(schemaName + "." + containerName + "/" + entitySetName + "/" + navProperty.getName());
                    this.removeAnnotationsOnNavPropDerivedFromEntitySet(structuralType, navProperty, annotPropDerivedFromES);
                    String aliasName = this.getAliasInfo(schemaName);
                    List<CsdlAnnotation> annotPropDerivedFromESOnAlias = this.getAnnotationsMap().get(aliasName + "." + containerName + "/" + entitySetName + "/" + navProperty.getName());
                    this.removeAnnotationsOnNavPropDerivedFromEntitySet(structuralType, navProperty, annotPropDerivedFromESOnAlias);
                    List<CsdlAnnotation> navPropAnnotations = this.getAnnotationsMap().get(typeName + "/" + navProperty.getName());
                    this.addAnnotationsOnNavProperties(structuralType, navProperty, navPropAnnotations);
                    aliasName = this.getAliasInfo(typeName.getNamespace());
                    List<CsdlAnnotation> navPropAnnotationsOnAlias = this.getAnnotationsMap().get(aliasName + "." + typeName.getName() + "/" + navProperty.getName());
                    this.addAnnotationsOnNavProperties(structuralType, navProperty, navPropAnnotationsOnAlias);
                }
            }
        }
    }

    private void addAnnotationsOnNavProperties(CsdlStructuralType structuralType, CsdlNavigationProperty navProperty, List<CsdlAnnotation> navPropAnnotations) {
        if (null != navPropAnnotations && !navPropAnnotations.isEmpty()) {
            for (CsdlAnnotation annotation : navPropAnnotations) {
                if (this.compareAnnotations(structuralType.getNavigationProperty(navProperty.getName()).getAnnotations(), annotation)) continue;
                structuralType.getNavigationProperty(navProperty.getName()).getAnnotations().add(annotation);
            }
        }
    }

    private void removeAnnotationsOnNavPropDerivedFromEntitySet(CsdlStructuralType structuralType, CsdlNavigationProperty navProperty, List<CsdlAnnotation> annotPropDerivedFromES) {
        if (null != annotPropDerivedFromES && !annotPropDerivedFromES.isEmpty()) {
            for (CsdlAnnotation annotation : annotPropDerivedFromES) {
                List<CsdlAnnotation> propAnnot = structuralType.getNavigationProperty(navProperty.getName()).getAnnotations();
                if (!propAnnot.contains(annotation)) continue;
                propAnnot.remove(annotation);
            }
        }
    }

    private void removeAnnotationsAddedToCTNavPropFromES(CsdlStructuralType structuralType, FullQualifiedName typeName, CsdlEntityContainer csdlEntityContainer, List<CsdlNavigationProperty> navProperties, List<CsdlEntitySet> entitySets) {
        for (CsdlEntitySet entitySet : entitySets) {
            try {
                CsdlEntityType entType = this.provider.getEntityType(entitySet.getTypeFQN());
                ArrayList entTypeProperties = null != entType ? entType.getProperties() : new ArrayList();
                for (CsdlProperty entTypeProperty : entTypeProperties) {
                    if (null == entTypeProperty.getType() || !entTypeProperty.getType().equalsIgnoreCase(typeName.getFullQualifiedNameAsString())) continue;
                    String complexPropName = entTypeProperty.getName();
                    String containerName = csdlEntityContainer.getName();
                    String schemaName = typeName.getNamespace();
                    for (CsdlNavigationProperty navProperty : navProperties) {
                        List<CsdlAnnotation> annotPropDerivedFromES = this.getAnnotationsMap().get(schemaName + "." + containerName + "/" + entitySet.getName() + "/" + complexPropName + "/" + navProperty.getName());
                        this.removeAnnotationsOnNavPropDerivedFromEntitySet(structuralType, navProperty, annotPropDerivedFromES);
                        String aliasName = this.getAliasInfo(schemaName);
                        List<CsdlAnnotation> annotPropDerivedFromESOnAlias = this.getAnnotationsMap().get(aliasName + "." + containerName + "/" + entitySet.getName() + "/" + complexPropName + "/" + navProperty.getName());
                        this.removeAnnotationsOnNavPropDerivedFromEntitySet(structuralType, navProperty, annotPropDerivedFromESOnAlias);
                        List<CsdlAnnotation> propAnnotations = this.getAnnotationsMap().get(typeName.getFullQualifiedNameAsString() + "/" + navProperty.getName());
                        this.addAnnotationsOnNavProperties(structuralType, navProperty, propAnnotations);
                        aliasName = this.getAliasInfo(typeName.getNamespace());
                        List<CsdlAnnotation> propAnnotationsOnAlias = this.getAnnotationsMap().get(aliasName + "." + typeName.getName() + "/" + navProperty.getName());
                        this.addAnnotationsOnNavProperties(structuralType, navProperty, propAnnotationsOnAlias);
                    }
                }
            }
            catch (ODataException e) {
                throw new EdmException(e);
            }
        }
        for (CsdlNavigationProperty navProperty : structuralType.getNavigationProperties()) {
            List<CsdlAnnotation> propAnnotations = this.getAnnotationsMap().get(typeName.getFullQualifiedNameAsString() + "/" + navProperty.getName());
            this.addAnnotationsOnNavProperties(structuralType, navProperty, propAnnotations);
            String aliasName = this.getAliasInfo(typeName.getNamespace());
            List<CsdlAnnotation> propAnnotationsOnAlias = this.getAnnotationsMap().get(aliasName + "." + typeName.getName() + "/" + navProperty.getName());
            this.addAnnotationsOnNavProperties(structuralType, navProperty, propAnnotationsOnAlias);
        }
    }

    private void updateAnnotationsOnStructuralProperties(CsdlStructuralType structuralType, FullQualifiedName typeName, CsdlEntityContainer csdlEntityContainer) {
        ArrayList<CsdlEntitySet> entitySets;
        List<CsdlProperty> properties = structuralType.getProperties();
        String containerName = null;
        String schemaName = null;
        String entitySetName = null;
        ArrayList<CsdlEntitySet> arrayList = entitySets = null != csdlEntityContainer ? csdlEntityContainer.getEntitySets() : new ArrayList<CsdlEntitySet>();
        if (structuralType instanceof CsdlComplexType) {
            this.removeAnnotationsAddedToCTTypePropFromES(structuralType, typeName, csdlEntityContainer, properties, entitySets);
        } else {
            for (CsdlEntitySet entitySet : entitySets) {
                entitySetName = entitySet.getName();
                String entityTypeName = entitySet.getTypeFQN().getFullQualifiedNameAsString();
                if (null != entityTypeName && entityTypeName.equalsIgnoreCase(typeName.getFullQualifiedNameAsString())) {
                    containerName = csdlEntityContainer.getName();
                    schemaName = typeName.getNamespace();
                }
                for (CsdlProperty property : properties) {
                    List<CsdlAnnotation> annotPropDerivedFromES = this.getAnnotationsMap().get(schemaName + "." + containerName + "/" + entitySetName + "/" + property.getName());
                    this.removeAnnotationsOnPropDerivedFromEntitySet(structuralType, property, annotPropDerivedFromES);
                    String aliasName = this.getAliasInfo(schemaName);
                    List<CsdlAnnotation> annotPropDerivedFromESOnAlias = this.getAnnotationsMap().get(aliasName + "." + containerName + "/" + entitySetName + "/" + property.getName());
                    this.removeAnnotationsOnPropDerivedFromEntitySet(structuralType, property, annotPropDerivedFromESOnAlias);
                    List<CsdlAnnotation> propAnnotations = this.getAnnotationsMap().get(typeName.getFullQualifiedNameAsString() + "/" + property.getName());
                    this.addAnnotationsOnPropertiesOfStructuralType(structuralType, property, propAnnotations);
                    aliasName = this.getAliasInfo(typeName.getNamespace());
                    List<CsdlAnnotation> propAnnotationsOnAlias = this.getAnnotationsMap().get(aliasName + "." + typeName.getName() + "/" + property.getName());
                    this.addAnnotationsOnPropertiesOfStructuralType(structuralType, property, propAnnotationsOnAlias);
                }
            }
        }
    }

    private void addAnnotationsOnPropertiesOfStructuralType(CsdlStructuralType structuralType, CsdlProperty property, List<CsdlAnnotation> propAnnotations) {
        if (null != propAnnotations && !propAnnotations.isEmpty()) {
            for (CsdlAnnotation annotation : propAnnotations) {
                if (this.compareAnnotations(structuralType.getProperty(property.getName()).getAnnotations(), annotation)) continue;
                structuralType.getProperty(property.getName()).getAnnotations().add(annotation);
            }
        }
    }

    private void removeAnnotationsOnPropDerivedFromEntitySet(CsdlStructuralType structuralType, CsdlProperty property, List<CsdlAnnotation> annotPropDerivedFromES) {
        if (null != annotPropDerivedFromES && !annotPropDerivedFromES.isEmpty()) {
            for (CsdlAnnotation annotation : annotPropDerivedFromES) {
                List<CsdlAnnotation> propAnnot = structuralType.getProperty(property.getName()).getAnnotations();
                if (!propAnnot.contains(annotation)) continue;
                propAnnot.remove(annotation);
            }
        }
    }

    private void removeAnnotationsAddedToCTTypePropFromES(CsdlStructuralType structuralType, FullQualifiedName typeName, CsdlEntityContainer csdlEntityContainer, List<CsdlProperty> properties, List<CsdlEntitySet> entitySets) {
        for (CsdlEntitySet entitySet : entitySets) {
            try {
                CsdlEntityType entType = this.provider.getEntityType(entitySet.getTypeFQN());
                ArrayList entTypeProperties = null != entType ? entType.getProperties() : new ArrayList();
                for (CsdlProperty entTypeProperty : entTypeProperties) {
                    if (null == entTypeProperty.getType() || !entTypeProperty.getType().endsWith("." + structuralType.getName())) continue;
                    String complexPropName = entTypeProperty.getName();
                    String containerName = csdlEntityContainer.getName();
                    String schemaName = typeName.getNamespace();
                    for (CsdlProperty property : properties) {
                        List<CsdlAnnotation> annotPropDerivedFromES = this.getAnnotationsMap().get(schemaName + "." + containerName + "/" + entitySet.getName() + "/" + complexPropName + "/" + property.getName());
                        this.removeAnnotationsOnPropDerivedFromEntitySet(structuralType, property, annotPropDerivedFromES);
                        String aliasName = this.getAliasInfo(schemaName);
                        List<CsdlAnnotation> annotPropDerivedFromESOnAlias = this.getAnnotationsMap().get(aliasName + "." + containerName + "/" + entitySet.getName() + "/" + complexPropName + "/" + property.getName());
                        this.removeAnnotationsOnPropDerivedFromEntitySet(structuralType, property, annotPropDerivedFromESOnAlias);
                        List<CsdlAnnotation> propAnnotations = this.getAnnotationsMap().get(typeName.getFullQualifiedNameAsString() + "/" + property.getName());
                        this.addAnnotationsOnPropertiesOfStructuralType(structuralType, property, propAnnotations);
                        aliasName = this.getAliasInfo(typeName.getNamespace());
                        List<CsdlAnnotation> propAnnotationsOnAlias = this.getAnnotationsMap().get(typeName.getName() + "/" + property.getName());
                        this.addAnnotationsOnPropertiesOfStructuralType(structuralType, property, propAnnotationsOnAlias);
                    }
                }
            }
            catch (ODataException e) {
                throw new EdmException(e);
            }
        }
    }

    @Override
    public EdmComplexType createComplexType(FullQualifiedName complexTypeName) {
        try {
            CsdlComplexType complexType = this.provider.getComplexType(complexTypeName);
            if (complexType != null) {
                List<CsdlAnnotation> annotations = this.getAnnotationsMap().get(complexTypeName.getFullQualifiedNameAsString());
                if (null != annotations && !annotations.isEmpty()) {
                    this.addAnnotationsOnStructuralType(complexType, annotations);
                }
                String aliasName = this.getAliasInfo(complexTypeName.getNamespace());
                List<CsdlAnnotation> annotationsOnAlias = this.getAnnotationsMap().get(aliasName + "." + complexTypeName.getName());
                if (null != annotationsOnAlias && !annotationsOnAlias.isEmpty()) {
                    this.addAnnotationsOnStructuralType(complexType, annotationsOnAlias);
                }
                if (!this.isComplexDerivedFromES()) {
                    this.addStructuralTypeAnnotations(complexType, complexTypeName, this.provider.getEntityContainer());
                }
                return new EdmComplexTypeImpl((Edm)this, complexTypeName, complexType);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
    }

    @Override
    public EdmAction createBoundAction(FullQualifiedName actionName, FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection) {
        try {
            List<CsdlAction> actions = this.actionsMap.get(actionName);
            if (actions == null) {
                actions = this.provider.getActions(actionName);
                if (actions == null) {
                    return null;
                }
                this.actionsMap.put(actionName, actions);
            }
            for (CsdlAction action : actions) {
                List<CsdlParameter> parameters;
                CsdlParameter parameter;
                if (!action.isBound() || !bindingParameterTypeName.equals((parameter = (parameters = action.getParameters()).get(0)).getTypeFQN()) && !this.isEntityPreviousTypeCompatibleToBindingParam(bindingParameterTypeName, parameter) && !this.isComplexPreviousTypeCompatibleToBindingParam(bindingParameterTypeName, parameter, isBindingParameterCollection) || isBindingParameterCollection.booleanValue() != parameter.isCollection()) continue;
                this.addOperationsAnnotations(action, actionName);
                return new EdmActionImpl((Edm)this, actionName, action);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
    }

    public void addOperationsAnnotations(CsdlOperation operation, FullQualifiedName actionName) {
        String aliasName = this.getAliasInfo(actionName.getNamespace());
        List<CsdlAnnotation> annotations = this.getAnnotationsMap().get(actionName.getFullQualifiedNameAsString());
        List<CsdlAnnotation> annotationsOnAlias = this.getAnnotationsMap().get(aliasName + "." + actionName.getName());
        if (null != annotations) {
            this.addAnnotationsToOperations(operation, annotations);
        }
        if (null != annotationsOnAlias) {
            this.addAnnotationsToOperations(operation, annotationsOnAlias);
        }
        this.addAnnotationsToParamsOfOperations(operation, actionName);
    }

    private void addAnnotationsToParamsOfOperations(CsdlOperation operation, FullQualifiedName actionName) {
        List<CsdlParameter> parameters = operation.getParameters();
        for (CsdlParameter parameter : parameters) {
            List<CsdlAnnotation> annotsToParams = this.getAnnotationsMap().get(actionName.getFullQualifiedNameAsString() + "/" + parameter.getName());
            if (null != annotsToParams && !annotsToParams.isEmpty()) {
                for (CsdlAnnotation annotation : annotsToParams) {
                    if (this.compareAnnotations(operation.getParameter(parameter.getName()).getAnnotations(), annotation)) continue;
                    operation.getParameter(parameter.getName()).getAnnotations().add(annotation);
                }
            }
            String aliasName = this.getAliasInfo(actionName.getNamespace());
            List<CsdlAnnotation> annotsToParamsOnAlias = this.getAnnotationsMap().get(aliasName + "." + actionName.getName() + "/" + parameter.getName());
            if (null == annotsToParamsOnAlias || annotsToParamsOnAlias.isEmpty()) continue;
            for (CsdlAnnotation annotation : annotsToParamsOnAlias) {
                if (this.compareAnnotations(operation.getParameter(parameter.getName()).getAnnotations(), annotation)) continue;
                operation.getParameter(parameter.getName()).getAnnotations().add(annotation);
            }
        }
    }

    private void addAnnotationsToOperations(CsdlOperation operation, List<CsdlAnnotation> annotations) {
        for (CsdlAnnotation annotation : annotations) {
            if (this.compareAnnotations(operation.getAnnotations(), annotation)) continue;
            operation.getAnnotations().add(annotation);
        }
    }

    private boolean isComplexPreviousTypeCompatibleToBindingParam(FullQualifiedName bindingParameterTypeName, CsdlParameter parameter, Boolean isBindingParameterCollection) throws ODataException {
        CsdlComplexType complexType = this.provider.getComplexType(bindingParameterTypeName);
        if (this.provider.getEntityType(parameter.getTypeFQN()) == null) {
            return false;
        }
        List<CsdlProperty> properties = this.provider.getEntityType(parameter.getTypeFQN()).getProperties();
        for (CsdlProperty property : properties) {
            String paramPropertyTypeName = property.getTypeAsFQNObject().getFullQualifiedNameAsString();
            if ((complexType == null || complexType.getBaseType() == null || !complexType.getBaseTypeFQN().getFullQualifiedNameAsString().equals(paramPropertyTypeName)) && (!paramPropertyTypeName.equals(bindingParameterTypeName.getFullQualifiedNameAsString()) || isBindingParameterCollection.booleanValue() != property.isCollection())) continue;
            return true;
        }
        return false;
    }

    private boolean isEntityPreviousTypeCompatibleToBindingParam(FullQualifiedName bindingParameterTypeName, CsdlParameter parameter) throws ODataException {
        return this.provider.getEntityType(bindingParameterTypeName) != null && this.provider.getEntityType(bindingParameterTypeName).getBaseTypeFQN() != null && this.provider.getEntityType(bindingParameterTypeName).getBaseTypeFQN().equals(parameter.getTypeFQN());
    }

    @Override
    public EdmFunction createBoundFunction(FullQualifiedName functionName, FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection, List<String> parameterNames) {
        try {
            List<CsdlFunction> functions = this.functionsMap.get(functionName);
            if (functions == null) {
                functions = this.provider.getFunctions(functionName);
                if (functions == null) {
                    return null;
                }
                this.functionsMap.put(functionName, functions);
            }
            List<Object> parameterNamesCopy = parameterNames == null ? Collections.emptyList() : parameterNames;
            for (CsdlFunction function : functions) {
                if (!function.isBound()) continue;
                List<CsdlParameter> providerParameters = function.getParameters();
                if (providerParameters == null || providerParameters.isEmpty()) {
                    throw new EdmException("No parameter specified for bound function: " + functionName);
                }
                CsdlParameter bindingParameter = providerParameters.get(0);
                if (!bindingParameterTypeName.equals(bindingParameter.getTypeFQN()) && !this.isEntityPreviousTypeCompatibleToBindingParam(bindingParameterTypeName, bindingParameter) && !this.isComplexPreviousTypeCompatibleToBindingParam(bindingParameterTypeName, bindingParameter, isBindingParameterCollection) || isBindingParameterCollection.booleanValue() != bindingParameter.isCollection() || parameterNamesCopy.size() != providerParameters.size() - 1) continue;
                ArrayList<String> providerParameterNames = new ArrayList<String>();
                for (int i = 1; i < providerParameters.size(); ++i) {
                    providerParameterNames.add(providerParameters.get(i).getName());
                }
                if (!parameterNamesCopy.containsAll(providerParameterNames)) continue;
                this.addOperationsAnnotations(function, functionName);
                return new EdmFunctionImpl((Edm)this, functionName, function);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
    }

    @Override
    protected Map<String, String> createAliasToNamespaceInfo() {
        HashMap<String, String> aliasToNamespaceInfos = new HashMap<String, String>();
        try {
            List<CsdlAliasInfo> aliasInfos = this.provider.getAliasInfos();
            if (aliasInfos != null) {
                for (CsdlAliasInfo info : aliasInfos) {
                    aliasToNamespaceInfos.put(info.getAlias(), info.getNamespace());
                }
            }
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
        return aliasToNamespaceInfos;
    }

    @Override
    protected EdmAction createUnboundAction(FullQualifiedName actionName) {
        try {
            List<CsdlAction> actions = this.actionsMap.get(actionName);
            if (actions == null) {
                actions = this.provider.getActions(actionName);
                if (actions == null) {
                    return null;
                }
                this.actionsMap.put(actionName, actions);
            }
            for (CsdlAction action : actions) {
                if (action.isBound()) continue;
                this.addOperationsAnnotations(action, actionName);
                return new EdmActionImpl((Edm)this, actionName, action);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
    }

    @Override
    protected List<EdmFunction> createUnboundFunctions(FullQualifiedName functionName) {
        ArrayList<EdmFunction> result = new ArrayList<EdmFunction>();
        try {
            List<CsdlFunction> functions = this.functionsMap.get(functionName);
            if (functions == null && (functions = this.provider.getFunctions(functionName)) != null) {
                this.functionsMap.put(functionName, functions);
            }
            if (functions != null) {
                for (CsdlFunction function : functions) {
                    if (function.isBound()) continue;
                    this.addOperationsAnnotations(function, functionName);
                    result.add(new EdmFunctionImpl((Edm)this, functionName, function));
                }
            }
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
        return result;
    }

    @Override
    protected EdmFunction createUnboundFunction(FullQualifiedName functionName, List<String> parameterNames) {
        try {
            List<CsdlFunction> functions = this.functionsMap.get(functionName);
            if (functions == null) {
                functions = this.provider.getFunctions(functionName);
                if (functions == null) {
                    return null;
                }
                this.functionsMap.put(functionName, functions);
            }
            List<Object> parameterNamesCopy = parameterNames == null ? Collections.emptyList() : parameterNames;
            for (CsdlFunction function : functions) {
                if (function.isBound()) continue;
                List<CsdlParameter> providerParameters = function.getParameters();
                if (providerParameters == null) {
                    providerParameters = Collections.emptyList();
                }
                if (parameterNamesCopy.size() != providerParameters.size()) continue;
                ArrayList<String> functionParameterNames = new ArrayList<String>();
                for (CsdlParameter parameter : providerParameters) {
                    functionParameterNames.add(parameter.getName());
                }
                if (!parameterNamesCopy.containsAll(functionParameterNames)) continue;
                this.addOperationsAnnotations(function, functionName);
                this.addAnnotationsToParamsOfOperations(function, functionName);
                return new EdmFunctionImpl((Edm)this, functionName, function);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
    }

    @Override
    protected Map<String, EdmSchema> createSchemas() {
        try {
            LinkedHashMap<String, EdmSchema> providerSchemas = new LinkedHashMap<String, EdmSchema>();
            List<CsdlSchema> localSchemas = this.provider.getSchemas();
            if (localSchemas != null) {
                for (CsdlSchema schema : localSchemas) {
                    providerSchemas.put(schema.getNamespace(), new EdmSchemaImpl(this, this.provider, schema));
                }
            }
            for (CsdlSchema termSchemaDefn : this.termSchemaDefinition) {
                providerSchemas.put(termSchemaDefn.getNamespace(), new EdmSchemaImpl(this, this.provider, termSchemaDefn));
            }
            return providerSchemas;
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
    }

    @Override
    protected EdmTerm createTerm(FullQualifiedName termName) {
        try {
            CsdlTerm providerTerm = this.provider.getTerm(termName);
            if (providerTerm != null) {
                return new EdmTermImpl((Edm)this, termName.getNamespace(), providerTerm);
            }
            for (CsdlSchema schema : this.termSchemaDefinition) {
                if (!schema.getNamespace().equalsIgnoreCase(termName.getNamespace()) && (null == schema.getAlias() || !schema.getAlias().equalsIgnoreCase(termName.getNamespace()))) continue;
                List<CsdlTerm> terms = schema.getTerms();
                for (CsdlTerm term : terms) {
                    if (!term.getName().equals(termName.getName())) continue;
                    return new EdmTermImpl((Edm)this, termName.getNamespace(), term);
                }
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
    }

    @Override
    protected EdmAnnotations createAnnotationGroup(FullQualifiedName targetName, String qualifier) {
        try {
            Iterator<CsdlSchema> iterator;
            CsdlAnnotations providerGroup = this.provider.getAnnotationsGroup(targetName, qualifier);
            if (null == providerGroup && (iterator = this.termSchemaDefinition.iterator()).hasNext()) {
                CsdlSchema schema = iterator.next();
                providerGroup = schema.getAnnotationGroup(targetName.getFullQualifiedNameAsString(), qualifier);
            }
            if (providerGroup != null) {
                return new EdmAnnotationsImpl((Edm)this, providerGroup);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException(e);
        }
    }

    public List<CsdlSchema> getTermSchemaDefinitions() {
        return this.termSchemaDefinition;
    }

    private boolean compareAnnotations(List<CsdlAnnotation> annotations, CsdlAnnotation annotation) {
        for (CsdlAnnotation annot : annotations) {
            if (!annot.equals(annotation)) continue;
            return true;
        }
        return false;
    }
}

