/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.olingo.commons.api.IConstants;
import org.apache.olingo.commons.api.constants.Constantsv00;
import org.apache.olingo.commons.api.data.AbstractEntityCollection;
import org.apache.olingo.commons.api.data.AbstractEntityCollectionObject;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Linked;
import org.apache.olingo.commons.api.data.Operation;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.edm.geo.ComposedGeospatial;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.edm.geo.GeospatialCollection;
import org.apache.olingo.commons.api.edm.geo.LineString;
import org.apache.olingo.commons.api.edm.geo.MultiLineString;
import org.apache.olingo.commons.api.edm.geo.MultiPoint;
import org.apache.olingo.commons.api.edm.geo.MultiPolygon;
import org.apache.olingo.commons.api.edm.geo.Point;
import org.apache.olingo.commons.api.edm.geo.Polygon;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.ComplexSerializerOptions;
import org.apache.olingo.server.api.serializer.EntityCollectionSerializerOptions;
import org.apache.olingo.server.api.serializer.EntitySerializerOptions;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.PrimitiveSerializerOptions;
import org.apache.olingo.server.api.serializer.ReferenceCollectionSerializerOptions;
import org.apache.olingo.server.api.serializer.ReferenceSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.api.serializer.SerializerStreamResult;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.LevelsExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.core.ODataWritableContent;
import org.apache.olingo.server.core.serializer.SerializerResultImpl;
import org.apache.olingo.server.core.serializer.json.ODataJsonInstanceAnnotationSerializer;
import org.apache.olingo.server.core.serializer.utils.CircleStreamBuffer;
import org.apache.olingo.server.core.serializer.utils.ContentTypeHelper;
import org.apache.olingo.server.core.serializer.utils.ContextURLBuilder;
import org.apache.olingo.server.core.serializer.utils.ExpandSelectHelper;
import org.apache.olingo.server.core.serializer.utils.OutputStreamHelper;
import org.apache.olingo.server.core.uri.UriHelperImpl;
import org.apache.olingo.server.core.uri.queryoption.ExpandOptionImpl;

public class ODataJsonSerializer
implements ODataSerializer {
    private static final Map<Geospatial.Type, String> geoValueTypeToJsonName;
    private final boolean isIEEE754Compatible;
    private final boolean isODataMetadataNone;
    private final boolean isODataMetadataFull;
    private IConstants constants;
    private ODataJsonInstanceAnnotationSerializer instanceAnnotSerializer;

    public ODataJsonSerializer(ContentType contentType) {
        this.isIEEE754Compatible = ContentTypeHelper.isODataIEEE754Compatible(contentType);
        this.isODataMetadataNone = ContentTypeHelper.isODataMetadataNone(contentType);
        this.isODataMetadataFull = ContentTypeHelper.isODataMetadataFull(contentType);
        this.constants = new Constantsv00();
        this.instanceAnnotSerializer = new ODataJsonInstanceAnnotationSerializer(contentType, this.constants);
    }

    public ODataJsonSerializer(ContentType contentType, IConstants constants) {
        this.isIEEE754Compatible = ContentTypeHelper.isODataIEEE754Compatible(contentType);
        this.isODataMetadataNone = ContentTypeHelper.isODataMetadataNone(contentType);
        this.isODataMetadataFull = ContentTypeHelper.isODataMetadataFull(contentType);
        this.constants = constants;
        this.instanceAnnotSerializer = new ODataJsonInstanceAnnotationSerializer(contentType, constants);
    }

    /*
     * Exception decompiling
     */
    @Override
    public SerializerResult serviceDocument(ServiceMetadata metadata, String serviceRoot) throws SerializerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public SerializerResult metadataDocument(ServiceMetadata serviceMetadata) throws SerializerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public SerializerResult error(ODataServerError error) throws SerializerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public SerializerResult entityCollection(ServiceMetadata metadata, EdmEntityType entityType, AbstractEntityCollection entitySet, EntityCollectionSerializerOptions options) throws SerializerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public SerializerStreamResult entityCollectionStreamed(ServiceMetadata metadata, EdmEntityType entityType, AbstractEntityCollectionObject entities, EntityCollectionSerializerOptions options) throws SerializerException {
        return ODataWritableContent.with(entities, entityType, this, metadata, options).build();
    }

    public void entityCollectionIntoStream(ServiceMetadata metadata, EdmEntityType entityType, AbstractEntityCollectionObject entitySet, EntityCollectionSerializerOptions options, OutputStream outputStream) throws SerializerException {
        try {
            String name;
            JsonGenerator json = new JsonFactory().createGenerator(outputStream);
            json.writeStartObject();
            ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
            this.writeContextURL(contextURL, json);
            this.writeMetadataETag(metadata, json);
            if (options != null && options.getCount() != null && options.getCount().getValue()) {
                this.writeInlineCount("", entitySet.getCount(), json);
            }
            json.writeFieldName("value");
            String string = name = contextURL == null ? null : contextURL.getEntitySetOrSingletonOrType();
            if (options == null) {
                this.writeEntitySet(metadata, entityType, entitySet, null, null, null, false, null, name, json);
            } else {
                this.writeEntitySet(metadata, entityType, entitySet, options.getExpand(), null, options.getSelect(), options.getWriteOnlyReferences(), null, name, json);
            }
            this.writeNextLink(entitySet, json);
            json.close();
        }
        catch (IOException | DecoderException e) {
            SerializerException cachedException = new SerializerException("An I/O exception occurred.", e, SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
            throw cachedException;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public SerializerResult entity(ServiceMetadata metadata, EdmEntityType entityType, Entity entity, EntitySerializerOptions options) throws SerializerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected ContextURL checkContextURL(ContextURL contextURL) throws SerializerException {
        if (this.isODataMetadataNone) {
            return null;
        }
        if (contextURL == null) {
            throw new SerializerException("ContextURL null!", SerializerException.MessageKeys.NO_CONTEXT_URL, new String[0]);
        }
        return contextURL;
    }

    protected void writeEntitySet(ServiceMetadata metadata, EdmEntityType entityType, AbstractEntityCollectionObject entitySet, ExpandOption expand, Integer toDepth, SelectOption select, boolean onlyReference, Set<String> ancestors, String name, JsonGenerator json) throws IOException, SerializerException, DecoderException {
        if (entitySet instanceof AbstractEntityCollection) {
            AbstractEntityCollection entities = (AbstractEntityCollection)entitySet;
            json.writeStartArray();
            for (Entity entity : entities) {
                if (onlyReference) {
                    json.writeStartObject();
                    json.writeStringField(this.constants.getId(), this.getEntityId(entity, entityType, name));
                    json.writeEndObject();
                    continue;
                }
                this.writeEntity(metadata, entityType, entity, null, expand, toDepth, select, false, ancestors, name, json);
            }
            json.writeEndArray();
        }
    }

    protected String getEntityId(Entity entity, EdmEntityType entityType, String name) throws SerializerException {
        if (entity != null && entity.getId() == null) {
            if (entityType == null || entityType.getKeyPredicateNames() == null || name == null) {
                throw new SerializerException("Entity id is null.", SerializerException.MessageKeys.MISSING_ID, new String[0]);
            }
            UriHelperImpl uriHelper = new UriHelperImpl();
            entity.setId(URI.create(name + '(' + uriHelper.buildKeyPredicate(entityType, entity) + ')'));
        }
        return entity.getId().toASCIIString();
    }

    private boolean areKeyPredicateNamesSelected(SelectOption select, EdmEntityType type) {
        if (select == null || ExpandSelectHelper.isAll(select)) {
            return true;
        }
        Set<String> selected = ExpandSelectHelper.getSelectedPropertyNames(select.getSelectItems());
        for (String key : type.getKeyPredicateNames()) {
            if (selected.contains(key)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeEntity(ServiceMetadata metadata, EdmEntityType entityType, Entity entity, ContextURL contextURL, ExpandOption expand, Integer toDepth, SelectOption select, boolean onlyReference, Set<String> ancestors, String name, JsonGenerator json) throws IOException, SerializerException, DecoderException {
        boolean cycle = false;
        if (expand != null) {
            if (ancestors == null) {
                ancestors = new HashSet<String>();
            }
            cycle = !ancestors.add(this.getEntityId(entity, entityType, name));
        }
        try {
            json.writeStartObject();
            if (!this.isODataMetadataNone) {
                if (contextURL != null) {
                    this.writeContextURL(contextURL, json);
                    this.writeMetadataETag(metadata, json);
                }
                if (entity.getETag() != null) {
                    json.writeStringField(this.constants.getEtag(), entity.getETag());
                }
                if (entityType.hasStream()) {
                    if (entity.getMediaETag() != null) {
                        json.writeStringField(this.constants.getMediaEtag(), entity.getMediaETag());
                    }
                    if (entity.getMediaContentType() != null) {
                        json.writeStringField(this.constants.getMediaContentType(), entity.getMediaContentType());
                    }
                    if (entity.getMediaContentSource() != null) {
                        json.writeStringField(this.constants.getMediaReadLink(), entity.getMediaContentSource().toString());
                    }
                    if (entity.getMediaEditLinks() != null && !entity.getMediaEditLinks().isEmpty()) {
                        json.writeStringField(this.constants.getMediaEditLink(), entity.getMediaEditLinks().get(0).getHref());
                    }
                }
            }
            if (cycle || onlyReference) {
                json.writeStringField(this.constants.getId(), this.getEntityId(entity, entityType, name));
            } else {
                EdmEntityType resolvedType = this.resolveEntityType(metadata, entityType, entity.getType());
                if (!this.isODataMetadataNone && !resolvedType.equals(entityType) || this.isODataMetadataFull) {
                    json.writeStringField(this.constants.getType(), "#" + entity.getType());
                }
                if (!this.isODataMetadataNone && !this.areKeyPredicateNamesSelected(select, resolvedType) || this.isODataMetadataFull) {
                    json.writeStringField(this.constants.getId(), this.getEntityId(entity, resolvedType, name));
                }
                if (this.isODataMetadataFull) {
                    if (entity.getSelfLink() != null) {
                        json.writeStringField(this.constants.getReadLink(), entity.getSelfLink().getHref());
                    }
                    if (entity.getEditLink() != null) {
                        json.writeStringField(this.constants.getEditLink(), entity.getEditLink().getHref());
                    }
                }
                this.instanceAnnotSerializer.writeInstanceAnnotationsOnEntity(entity.getAnnotations(), json);
                this.writeProperties(metadata, resolvedType, entity.getProperties(), select, json, entity, expand);
                this.writeNavigationProperties(metadata, resolvedType, entity, expand, toDepth, ancestors, name, json);
                this.writeOperations(entity.getOperations(), json);
            }
            json.writeEndObject();
        }
        finally {
            if (expand != null && !cycle && ancestors != null) {
                ancestors.remove(this.getEntityId(entity, entityType, name));
            }
        }
    }

    private void writeOperations(List<Operation> operations, JsonGenerator json) throws IOException {
        if (this.isODataMetadataFull) {
            for (Operation operation : operations) {
                json.writeObjectFieldStart(operation.getMetadataAnchor());
                json.writeStringField("title", operation.getTitle());
                json.writeStringField("target", operation.getTarget().toASCIIString());
                json.writeEndObject();
            }
        }
    }

    protected EdmEntityType resolveEntityType(ServiceMetadata metadata, EdmEntityType baseType, String derivedTypeName) throws SerializerException {
        if (derivedTypeName == null || baseType.getFullQualifiedName().getFullQualifiedNameAsString().equals(derivedTypeName)) {
            return baseType;
        }
        EdmEntityType derivedType = metadata.getEdm().getEntityType(new FullQualifiedName(derivedTypeName));
        if (derivedType == null) {
            throw new SerializerException("EntityType not found", SerializerException.MessageKeys.UNKNOWN_TYPE, derivedTypeName);
        }
        for (EdmEntityType type = derivedType.getBaseType(); type != null; type = type.getBaseType()) {
            if (!type.getFullQualifiedName().equals(baseType.getFullQualifiedName())) continue;
            return derivedType;
        }
        throw new SerializerException("Wrong base type", SerializerException.MessageKeys.WRONG_BASE_TYPE, derivedTypeName, baseType.getFullQualifiedName().getFullQualifiedNameAsString());
    }

    protected EdmComplexType resolveComplexType(ServiceMetadata metadata, EdmComplexType baseType, String derivedTypeName) throws SerializerException {
        String fullQualifiedName = baseType.getFullQualifiedName().getFullQualifiedNameAsString();
        if (derivedTypeName == null || fullQualifiedName.equals(derivedTypeName)) {
            return baseType;
        }
        EdmComplexType derivedType = metadata.getEdm().getComplexType(new FullQualifiedName(derivedTypeName));
        if (derivedType == null) {
            throw new SerializerException("Complex Type not found", SerializerException.MessageKeys.UNKNOWN_TYPE, derivedTypeName);
        }
        for (EdmComplexType type = derivedType.getBaseType(); type != null; type = type.getBaseType()) {
            if (!type.getFullQualifiedName().equals(baseType.getFullQualifiedName())) continue;
            return derivedType;
        }
        throw new SerializerException("Wrong base type", SerializerException.MessageKeys.WRONG_BASE_TYPE, derivedTypeName, baseType.getFullQualifiedName().getFullQualifiedNameAsString());
    }

    protected void writeProperties(ServiceMetadata metadata, EdmStructuredType type, List<Property> properties, SelectOption select, JsonGenerator json, Linked linked, ExpandOption expand) throws IOException, SerializerException, DecoderException {
        boolean all = ExpandSelectHelper.isAll(select);
        HashSet<String> selected = all ? new HashSet() : ExpandSelectHelper.getSelectedPropertyNames(select.getSelectItems());
        this.addKeyPropertiesToSelected(selected, type);
        Set<List<String>> expandedPaths = ExpandSelectHelper.getExpandedItemsPath(expand);
        for (String propertyName : type.getPropertyNames()) {
            if (!all && !selected.contains(propertyName)) continue;
            EdmProperty edmProperty = type.getStructuralProperty(propertyName);
            Property property = this.findProperty(propertyName, properties);
            Set<List<String>> selectedPaths = all || edmProperty.isPrimitive() ? null : ExpandSelectHelper.getSelectedPaths(select.getSelectItems(), propertyName);
            this.writeProperty(metadata, edmProperty, property, selectedPaths, json, expandedPaths, linked, expand);
        }
    }

    private void addKeyPropertiesToSelected(Set<String> selected, EdmStructuredType type) {
        if (!selected.isEmpty() && type instanceof EdmEntityType) {
            List<String> keyNames = ((EdmEntityType)type).getKeyPredicateNames();
            for (String key : keyNames) {
                if (selected.contains(key)) continue;
                selected.add(key);
            }
        }
    }

    protected void writeNavigationProperties(ServiceMetadata metadata, EdmStructuredType type, Linked linked, ExpandOption expand, Integer toDepth, Set<String> ancestors, String name, JsonGenerator json) throws SerializerException, IOException, DecoderException {
        if (this.isODataMetadataFull) {
            for (String propertyName : type.getNavigationPropertyNames()) {
                Link associationLink;
                Link navigationLink = linked.getNavigationLink(propertyName);
                if (navigationLink != null) {
                    json.writeStringField(propertyName + this.constants.getNavigationLink(), navigationLink.getHref());
                }
                if ((associationLink = linked.getAssociationLink(propertyName)) == null) continue;
                json.writeStringField(propertyName + this.constants.getAssociationLink(), associationLink.getHref());
            }
        }
        if (toDepth != null && toDepth > 1 || toDepth == null && ExpandSelectHelper.hasExpand(expand)) {
            ExpandItem expandAll = ExpandSelectHelper.getExpandAll(expand);
            for (String propertyName : type.getNavigationPropertyNames()) {
                ExpandItem innerOptions = ExpandSelectHelper.getExpandItemBasedOnType(expand.getExpandItems(), propertyName, type, name);
                if (innerOptions == null && expandAll == null && toDepth == null) continue;
                Integer levels = null;
                EdmNavigationProperty property = type.getNavigationProperty(propertyName);
                Link navigationLink = linked.getNavigationLink(property.getName());
                ExpandOption childExpand = null;
                LevelsExpandOption levelsOption = null;
                if (innerOptions != null) {
                    levelsOption = innerOptions.getLevelsOption();
                    childExpand = levelsOption == null ? innerOptions.getExpandOption() : new ExpandOptionImpl().addExpandItem(innerOptions);
                } else if (expandAll != null) {
                    levels = 1;
                    levelsOption = expandAll.getLevelsOption();
                    childExpand = new ExpandOptionImpl().addExpandItem(expandAll);
                }
                if (levelsOption != null) {
                    levels = levelsOption.isMax() ? Integer.MAX_VALUE : levelsOption.getValue();
                }
                if (toDepth != null) {
                    levels = toDepth - 1;
                    childExpand = expand;
                }
                this.writeExpandedNavigationProperty(metadata, property, navigationLink, childExpand, levels, innerOptions == null ? null : innerOptions.getSelectOption(), innerOptions == null ? null : innerOptions.getCountOption(), innerOptions == null ? false : innerOptions.hasCountPath(), innerOptions == null ? false : innerOptions.isRef(), ancestors, name, json);
            }
        }
    }

    protected void writeExpandedStreamProperties(ServiceMetadata metadata, EdmStructuredType type, Linked linked, ExpandOption expand, Integer toDepth, Set<String> ancestors, String name, JsonGenerator json) throws SerializerException, IOException, DecoderException {
        if (ExpandSelectHelper.hasExpand(expand)) {
            ExpandItem expandAll = ExpandSelectHelper.getExpandAll(expand);
            for (String propertyName : type.getPropertyNames()) {
                EdmProperty edmProperty = (EdmProperty)type.getProperty(propertyName);
                if (!this.isStreamProperty(edmProperty)) continue;
                this.writeExpandedStreamProperty(expand, propertyName, edmProperty, linked, expandAll, json);
            }
        }
    }

    private void writeExpandedStreamProperty(ExpandOption expand, String propertyName, EdmProperty edmProperty, Linked linked, ExpandItem expandAll, JsonGenerator json) throws SerializerException, DecoderException, IOException {
        ExpandItem innerOptions = ExpandSelectHelper.getExpandItem(expand.getExpandItems(), propertyName);
        if (innerOptions != null || expandAll != null) {
            if (this.constants instanceof Constantsv00) {
                throw new SerializerException("Expand not supported for Stream Property Type!", SerializerException.MessageKeys.UNSUPPORTED_OPERATION_TYPE, "expand", edmProperty.getName());
            }
            Entity entity = (Entity)linked;
            Property property = entity.getProperty(propertyName);
            if ((property == null || property.isNull()) && edmProperty.isNullable() == Boolean.FALSE.booleanValue()) {
                throw new SerializerException("Non-nullable property not present!", SerializerException.MessageKeys.MISSING_PROPERTY, edmProperty.getName());
            }
            Link link = (Link)property.getValue();
            Property stream = link.getInlineEntity().getProperty(propertyName);
            Base64 decoder = new Base64(true);
            byte[] decodedBytes = (byte[])decoder.decode(stream.getValue());
            json.writeStringField(propertyName, new String(decodedBytes));
        }
    }

    protected void writeExpandedNavigationProperty(ServiceMetadata metadata, EdmNavigationProperty property, Link navigationLink, ExpandOption innerExpand, Integer toDepth, SelectOption innerSelect, CountOption innerCount, boolean writeOnlyCount, boolean writeOnlyRef, Set<String> ancestors, String name, JsonGenerator json) throws IOException, SerializerException, DecoderException {
        if (property.isCollection()) {
            if (writeOnlyCount) {
                if (navigationLink == null || navigationLink.getInlineEntitySet() == null) {
                    this.writeInlineCount(property.getName(), 0, json);
                } else {
                    this.writeInlineCount(property.getName(), navigationLink.getInlineEntitySet().getCount(), json);
                }
            } else if (navigationLink == null || navigationLink.getInlineEntitySet() == null) {
                if (innerCount != null && innerCount.getValue()) {
                    this.writeInlineCount(property.getName(), 0, json);
                }
                json.writeFieldName(property.getName());
                json.writeStartArray();
                json.writeEndArray();
            } else {
                if (innerCount != null && innerCount.getValue()) {
                    this.writeInlineCount(property.getName(), navigationLink.getInlineEntitySet().getCount(), json);
                }
                json.writeFieldName(property.getName());
                this.writeEntitySet(metadata, property.getType(), navigationLink.getInlineEntitySet(), innerExpand, toDepth, innerSelect, writeOnlyRef, ancestors, name, json);
            }
        } else {
            json.writeFieldName(property.getName());
            if (navigationLink == null || navigationLink.getInlineEntity() == null) {
                json.writeNull();
            } else {
                this.writeEntity(metadata, property.getType(), navigationLink.getInlineEntity(), null, innerExpand, toDepth, innerSelect, writeOnlyRef, ancestors, name, json);
            }
        }
    }

    private boolean isStreamProperty(EdmProperty edmProperty) {
        EdmType type = edmProperty.getType();
        return edmProperty.isPrimitive() && type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Stream);
    }

    protected void writeProperty(ServiceMetadata metadata, EdmProperty edmProperty, Property property, Set<List<String>> selectedPaths, JsonGenerator json, Set<List<String>> expandedPaths, Linked linked, ExpandOption expand) throws IOException, SerializerException, DecoderException {
        this.instanceAnnotSerializer.writeInstanceAnnotationsOnProperties(edmProperty, property, json);
        boolean isStreamProperty = this.isStreamProperty(edmProperty);
        this.writePropertyType(edmProperty, json);
        if (!isStreamProperty) {
            json.writeFieldName(edmProperty.getName());
        }
        if (property == null || property.isNull()) {
            if (edmProperty.isNullable() == Boolean.FALSE.booleanValue() && !isStreamProperty) {
                throw new SerializerException("Non-nullable property not present!", SerializerException.MessageKeys.MISSING_PROPERTY, edmProperty.getName());
            }
            if (!isStreamProperty) {
                if (edmProperty.isCollection()) {
                    json.writeStartArray();
                    json.writeEndArray();
                } else {
                    json.writeNull();
                }
            }
        } else {
            this.writePropertyValue(metadata, edmProperty, property, selectedPaths, json, expandedPaths, linked, expand);
        }
    }

    private void writePropertyType(EdmProperty edmProperty, JsonGenerator json) throws SerializerException, IOException {
        if (!this.isODataMetadataFull) {
            return;
        }
        String typeName = edmProperty.getName() + this.constants.getType();
        EdmType type = edmProperty.getType();
        if (type.getKind() == EdmTypeKind.ENUM || type.getKind() == EdmTypeKind.DEFINITION) {
            if (edmProperty.isCollection()) {
                json.writeStringField(typeName, "#Collection(" + type.getFullQualifiedName().getFullQualifiedNameAsString() + ")");
            } else {
                json.writeStringField(typeName, "#" + type.getFullQualifiedName().getFullQualifiedNameAsString());
            }
        } else if (edmProperty.isPrimitive()) {
            if (edmProperty.isCollection()) {
                json.writeStringField(typeName, "#Collection(" + type.getFullQualifiedName().getName() + ")");
            } else if (type != EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Boolean) && type != EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Double) && type != EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.String)) {
                json.writeStringField(typeName, "#" + type.getFullQualifiedName().getName());
            }
        } else if (type.getKind() == EdmTypeKind.COMPLEX) {
            if (edmProperty.isCollection()) {
                json.writeStringField(typeName, "#Collection(" + type.getFullQualifiedName().getFullQualifiedNameAsString() + ")");
            }
        } else {
            throw new SerializerException("Property type not yet supported!", SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, edmProperty.getName());
        }
    }

    private void writePropertyValue(ServiceMetadata metadata, EdmProperty edmProperty, Property property, Set<List<String>> selectedPaths, JsonGenerator json, Set<List<String>> expandedPaths, Linked linked, ExpandOption expand) throws IOException, SerializerException, DecoderException {
        block8: {
            EdmType type = edmProperty.getType();
            try {
                if (edmProperty.isPrimitive() || type.getKind() == EdmTypeKind.ENUM || type.getKind() == EdmTypeKind.DEFINITION) {
                    if (edmProperty.isCollection()) {
                        this.writePrimitiveCollection((EdmPrimitiveType)type, property, edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), json);
                    } else {
                        this.writePrimitive((EdmPrimitiveType)type, property, edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), json);
                    }
                    break block8;
                }
                if (property.isComplex()) {
                    if (edmProperty.isCollection()) {
                        this.writeComplexCollection(metadata, (EdmComplexType)type, property, selectedPaths, json, expandedPaths, expand);
                    } else {
                        this.writeComplex(metadata, (EdmComplexType)type, property, selectedPaths, json, expandedPaths, linked, expand);
                    }
                    break block8;
                }
                throw new SerializerException("Property type not yet supported!", SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, edmProperty.getName());
            }
            catch (EdmPrimitiveTypeException e) {
                throw new SerializerException("Wrong value for property!", (Throwable)e, SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, edmProperty.getName(), property.getValue().toString());
            }
        }
    }

    private void writeComplex(ServiceMetadata metadata, EdmComplexType type, Property property, Set<List<String>> selectedPaths, JsonGenerator json, Set<List<String>> expandedPaths, Linked linked, ExpandOption expand) throws IOException, SerializerException, DecoderException {
        json.writeStartObject();
        String derivedName = property.getType();
        EdmComplexType resolvedType = null;
        resolvedType = !type.getFullQualifiedName().getFullQualifiedNameAsString().equals(derivedName) ? (type.getBaseType() != null && type.getBaseType().getFullQualifiedName().getFullQualifiedNameAsString().equals(derivedName) ? this.resolveComplexType(metadata, type.getBaseType(), type.getFullQualifiedName().getFullQualifiedNameAsString()) : this.resolveComplexType(metadata, type, derivedName)) : this.resolveComplexType(metadata, type, derivedName);
        if (!this.isODataMetadataNone && !resolvedType.equals(type) || this.isODataMetadataFull) {
            json.writeStringField(this.constants.getType(), "#" + resolvedType.getFullQualifiedName().getFullQualifiedNameAsString());
        }
        if (null != linked) {
            if (linked instanceof Entity) {
                linked = ((Entity)linked).getProperty(property.getName()).asComplex();
            } else if (linked instanceof ComplexValue) {
                List<Property> complexProperties = ((ComplexValue)linked).getValue();
                for (Property prop : complexProperties) {
                    if (!prop.getName().equals(property.getName())) continue;
                    linked = prop.asComplex();
                    break;
                }
            }
            expandedPaths = expandedPaths == null || expandedPaths.isEmpty() ? null : ExpandSelectHelper.getReducedExpandItemsPaths(expandedPaths, property.getName());
        }
        this.writeComplexValue(metadata, resolvedType, property.asComplex().getValue(), selectedPaths, json, expandedPaths, linked, expand, property.getName());
        json.writeEndObject();
    }

    private void writePrimitiveCollection(EdmPrimitiveType type, Property property, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, JsonGenerator json) throws IOException, SerializerException {
        json.writeStartArray();
        block5: for (Object value : property.asCollection()) {
            switch (property.getValueType()) {
                case COLLECTION_PRIMITIVE: 
                case COLLECTION_ENUM: 
                case COLLECTION_GEOSPATIAL: {
                    try {
                        this.writePrimitiveValue(property.getName(), type, value, isNullable, maxLength, precision, scale, isUnicode, json);
                        continue block5;
                    }
                    catch (EdmPrimitiveTypeException e) {
                        throw new SerializerException("Wrong value for property!", (Throwable)e, SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, property.getName(), property.getValue().toString());
                    }
                }
            }
            throw new SerializerException("Property type not yet supported!", SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, property.getName());
        }
        json.writeEndArray();
    }

    private void writeComplexCollection(ServiceMetadata metadata, EdmComplexType type, Property property, Set<List<String>> selectedPaths, JsonGenerator json, Set<List<String>> expandedPaths, ExpandOption expand) throws IOException, SerializerException, DecoderException {
        json.writeStartArray();
        EdmComplexType derivedType = type;
        Set<List<String>> expandedPaths1 = expandedPaths != null && !expandedPaths.isEmpty() ? expandedPaths : ExpandSelectHelper.getExpandedItemsPath(expand);
        block3: for (Object value : property.asCollection()) {
            expandedPaths = expandedPaths1;
            derivedType = ((ComplexValue)value).getTypeName() != null ? metadata.getEdm().getComplexType(new FullQualifiedName(((ComplexValue)value).getTypeName())) : type;
            switch (property.getValueType()) {
                case COLLECTION_COMPLEX: {
                    json.writeStartObject();
                    if (this.isODataMetadataFull || !this.isODataMetadataNone && !derivedType.equals(type)) {
                        json.writeStringField(this.constants.getType(), "#" + derivedType.getFullQualifiedName().getFullQualifiedNameAsString());
                    }
                    expandedPaths = expandedPaths == null || expandedPaths.isEmpty() ? null : ExpandSelectHelper.getReducedExpandItemsPaths(expandedPaths, property.getName());
                    this.writeComplexValue(metadata, derivedType, ((ComplexValue)value).getValue(), selectedPaths, json, expandedPaths, (ComplexValue)value, expand, property.getName());
                    json.writeEndObject();
                    continue block3;
                }
            }
            throw new SerializerException("Property type not yet supported!", SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, property.getName());
        }
        json.writeEndArray();
    }

    private void writePrimitive(EdmPrimitiveType type, Property property, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, JsonGenerator json) throws EdmPrimitiveTypeException, IOException, SerializerException {
        if (property.isPrimitive()) {
            this.writePrimitiveValue(property.getName(), type, property.asPrimitive(), isNullable, maxLength, precision, scale, isUnicode, json);
        } else if (property.isGeospatial()) {
            this.writeGeoValue(property.getName(), type, property.asGeospatial(), isNullable, json, null);
        } else if (property.isEnum()) {
            this.writePrimitiveValue(property.getName(), type, property.asEnum(), isNullable, maxLength, precision, scale, isUnicode, json);
        } else {
            throw new SerializerException("Inconsistent property type!", SerializerException.MessageKeys.INCONSISTENT_PROPERTY_TYPE, property.getName());
        }
    }

    protected void writePrimitiveValue(String name, EdmPrimitiveType type, Object primitiveValue, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, JsonGenerator json) throws EdmPrimitiveTypeException, IOException {
        String value = type.valueToString(primitiveValue, isNullable, maxLength, precision, scale, isUnicode);
        if (value == null) {
            json.writeNull();
        } else if (type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Boolean)) {
            json.writeBoolean(Boolean.parseBoolean(value));
        } else if (type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Byte) || type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Double) || type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Int16) || type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Int32) || type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.SByte) || type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Single) || (type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Decimal) || type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Int64)) && !this.isIEEE754Compatible) {
            json.writeNumber(value);
        } else if (type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Stream)) {
            if (primitiveValue instanceof Link) {
                Link stream = (Link)primitiveValue;
                if (!this.isODataMetadataNone) {
                    if (stream.getMediaETag() != null) {
                        json.writeStringField(name + this.constants.getMediaEtag(), stream.getMediaETag());
                    }
                    if (stream.getType() != null) {
                        json.writeStringField(name + this.constants.getMediaContentType(), stream.getType());
                    }
                }
                if (this.isODataMetadataFull) {
                    if (stream.getRel() != null && stream.getRel().equals("http://docs.oasis-open.org/odata/ns/mediaresource/")) {
                        json.writeStringField(name + this.constants.getMediaReadLink(), stream.getHref());
                    }
                    if (stream.getRel() == null || stream.getRel().equals("http://docs.oasis-open.org/odata/ns/edit-media/")) {
                        json.writeStringField(name + this.constants.getMediaEditLink(), stream.getHref());
                    }
                }
            }
        } else {
            json.writeString(value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeGeoValue(String name, EdmPrimitiveType type, Geospatial geoValue, Boolean isNullable, JsonGenerator json, SRID parentSrid) throws EdmPrimitiveTypeException, IOException, SerializerException {
        if (geoValue == null) {
            if (isNullable != null && !isNullable.booleanValue()) throw new EdmPrimitiveTypeException("The literal 'null' is not allowed.");
            json.writeNull();
            return;
        } else {
            if (!type.getDefaultType().isAssignableFrom(geoValue.getClass())) {
                throw new EdmPrimitiveTypeException("The value type " + geoValue.getClass() + " is not supported.");
            }
            json.writeStartObject();
            json.writeStringField("type", geoValueTypeToJsonName.get((Object)geoValue.getGeoType()));
            json.writeFieldName(geoValue.getGeoType() == Geospatial.Type.GEOSPATIALCOLLECTION ? "geometries" : "coordinates");
            json.writeStartArray();
            switch (geoValue.getGeoType()) {
                case POINT: {
                    this.writeGeoPoint(json, (Point)geoValue);
                    break;
                }
                case MULTIPOINT: {
                    this.writeGeoPoints(json, (MultiPoint)geoValue);
                    break;
                }
                case LINESTRING: {
                    this.writeGeoPoints(json, (LineString)geoValue);
                    break;
                }
                case MULTILINESTRING: {
                    for (LineString lineString : (MultiLineString)geoValue) {
                        json.writeStartArray();
                        this.writeGeoPoints(json, lineString);
                        json.writeEndArray();
                    }
                    break;
                }
                case POLYGON: {
                    this.writeGeoPolygon(json, (Polygon)geoValue);
                    break;
                }
                case MULTIPOLYGON: {
                    for (Polygon polygon : (MultiPolygon)geoValue) {
                        json.writeStartArray();
                        this.writeGeoPolygon(json, polygon);
                        json.writeEndArray();
                    }
                    break;
                }
                case GEOSPATIALCOLLECTION: {
                    for (Geospatial element : (GeospatialCollection)geoValue) {
                        this.writeGeoValue(name, EdmPrimitiveTypeFactory.getInstance(element.getEdmPrimitiveTypeKind()), element, isNullable, json, geoValue.getSrid());
                    }
                    break;
                }
            }
            json.writeEndArray();
            if (geoValue.getSrid() != null && geoValue.getSrid().isNotDefault() && (parentSrid == null || !parentSrid.equals(geoValue.getSrid()))) {
                this.srid(json, geoValue.getSrid());
            }
            json.writeEndObject();
        }
    }

    private void srid(JsonGenerator jgen, SRID srid) throws IOException {
        jgen.writeObjectFieldStart("crs");
        jgen.writeStringField("type", "name");
        jgen.writeObjectFieldStart("properties");
        jgen.writeStringField("name", "EPSG:" + srid.toString());
        jgen.writeEndObject();
        jgen.writeEndObject();
    }

    private void writeGeoPoint(JsonGenerator json, Point point) throws IOException {
        json.writeNumber(point.getX());
        json.writeNumber(point.getY());
        if (point.getZ() != 0.0) {
            json.writeNumber(point.getZ());
        }
    }

    private void writeGeoPoints(JsonGenerator json, ComposedGeospatial<Point> points) throws IOException {
        for (Point point : points) {
            json.writeStartArray();
            this.writeGeoPoint(json, point);
            json.writeEndArray();
        }
    }

    private void writeGeoPolygon(JsonGenerator json, Polygon polygon) throws IOException {
        json.writeStartArray();
        this.writeGeoPoints(json, polygon.getExterior());
        json.writeEndArray();
        if (!polygon.getInterior().isEmpty()) {
            json.writeStartArray();
            this.writeGeoPoints(json, polygon.getInterior());
            json.writeEndArray();
        }
    }

    protected void writeComplexValue(ServiceMetadata metadata, EdmComplexType type, List<Property> properties, Set<List<String>> selectedPaths, JsonGenerator json, Set<List<String>> expandedPaths, Linked linked, ExpandOption expand, String complexPropName) throws IOException, SerializerException, DecoderException {
        if (null != expandedPaths) {
            for (List list : expandedPaths) {
                if (list.isEmpty() || list.size() != 1) continue;
                expandedPaths = ExpandSelectHelper.getReducedExpandItemsPaths(expandedPaths, (String)list.get(0));
            }
        }
        for (String string : type.getPropertyNames()) {
            Property property = this.findProperty(string, properties);
            if (selectedPaths != null && !ExpandSelectHelper.isSelected(selectedPaths, string)) continue;
            this.writeProperty(metadata, (EdmProperty)type.getProperty(string), property, selectedPaths == null ? null : ExpandSelectHelper.getReducedSelectedPaths(selectedPaths, string), json, expandedPaths, linked, expand);
        }
        this.writeNavigationProperties(metadata, type, linked, expand, null, null, complexPropName, json);
    }

    private Property findProperty(String propertyName, List<Property> properties) {
        for (Property property : properties) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public SerializerResult primitive(ServiceMetadata metadata, EdmPrimitiveType type, Property property, PrimitiveSerializerOptions options) throws SerializerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public SerializerResult complex(ServiceMetadata metadata, EdmComplexType type, Property property, ComplexSerializerOptions options) throws SerializerException {
        SerializerResult serializerResult;
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
            String name = contextURL == null ? null : contextURL.getEntitySetOrSingletonOrType();
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            JsonGenerator json = new JsonFactory().createGenerator(outputStream);
            json.writeStartObject();
            this.writeContextURL(contextURL, json);
            this.writeMetadataETag(metadata, json);
            EdmComplexType resolvedType = null;
            resolvedType = !type.getFullQualifiedName().getFullQualifiedNameAsString().equals(property.getType()) ? (type.getBaseType() != null && type.getBaseType().getFullQualifiedName().getFullQualifiedNameAsString().equals(property.getType()) ? this.resolveComplexType(metadata, type.getBaseType(), type.getFullQualifiedName().getFullQualifiedNameAsString()) : this.resolveComplexType(metadata, type, property.getType())) : this.resolveComplexType(metadata, type, property.getType());
            if (!this.isODataMetadataNone && !resolvedType.equals(type) || this.isODataMetadataFull) {
                json.writeStringField(this.constants.getType(), "#" + resolvedType.getFullQualifiedName().getFullQualifiedNameAsString());
            }
            this.writeOperations(property.getOperations(), json);
            List<Property> values = property.isNull() ? Collections.emptyList() : property.asComplex().getValue();
            this.writeProperties(metadata, type, values, options == null ? null : options.getSelect(), json, property.asComplex(), options == null ? null : options.getExpand());
            if (!property.isNull() && property.isComplex()) {
                this.writeNavigationProperties(metadata, type, property.asComplex(), options == null ? null : options.getExpand(), null, null, name, json);
            }
            json.writeEndObject();
            json.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (IOException | DecoderException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", e, SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
            }
            catch (Throwable throwable) {
                OutputStreamHelper.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        OutputStreamHelper.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    /*
     * Exception decompiling
     */
    @Override
    public SerializerResult primitiveCollection(ServiceMetadata metadata, EdmPrimitiveType type, Property property, PrimitiveSerializerOptions options) throws SerializerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public SerializerResult complexCollection(ServiceMetadata metadata, EdmComplexType type, Property property, ComplexSerializerOptions options) throws SerializerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public SerializerResult reference(ServiceMetadata metadata, EdmEntitySet edmEntitySet, Entity entity, ReferenceSerializerOptions options) throws SerializerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public SerializerResult referenceCollection(ServiceMetadata metadata, EdmEntitySet edmEntitySet, AbstractEntityCollection entityCollection, ReferenceCollectionSerializerOptions options) throws SerializerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void writeContextURL(ContextURL contextURL, JsonGenerator json) throws IOException {
        if (!this.isODataMetadataNone && contextURL != null) {
            json.writeStringField(this.constants.getContext(), ContextURLBuilder.create(contextURL).toASCIIString());
        }
    }

    protected void writeMetadataETag(ServiceMetadata metadata, JsonGenerator json) throws IOException {
        if (!this.isODataMetadataNone && metadata != null && metadata.getServiceMetadataETagSupport() != null && metadata.getServiceMetadataETagSupport().getMetadataETag() != null) {
            json.writeStringField(this.constants.getMetadataEtag(), metadata.getServiceMetadataETagSupport().getMetadataETag());
        }
    }

    protected void writeInlineCount(String propertyName, Integer count, JsonGenerator json) throws IOException {
        if (count != null) {
            if (this.isIEEE754Compatible) {
                json.writeStringField(propertyName + this.constants.getCount(), String.valueOf(count));
            } else {
                json.writeNumberField(propertyName + this.constants.getCount(), count.intValue());
            }
        }
    }

    protected void writeNextLink(AbstractEntityCollectionObject entitySet, JsonGenerator json) throws IOException {
        if (entitySet.getNext() != null) {
            json.writeStringField(this.constants.getNextLink(), entitySet.getNext().toASCIIString());
        }
    }

    void writeDeltaLink(AbstractEntityCollection entitySet, JsonGenerator json) throws IOException {
        if (entitySet.getDeltaLink() != null) {
            json.writeStringField(this.constants.getDeltaLink(), entitySet.getDeltaLink().toASCIIString());
        }
    }

    static {
        EnumMap<Geospatial.Type, String> temp = new EnumMap<Geospatial.Type, String>(Geospatial.Type.class);
        temp.put(Geospatial.Type.POINT, "Point");
        temp.put(Geospatial.Type.MULTIPOINT, "MultiPoint");
        temp.put(Geospatial.Type.LINESTRING, "LineString");
        temp.put(Geospatial.Type.MULTILINESTRING, "MultiLineString");
        temp.put(Geospatial.Type.POLYGON, "Polygon");
        temp.put(Geospatial.Type.MULTIPOLYGON, "MultiPolygon");
        temp.put(Geospatial.Type.GEOSPATIALCOLLECTION, "GeometryCollection");
        geoValueTypeToJsonName = Collections.unmodifiableMap(temp);
    }
}

