/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.queryoption.apply;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;

public class DynamicStructuredType
implements EdmStructuredType {
    private final EdmStructuredType startType;
    private Map<String, EdmProperty> properties;

    public DynamicStructuredType(EdmStructuredType startType) {
        this.startType = startType;
    }

    public DynamicStructuredType addProperty(EdmProperty property) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, EdmProperty>();
        }
        this.properties.put(property.getName(), property);
        return this;
    }

    @Override
    public EdmElement getProperty(String name) {
        EdmElement property = this.startType.getProperty(name);
        return property == null ? (this.properties == null ? null : (EdmElement)this.properties.get(name)) : property;
    }

    @Override
    public List<String> getPropertyNames() {
        if (this.properties == null || this.properties.isEmpty()) {
            return this.startType.getPropertyNames();
        }
        ArrayList<String> names = new ArrayList<String>(this.startType.getPropertyNames());
        names.addAll(this.properties.keySet());
        return Collections.unmodifiableList(names);
    }

    @Override
    public EdmProperty getStructuralProperty(String name) {
        EdmProperty property = this.startType.getStructuralProperty(name);
        return property == null ? (this.properties == null ? null : this.properties.get(name)) : property;
    }

    @Override
    public EdmNavigationProperty getNavigationProperty(String name) {
        return this.startType.getNavigationProperty(name);
    }

    @Override
    public List<String> getNavigationPropertyNames() {
        return this.startType.getNavigationPropertyNames();
    }

    @Override
    public String getNamespace() {
        return this.startType.getNamespace();
    }

    @Override
    public String getName() {
        return this.startType.getName();
    }

    @Override
    public FullQualifiedName getFullQualifiedName() {
        return this.startType.getFullQualifiedName();
    }

    @Override
    public EdmTypeKind getKind() {
        return this.startType.getKind();
    }

    @Override
    public EdmAnnotation getAnnotation(EdmTerm term, String qualifier) {
        return this.startType.getAnnotation(term, qualifier);
    }

    @Override
    public List<EdmAnnotation> getAnnotations() {
        return this.startType.getAnnotations();
    }

    @Override
    public EdmStructuredType getBaseType() {
        return this.startType.getBaseType();
    }

    @Override
    public boolean compatibleTo(EdmType targetType) {
        return this.startType.compatibleTo(targetType);
    }

    @Override
    public boolean isOpenType() {
        return this.startType.isOpenType();
    }

    @Override
    public boolean isAbstract() {
        return this.startType.isAbstract();
    }
}

