/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.GeoUtils;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.edm.geo.GeospatialCollection;
import org.apache.olingo.commons.api.edm.geo.LineString;
import org.apache.olingo.commons.api.edm.geo.MultiLineString;
import org.apache.olingo.commons.api.edm.geo.MultiPoint;
import org.apache.olingo.commons.api.edm.geo.MultiPolygon;
import org.apache.olingo.commons.api.edm.geo.Point;
import org.apache.olingo.commons.api.edm.geo.Polygon;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDouble;

class AtomGeoValueDeserializer {
    AtomGeoValueDeserializer() {
    }

    private List<Point> points(XMLEventReader reader, StartElement start, EdmPrimitiveTypeKind type, SRID srid) throws XMLStreamException {
        ArrayList<Point> result = new ArrayList<Point>();
        boolean foundEndProperty = false;
        while (reader.hasNext() && !foundEndProperty) {
            XMLEvent event = reader.nextEvent();
            if (event.isCharacters() && !event.asCharacters().isWhiteSpace()) {
                String[] pointInfo = event.asCharacters().getData().split(" ");
                Point point = new Point(GeoUtils.getDimension(type), srid);
                try {
                    point.setX(EdmDouble.getInstance().valueOfString(pointInfo[0], null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null, Double.class));
                    point.setY(EdmDouble.getInstance().valueOfString(pointInfo[1], null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null, Double.class));
                }
                catch (EdmPrimitiveTypeException e) {
                    throw new XMLStreamException("While deserializing point coordinates as double", e);
                }
                result.add(point);
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndProperty = true;
        }
        if (result.isEmpty()) {
            result.add(new Point(GeoUtils.getDimension(type), srid));
        }
        return result;
    }

    private MultiPoint multipoint(XMLEventReader reader, StartElement start, EdmPrimitiveTypeKind type, SRID srid) throws XMLStreamException {
        List<Point> points = Collections.emptyList();
        boolean foundEndProperty = false;
        while (reader.hasNext() && !foundEndProperty) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement() && event.asStartElement().getName().equals(Constants.QNAME_POINTMEMBERS)) {
                points = this.points(reader, event.asStartElement(), type, null);
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndProperty = true;
        }
        return new MultiPoint(GeoUtils.getDimension(type), srid, points);
    }

    private LineString lineString(XMLEventReader reader, StartElement start, EdmPrimitiveTypeKind type, SRID srid) throws XMLStreamException {
        return new LineString(GeoUtils.getDimension(type), srid, this.points(reader, start, type, null));
    }

    private Polygon polygon(XMLEventReader reader, StartElement start, EdmPrimitiveTypeKind type, SRID srid) throws XMLStreamException {
        List<Point> extPoints = null;
        List<Point> intPoints = null;
        boolean foundEndProperty = false;
        while (reader.hasNext() && !foundEndProperty) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                if (event.asStartElement().getName().equals(Constants.QNAME_POLYGON_EXTERIOR)) {
                    extPoints = this.points(reader, event.asStartElement(), type, null);
                }
                if (event.asStartElement().getName().equals(Constants.QNAME_POLYGON_INTERIOR)) {
                    intPoints = this.points(reader, event.asStartElement(), type, null);
                }
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndProperty = true;
        }
        return new Polygon(GeoUtils.getDimension(type), srid, intPoints, extPoints);
    }

    private MultiLineString multiLineString(XMLEventReader reader, StartElement start, EdmPrimitiveTypeKind type, SRID srid) throws XMLStreamException {
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        boolean foundEndProperty = false;
        while (reader.hasNext() && !foundEndProperty) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement() && event.asStartElement().getName().equals(Constants.QNAME_LINESTRING)) {
                lineStrings.add(this.lineString(reader, event.asStartElement(), type, null));
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndProperty = true;
        }
        return new MultiLineString(GeoUtils.getDimension(type), srid, lineStrings);
    }

    private MultiPolygon multiPolygon(XMLEventReader reader, StartElement start, EdmPrimitiveTypeKind type, SRID srid) throws XMLStreamException {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        boolean foundEndProperty = false;
        while (reader.hasNext() && !foundEndProperty) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement() && event.asStartElement().getName().equals(Constants.QNAME_POLYGON)) {
                polygons.add(this.polygon(reader, event.asStartElement(), type, null));
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndProperty = true;
        }
        return new MultiPolygon(GeoUtils.getDimension(type), srid, polygons);
    }

    private GeospatialCollection collection(XMLEventReader reader, StartElement start, EdmPrimitiveTypeKind type, SRID srid) throws XMLStreamException {
        ArrayList<Geospatial> geospatials = new ArrayList<Geospatial>();
        boolean foundEndCollection = false;
        while (reader.hasNext() && !foundEndCollection) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement() && event.asStartElement().getName().equals(Constants.QNAME_GEOMEMBERS)) {
                boolean foundEndMembers = false;
                while (reader.hasNext() && !foundEndMembers) {
                    XMLEvent subevent = reader.nextEvent();
                    if (subevent.isStartElement()) {
                        geospatials.add(this.deserialize(reader, subevent.asStartElement(), GeoUtils.getType(GeoUtils.getDimension(type), subevent.asStartElement().getName().getLocalPart())));
                    }
                    if (!subevent.isEndElement() || !Constants.QNAME_GEOMEMBERS.equals(subevent.asEndElement().getName())) continue;
                    foundEndMembers = true;
                }
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndCollection = true;
        }
        return new GeospatialCollection(GeoUtils.getDimension(type), srid, geospatials);
    }

    public Geospatial deserialize(XMLEventReader reader, StartElement start, EdmPrimitiveTypeKind type) throws XMLStreamException {
        Geospatial value;
        SRID srid = null;
        Attribute srsName = start.getAttributeByName(Constants.QNAME_ATTR_SRSNAME);
        if (srsName != null) {
            srid = SRID.valueOf(StringUtils.substringAfterLast((String)srsName.getValue(), (String)"/"));
        }
        switch (type) {
            case GeographyPoint: 
            case GeometryPoint: {
                value = this.points(reader, start, type, srid).get(0);
                break;
            }
            case GeographyMultiPoint: 
            case GeometryMultiPoint: {
                value = this.multipoint(reader, start, type, srid);
                break;
            }
            case GeographyLineString: 
            case GeometryLineString: {
                value = this.lineString(reader, start, type, srid);
                break;
            }
            case GeographyMultiLineString: 
            case GeometryMultiLineString: {
                value = this.multiLineString(reader, start, type, srid);
                break;
            }
            case GeographyPolygon: 
            case GeometryPolygon: {
                value = this.polygon(reader, start, type, srid);
                break;
            }
            case GeographyMultiPolygon: 
            case GeometryMultiPolygon: {
                value = this.multiPolygon(reader, start, type, srid);
                break;
            }
            case GeographyCollection: 
            case GeometryCollection: {
                value = this.collection(reader, start, type, srid);
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }
}

