/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public final class EdmDateTimeOffset
extends SingletonPrimitiveType {
    private static final ZoneId ZULU = ZoneId.of("Z");
    private static final Pattern PATTERN = Pattern.compile("(-?\\p{Digit}{4,})-(\\p{Digit}{2})-(\\p{Digit}{2})T(\\p{Digit}{2}):(\\p{Digit}{2})(?::(\\p{Digit}{2})(\\.(\\p{Digit}{0,12}?)0*)?)?(Z|([-+]\\p{Digit}{2}:\\p{Digit}{2}))?");
    private static final EdmDateTimeOffset INSTANCE = new EdmDateTimeOffset();

    public static EdmDateTimeOffset getInstance() {
        return INSTANCE;
    }

    @Override
    public Class<?> getDefaultType() {
        return Timestamp.class;
    }

    @Override
    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        try {
            ZonedDateTime zdt = EdmDateTimeOffset.parseZonedDateTime(value);
            return EdmDateTimeOffset.convertZonedDateTime(zdt, returnType);
        }
        catch (DateTimeParseException ex) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.", ex);
        }
        catch (ClassCastException e) {
            throw new EdmPrimitiveTypeException("The value type " + returnType + " is not supported.", e);
        }
    }

    private static ZonedDateTime parseZonedDateTime(String value) {
        ZonedDateTime zdt;
        try {
            zdt = ZonedDateTime.parse(value);
        }
        catch (DateTimeParseException ex) {
            Matcher matcher = PATTERN.matcher(value);
            if (matcher.matches() && matcher.group(9) == null) {
                zdt = ZonedDateTime.parse(value + "Z");
            }
            throw ex;
        }
        return zdt;
    }

    private static <T> T convertZonedDateTime(ZonedDateTime zdt, Class<T> returnType) {
        if (returnType == ZonedDateTime.class) {
            return (T)zdt;
        }
        if (returnType == Instant.class) {
            return (T)zdt.toInstant();
        }
        if (returnType.isAssignableFrom(Timestamp.class)) {
            return (T)Timestamp.from(zdt.toInstant());
        }
        if (returnType.isAssignableFrom(java.util.Date.class)) {
            return (T)java.util.Date.from(zdt.toInstant());
        }
        if (returnType.isAssignableFrom(Time.class)) {
            return (T)new Time(zdt.toInstant().truncatedTo(ChronoUnit.SECONDS).toEpochMilli());
        }
        if (returnType.isAssignableFrom(Date.class)) {
            return (T)new Date(zdt.toInstant().truncatedTo(ChronoUnit.SECONDS).toEpochMilli());
        }
        if (returnType.isAssignableFrom(Long.class)) {
            return (T)Long.valueOf(zdt.toInstant().toEpochMilli());
        }
        if (returnType.isAssignableFrom(Calendar.class)) {
            return (T)GregorianCalendar.from(zdt);
        }
        throw new ClassCastException("unsupported return type " + returnType.getSimpleName());
    }

    @Override
    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        ZonedDateTime zdt = EdmDateTimeOffset.createZonedDateTime(value);
        return EdmDateTimeOffset.format(zdt.toLocalDateTime(), zdt.getOffset(), zdt.getNano());
    }

    private static <T> ZonedDateTime createZonedDateTime(T value) throws EdmPrimitiveTypeException {
        if (value instanceof ZonedDateTime) {
            return (ZonedDateTime)value;
        }
        if (value instanceof Instant) {
            return ((Instant)value).atZone(ZULU);
        }
        if (value instanceof GregorianCalendar) {
            GregorianCalendar calendar = (GregorianCalendar)value;
            ZonedDateTime zdt = calendar.toZonedDateTime();
            ZoneId normalizedZoneId = calendar.getTimeZone().toZoneId().normalized();
            return zdt.withZoneSameInstant(normalizedZoneId);
        }
        return EdmDateTimeOffset.convertToInstant(value).atZone(ZULU);
    }

    private static String format(LocalDateTime dateTime, ZoneOffset offset, int nanos) {
        String str = dateTime.format(DateTimeFormatter.ISO_DATE_TIME);
        if (nanos > 0) {
            str = EdmDateTimeOffset.removeTrailingZeros(str);
        }
        str = str + offset.toString();
        return str;
    }

    private static String removeTrailingZeros(String str) {
        char[] chars = str.toCharArray();
        int trailingZeros = 0;
        for (int i = chars.length - 1; i >= 0 && chars[i] == '0'; --i) {
            ++trailingZeros;
        }
        return str.substring(0, chars.length - trailingZeros);
    }

    private static <T> Instant convertToInstant(T value) throws EdmPrimitiveTypeException {
        if (value instanceof Time || value instanceof Date) {
            throw new EdmPrimitiveTypeException("The value type " + value.getClass() + " is not supported.");
        }
        if (value instanceof java.util.Date) {
            return ((java.util.Date)value).toInstant();
        }
        if (value instanceof Timestamp) {
            return ((Timestamp)value).toInstant();
        }
        if (value instanceof Long) {
            return Instant.ofEpochMilli((Long)value);
        }
        throw new EdmPrimitiveTypeException("The value type " + value.getClass() + " is not supported.");
    }
}

