/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.api;

import java.util.Formatter;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.olingo.commons.api.ex.ODataException;

public abstract class ODataLibraryException
extends ODataException {
    private static final long serialVersionUID = -1210541002198287561L;
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    protected static final String DEFAULT_SERVER_BUNDLE_NAME = "server-core-exceptions-i18n";
    private MessageKey messageKey;
    private Object[] parameters;

    protected ODataLibraryException(String developmentMessage, MessageKey messageKey, String ... parameters) {
        super(developmentMessage);
        this.messageKey = messageKey;
        this.parameters = parameters;
    }

    protected ODataLibraryException(String developmentMessage, Throwable cause, MessageKey messageKey, String ... parameters) {
        super(developmentMessage, cause);
        this.messageKey = messageKey;
        this.parameters = parameters;
    }

    @Override
    public String getLocalizedMessage() {
        return this.getTranslatedMessage(DEFAULT_LOCALE).getMessage();
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    public MessageKey getMessageKey() {
        return this.messageKey;
    }

    public ODataErrorMessage getTranslatedMessage(Locale locale) {
        if (this.messageKey == null) {
            return new ODataErrorMessage(this.getMessage(), DEFAULT_LOCALE);
        }
        ResourceBundle bundle = this.createResourceBundle(locale);
        if (bundle == null) {
            return new ODataErrorMessage(this.getMessage(), DEFAULT_LOCALE);
        }
        return this.buildMessage(bundle, locale);
    }

    protected abstract String getBundleName();

    private ResourceBundle createResourceBundle(Locale locale) {
        try {
            return ResourceBundle.getBundle(this.getBundleName(), locale == null ? DEFAULT_LOCALE : locale);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ODataErrorMessage buildMessage(ResourceBundle bundle, Locale locale) {
        String message = null;
        StringBuilder builder = new StringBuilder();
        try (Formatter f = new Formatter(builder, locale);){
            message = bundle.getString(this.getClass().getSimpleName() + '.' + this.messageKey.getKey());
            f.format(message, this.parameters);
            Locale usedLocale = bundle.getLocale();
            if (Locale.ROOT.equals(usedLocale)) {
                usedLocale = DEFAULT_LOCALE;
            }
            ODataErrorMessage oDataErrorMessage = new ODataErrorMessage(builder.toString(), usedLocale);
            return oDataErrorMessage;
        }
    }

    public static class ODataErrorMessage {
        private String message;
        private Locale locale;

        public ODataErrorMessage(String message, Locale usedLocale) {
            this.message = message;
            this.locale = usedLocale;
        }

        public String getMessage() {
            return this.message;
        }

        public Locale getLocale() {
            return this.locale;
        }
    }

    public static interface MessageKey {
        public String getKey();
    }
}

