/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.XMLMetadataRequest;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.edm.xml.Include;
import org.apache.olingo.client.api.edm.xml.IncludeAnnotations;
import org.apache.olingo.client.api.edm.xml.Reference;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractMetadataRequestImpl;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractODataRetrieveRequest;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotations;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;

public class XMLMetadataRequestImpl
extends AbstractMetadataRequestImpl<XMLMetadata>
implements XMLMetadataRequest {
    XMLMetadataRequestImpl(ODataClient odataClient, URI uri) {
        super(odataClient, uri);
    }

    @Override
    public ODataRetrieveResponse<XMLMetadata> execute() {
        ODataResponse rootRes;
        SingleXMLMetadatRequestImpl rootReq = new SingleXMLMetadatRequestImpl(this.odataClient, this.uri);
        if (this.getPrefer() != null) {
            rootReq.setPrefer(this.getPrefer());
        }
        if (this.getIfMatch() != null) {
            rootReq.setIfMatch(this.getIfMatch());
        }
        if (this.getIfNoneMatch() != null) {
            rootReq.setIfNoneMatch(this.getIfNoneMatch());
        }
        if (this.getHeader() != null) {
            for (String key : this.getHeaderNames()) {
                rootReq.addCustomHeader(key, this.odataHeaders.getHeader(key));
            }
        }
        if ((rootRes = rootReq.execute()).getStatusCode() != HttpStatusCode.OK.getStatusCode()) {
            return rootRes;
        }
        XMLMetadataResponseImpl response = new XMLMetadataResponseImpl(this.odataClient, this.httpClient, rootReq.getHttpResponse(), (XMLMetadata)rootRes.getBody());
        for (Reference reference : ((XMLMetadata)rootRes.getBody()).getReferences()) {
            SingleXMLMetadatRequestImpl includeReq = new SingleXMLMetadatRequestImpl(this.odataClient, this.odataClient.newURIBuilder(this.uri.resolve(reference.getUri()).toASCIIString()).build());
            for (String key : rootReq.getHeaderNames()) {
                includeReq.addCustomHeader(key, rootReq.getHeader(key));
            }
            XMLMetadata includeMetadata = (XMLMetadata)includeReq.execute().getBody();
            for (Include include : reference.getIncludes()) {
                CsdlSchema includedSchema = includeMetadata.getSchema(include.getNamespace());
                if (includedSchema == null) continue;
                response.getBody().getSchemas().add(includedSchema);
                if (!StringUtils.isNotBlank((CharSequence)include.getAlias())) continue;
                includedSchema.setAlias(include.getAlias());
            }
            for (IncludeAnnotations includeAnnotations : reference.getIncludeAnnotations()) {
                for (CsdlSchema schema : includeMetadata.getSchemas()) {
                    CsdlSchema forInclusion = new CsdlSchema();
                    forInclusion.setNamespace(schema.getNamespace());
                    forInclusion.setAlias(schema.getAlias());
                    for (CsdlAnnotations annotationGroup : schema.getAnnotationGroups()) {
                        if (!StringUtils.isBlank((CharSequence)includeAnnotations.getTargetNamespace()) && !includeAnnotations.getTargetNamespace().equals(StringUtils.substringBeforeLast((String)annotationGroup.getTarget(), (String)".")) || !StringUtils.isBlank((CharSequence)includeAnnotations.getQualifier()) && !includeAnnotations.getQualifier().equals(annotationGroup.getQualifier())) continue;
                        CsdlAnnotations toBeIncluded = new CsdlAnnotations();
                        toBeIncluded.setTarget(annotationGroup.getTarget());
                        toBeIncluded.setQualifier(annotationGroup.getQualifier());
                        for (CsdlAnnotation annotation : annotationGroup.getAnnotations()) {
                            if (!includeAnnotations.getTermNamespace().equals(StringUtils.substringBeforeLast((String)annotation.getTerm(), (String)"."))) continue;
                            toBeIncluded.getAnnotations().add(annotation);
                        }
                        forInclusion.getAnnotationGroups().add(toBeIncluded);
                    }
                    if (forInclusion.getAnnotationGroups().isEmpty()) continue;
                    response.getBody().getSchemas().add(forInclusion);
                }
            }
        }
        return response;
    }

    private class XMLMetadataResponseImpl
    extends AbstractODataRetrieveRequest.AbstractODataRetrieveResponse {
        private final XMLMetadata metadata;

        private XMLMetadataResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res, XMLMetadata metadata) {
            super(XMLMetadataRequestImpl.this, odataClient, httpClient, null);
            this.initFromHttpResponse(res);
            this.metadata = metadata;
        }

        @Override
        public XMLMetadata getBody() {
            return this.metadata;
        }
    }

    private class SingleXMLMetadatRequestImpl
    extends AbstractMetadataRequestImpl<XMLMetadata> {
        private HttpResponse httpResponse;

        public SingleXMLMetadatRequestImpl(ODataClient odataClient, URI uri) {
            super(odataClient, uri);
        }

        public HttpResponse getHttpResponse() {
            return this.httpResponse;
        }

        @Override
        protected void checkRequest(ODataClient odataClient, HttpUriRequest request) {
        }

        @Override
        public ODataRetrieveResponse<XMLMetadata> execute() {
            this.httpResponse = this.doExecute();
            return new AbstractODataRetrieveRequest.AbstractODataRetrieveResponse(this.odataClient, this.httpClient, this.httpResponse){
                private XMLMetadata metadata;
                {
                    this.metadata = null;
                }

                @Override
                public XMLMetadata getBody() {
                    if (this.metadata == null) {
                        try {
                            this.metadata = this.odataClient.getDeserializer(ContentType.APPLICATION_XML).toMetadata(this.getRawResponse());
                        }
                        finally {
                            this.close();
                        }
                    }
                    return this.metadata;
                }
            };
        }
    }
}

