/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataContent;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.deserializer.batch.ODataResponsePart;
import org.apache.olingo.server.api.serializer.BatchSerializerException;

public class BatchResponseSerializer {
    private static final int BUFFER_SIZE = 4096;
    private static final String DOUBLE_DASH = "--";
    private static final String COLON = ":";
    private static final String SP = " ";
    private static final String CRLF = "\r\n";

    public InputStream serialize(List<ODataResponsePart> responses, String boundary) throws BatchSerializerException {
        BodyBuilder builder = this.createBody(responses, boundary);
        return new ByteArrayInputStream(builder.getContent());
    }

    private BodyBuilder createBody(List<ODataResponsePart> batchResponses, String boundary) throws BatchSerializerException {
        BodyBuilder builder = new BodyBuilder();
        for (ODataResponsePart part : batchResponses) {
            builder.append(this.getDashBoundary(boundary));
            if (part.isChangeSet()) {
                this.appendChangeSet(part, builder);
                continue;
            }
            this.appendBodyPart(part.getResponses().get(0), builder, false);
        }
        builder.append(this.getCloseDelimiter(boundary));
        return builder;
    }

    private void appendChangeSet(ODataResponsePart part, BodyBuilder builder) throws BatchSerializerException {
        String changeSetBoundary = this.generateBoundary("changeset");
        this.appendChangeSetHeader(builder, changeSetBoundary);
        builder.append(CRLF);
        for (ODataResponse response : part.getResponses()) {
            builder.append(this.getDashBoundary(changeSetBoundary));
            this.appendBodyPart(response, builder, true);
        }
        builder.append(this.getCloseDelimiter(changeSetBoundary));
    }

    private void appendBodyPart(ODataResponse response, BodyBuilder builder, boolean isChangeSet) throws BatchSerializerException {
        this.appendBodyPartHeader(response, builder, isChangeSet);
        builder.append(CRLF);
        this.appendStatusLine(response, builder);
        Body body = new Body(response);
        this.appendResponseHeader(response, body.getLength(), builder);
        builder.append(CRLF);
        builder.append(body);
        builder.append(CRLF);
    }

    private void appendChangeSetHeader(BodyBuilder builder, String changeSetBoundary) {
        this.appendHeader("Content-Type", ContentType.MULTIPART_MIXED + "; boundary=" + changeSetBoundary, builder);
    }

    private void appendHeader(String name, String value, BodyBuilder builder) {
        builder.append(name).append(COLON).append(SP).append(value).append(CRLF);
    }

    private void appendStatusLine(ODataResponse response, BodyBuilder builder) {
        builder.append("HTTP/1.1").append(SP).append(response.getStatusCode()).append(SP).append(this.getStatusCodeInfo(response)).append(CRLF);
    }

    private String getStatusCodeInfo(ODataResponse response) {
        HttpStatusCode status = HttpStatusCode.fromStatusCode(response.getStatusCode());
        if (status == null) {
            throw new ODataRuntimeException("Invalid status code in response '" + response.getStatusCode() + "'");
        }
        return status.getInfo();
    }

    private void appendResponseHeader(ODataResponse response, int contentLength, BodyBuilder builder) {
        Map<String, List<String>> header = response.getAllHeaders();
        for (Map.Entry<String, List<String>> entry : header.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-ID")) continue;
            this.appendHeader(entry.getKey(), entry.getValue().get(0), builder);
        }
        this.appendHeader("Content-Length", Integer.toString(contentLength), builder);
    }

    private void appendBodyPartHeader(ODataResponse response, BodyBuilder builder, boolean isChangeSet) throws BatchSerializerException {
        this.appendHeader("Content-Type", ContentType.APPLICATION_HTTP.toContentTypeString(), builder);
        this.appendHeader("Content-Transfer-Encoding", "binary", builder);
        if (isChangeSet) {
            if (response.getHeader("Content-ID") != null) {
                this.appendHeader("Content-ID", response.getHeader("Content-ID"), builder);
            } else {
                throw new BatchSerializerException("Missing content id", BatchSerializerException.MessageKeys.MISSING_CONTENT_ID, new String[0]);
            }
        }
    }

    private String getDashBoundary(String boundary) {
        return DOUBLE_DASH + boundary + CRLF;
    }

    private String getCloseDelimiter(String boundary) {
        return DOUBLE_DASH + boundary + DOUBLE_DASH + CRLF;
    }

    private String generateBoundary(String value) {
        return value + "_" + UUID.randomUUID().toString();
    }

    private static class Body {
        private final byte[] content;

        Body(ODataResponse response) {
            this.content = this.getBody(response);
        }

        private int getLength() {
            return this.content.length;
        }

        private byte[] getContent() {
            return this.content;
        }

        private byte[] getBody(ODataResponse response) {
            if (response == null || response.getContent() == null && response.getODataContent() == null) {
                return new byte[0];
            }
            try {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                ByteBuffer inBuffer = ByteBuffer.allocate(4096);
                if (response.getContent() == null) {
                    if (response.getODataContent() != null) {
                        ODataContent res = response.getODataContent();
                        res.write(Channels.newChannel(output));
                    }
                } else {
                    try (WritableByteChannel oc = Channels.newChannel(output);
                         ReadableByteChannel ic = Channels.newChannel(response.getContent());){
                        while (ic.read(inBuffer) > 0) {
                            inBuffer.flip();
                            oc.write(inBuffer);
                            inBuffer.rewind();
                        }
                    }
                }
                return output.toByteArray();
            }
            catch (IOException e) {
                throw new ODataRuntimeException("Error on reading request content", e);
            }
        }
    }

    private static class BodyBuilder {
        private static final Charset CHARSET_ISO_8859_1 = Charset.forName("iso-8859-1");
        private ByteBuffer buffer = ByteBuffer.allocate(4096);
        private boolean isClosed = false;

        private BodyBuilder() {
        }

        public byte[] getContent() {
            this.isClosed = true;
            byte[] tmp = new byte[this.buffer.position()];
            this.buffer.flip();
            this.buffer.get(tmp, 0, this.buffer.limit());
            return tmp;
        }

        public BodyBuilder append(String string) {
            byte[] b = string.getBytes(CHARSET_ISO_8859_1);
            this.put(b);
            return this;
        }

        private void put(byte[] b) {
            if (this.isClosed) {
                throw new ODataRuntimeException("BodyBuilder is closed.");
            }
            if (this.buffer.remaining() < b.length) {
                this.buffer.flip();
                int newSize = this.buffer.limit() * 2 + b.length;
                ByteBuffer tmp = ByteBuffer.allocate(newSize);
                tmp.put(this.buffer);
                this.buffer = tmp;
            }
            this.buffer.put(b);
        }

        public BodyBuilder append(int statusCode) {
            return this.append(String.valueOf(statusCode));
        }

        public BodyBuilder append(Body body) {
            this.put(body.getContent());
            return this;
        }

        public String toString() {
            return new String(this.buffer.array(), 0, this.buffer.position(), CHARSET_ISO_8859_1);
        }
    }
}

