/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.olingo.commons.api.data.AbstractEntityCollection;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.DeletedEntity;
import org.apache.olingo.commons.api.data.Delta;
import org.apache.olingo.commons.api.data.DeltaLink;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Linked;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.EdmDeltaSerializer;
import org.apache.olingo.server.api.serializer.EntityCollectionSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.core.serializer.utils.ContentTypeHelper;
import org.apache.olingo.server.core.serializer.utils.ContextURLBuilder;
import org.apache.olingo.server.core.serializer.utils.ExpandSelectHelper;
import org.apache.olingo.server.core.uri.UriHelperImpl;

public class JsonDeltaSerializerWithNavigations
implements EdmDeltaSerializer {
    private final boolean isIEEE754Compatible;
    private final boolean isODataMetadataNone;
    private final boolean isODataMetadataFull;

    public JsonDeltaSerializerWithNavigations(ContentType contentType) {
        this.isIEEE754Compatible = ContentTypeHelper.isODataIEEE754Compatible(contentType);
        this.isODataMetadataNone = ContentTypeHelper.isODataMetadataNone(contentType);
        this.isODataMetadataFull = ContentTypeHelper.isODataMetadataFull(contentType);
    }

    /*
     * Exception decompiling
     */
    @Override
    public SerializerResult entityCollection(ServiceMetadata metadata, EdmEntityType referencedEntityType, Delta delta, EntityCollectionSerializerOptions options) throws SerializerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void writeEntitySet(ServiceMetadata metadata, EdmEntityType entityType, Delta entitySet, EntityCollectionSerializerOptions options, JsonGenerator json) throws IOException, SerializerException {
        json.writeStartArray();
        for (Entity entity : entitySet.getEntities()) {
            this.writeAddedUpdatedEntity(metadata, entityType, entity, options.getExpand(), options.getSelect(), options.getContextURL(), false, options.getContextURL().getEntitySetOrSingletonOrType(), json, options.isFullRepresentation());
        }
        for (DeletedEntity deletedEntity : entitySet.getDeletedEntities()) {
            this.writeDeletedEntity(deletedEntity, json);
        }
        for (DeltaLink addedLink : entitySet.getAddedLinks()) {
            this.writeLink(addedLink, options, json, true);
        }
        for (DeltaLink deletedLink : entitySet.getDeletedLinks()) {
            this.writeLink(deletedLink, options, json, false);
        }
        json.writeEndArray();
    }

    private void writeLink(DeltaLink link, EntityCollectionSerializerOptions options, JsonGenerator json, boolean isAdded) throws IOException, SerializerException {
        try {
            json.writeStartObject();
            String entityId = options.getContextURL().getEntitySetOrSingletonOrType();
            String operation = isAdded ? "/$link" : "/$deletedLink";
            json.writeStringField("@context", "#" + entityId + operation);
            if (link != null) {
                if (link.getSource() == null) {
                    throw new SerializerException("DeltaLink source is null.", SerializerException.MessageKeys.MISSING_DELTA_PROPERTY, "Source");
                }
                json.writeStringField("source", link.getSource().toString());
                if (link.getRelationship() == null) {
                    throw new SerializerException("DeltaLink relationship is null.", SerializerException.MessageKeys.MISSING_DELTA_PROPERTY, "Relationship");
                }
                json.writeStringField("relationship", link.getRelationship().toString());
                if (link.getTarget() == null) {
                    throw new SerializerException("DeltaLink target is null.", SerializerException.MessageKeys.MISSING_DELTA_PROPERTY, "Target");
                }
            } else {
                throw new SerializerException("DeltaLink is null.", SerializerException.MessageKeys.MISSING_DELTA_PROPERTY, "Delta Link");
            }
            json.writeStringField("target", link.getTarget().toString());
            json.writeEndObject();
        }
        catch (IOException e) {
            throw new SerializerException("Entity id is null.", SerializerException.MessageKeys.MISSING_ID, new String[0]);
        }
    }

    private void writeDeletedEntity(Entity deletedEntity, JsonGenerator json) throws IOException, SerializerException {
        if (deletedEntity.getId() == null) {
            throw new SerializerException("Entity id is null.", SerializerException.MessageKeys.MISSING_ID, new String[0]);
        }
        json.writeStartObject();
        if (this.isODataMetadataFull) {
            json.writeStringField("@context", "#" + deletedEntity.getId().toASCIIString() + "/$deletedEntity");
        }
        if (((DeletedEntity)deletedEntity).getReason() == null) {
            throw new SerializerException("DeletedEntity reason is null.", SerializerException.MessageKeys.MISSING_DELTA_PROPERTY, "Reason");
        }
        json.writeFieldName("@removed");
        json.writeStartObject();
        json.writeStringField("reason", ((DeletedEntity)deletedEntity).getReason().name());
        List<Annotation> annotations = deletedEntity.getAnnotations();
        if (annotations != null && !annotations.isEmpty()) {
            for (Annotation annotation : annotations) {
                json.writeStringField("@" + annotation.getTerm(), annotation.getValue().toString());
            }
        }
        json.writeEndObject();
        List<Property> properties = deletedEntity.getProperties();
        if (properties != null && !properties.isEmpty()) {
            for (Property property : properties) {
                json.writeStringField(property.getName(), property.getValue().toString());
            }
        }
        json.writeStringField("@id", deletedEntity.getId().toASCIIString());
        json.writeEndObject();
    }

    public void writeAddedUpdatedEntity(ServiceMetadata metadata, EdmEntityType entityType, Entity entity, ExpandOption expand, SelectOption select, ContextURL url, boolean onlyReference, String name, JsonGenerator json, boolean isFullRepresentation) throws IOException, SerializerException {
        json.writeStartObject();
        if (entity.getId() != null && url != null) {
            String entityName;
            name = url.getEntitySetOrSingletonOrType();
            String entityId = entity.getId().toString();
            if (!entityId.contains(name) && !(entityName = entityId.substring(0, entityId.indexOf("("))).equals(name)) {
                json.writeStringField("@context", "#" + entityName + "/$entity");
            }
        }
        String id = this.getEntityId(entity, entityType, name);
        json.writeStringField("@id", id);
        this.writeProperties(metadata, entityType, entity.getProperties(), select, json);
        this.writeNavigationProperties(metadata, entityType, entity, expand, id, json, isFullRepresentation);
        json.writeEndObject();
    }

    private Property findProperty(String propertyName, List<Property> properties) {
        for (Property property : properties) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    protected void writeProperty(ServiceMetadata metadata, EdmProperty edmProperty, Property property, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, SerializerException {
        boolean isStreamProperty = this.isStreamProperty(edmProperty);
        if (property != null) {
            if (!isStreamProperty) {
                json.writeFieldName(edmProperty.getName());
            }
            this.writePropertyValue(metadata, edmProperty, property, selectedPaths, json);
        }
    }

    private boolean isStreamProperty(EdmProperty edmProperty) {
        EdmType type = edmProperty.getType();
        return edmProperty.isPrimitive() && type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Stream);
    }

    private void writePropertyValue(ServiceMetadata metadata, EdmProperty edmProperty, Property property, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, SerializerException {
        block8: {
            EdmType type = edmProperty.getType();
            try {
                if (edmProperty.isPrimitive() || type.getKind() == EdmTypeKind.ENUM || type.getKind() == EdmTypeKind.DEFINITION) {
                    if (edmProperty.isCollection()) {
                        this.writePrimitiveCollection((EdmPrimitiveType)type, property, edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), json);
                    } else {
                        this.writePrimitive((EdmPrimitiveType)type, property, edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), json);
                    }
                    break block8;
                }
                if (property.isComplex()) {
                    if (edmProperty.isCollection()) {
                        this.writeComplexCollection(metadata, (EdmComplexType)type, property, selectedPaths, json);
                    } else {
                        this.writeComplex(metadata, (EdmComplexType)type, property, selectedPaths, json);
                    }
                    break block8;
                }
                throw new SerializerException("Property type not yet supported!", SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, edmProperty.getName());
            }
            catch (EdmPrimitiveTypeException e) {
                throw new SerializerException("Wrong value for property!", (Throwable)e, SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, edmProperty.getName(), property.getValue().toString());
            }
        }
    }

    protected EdmComplexType resolveComplexType(ServiceMetadata metadata, EdmComplexType baseType, String derivedTypeName) throws SerializerException {
        String fullQualifiedName = baseType.getFullQualifiedName().getFullQualifiedNameAsString();
        if (derivedTypeName == null || fullQualifiedName.equals(derivedTypeName)) {
            return baseType;
        }
        EdmComplexType derivedType = metadata.getEdm().getComplexType(new FullQualifiedName(derivedTypeName));
        if (derivedType == null) {
            throw new SerializerException("Complex Type not found", SerializerException.MessageKeys.UNKNOWN_TYPE, derivedTypeName);
        }
        for (EdmComplexType type = derivedType.getBaseType(); type != null; type = type.getBaseType()) {
            if (!type.getFullQualifiedName().equals(baseType.getFullQualifiedName())) continue;
            return derivedType;
        }
        throw new SerializerException("Wrong base type", SerializerException.MessageKeys.WRONG_BASE_TYPE, derivedTypeName, baseType.getFullQualifiedName().getFullQualifiedNameAsString());
    }

    private void writeComplex(ServiceMetadata metadata, EdmComplexType type, Property property, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, SerializerException {
        json.writeStartObject();
        String derivedName = property.getType();
        EdmComplexType resolvedType = this.resolveComplexType(metadata, type, derivedName);
        if (!this.isODataMetadataNone && !resolvedType.equals(type) || this.isODataMetadataFull) {
            json.writeStringField("@odata.type", "#" + property.getType());
        }
        this.writeComplexValue(metadata, resolvedType, property.asComplex().getValue(), selectedPaths, json);
        json.writeEndObject();
    }

    private void writePrimitiveCollection(EdmPrimitiveType type, Property property, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, JsonGenerator json) throws IOException, SerializerException {
        json.writeStartArray();
        block6: for (Object value : property.asCollection()) {
            switch (property.getValueType()) {
                case COLLECTION_PRIMITIVE: 
                case COLLECTION_ENUM: {
                    try {
                        this.writePrimitiveValue(property.getName(), type, value, isNullable, maxLength, precision, scale, isUnicode, json);
                        continue block6;
                    }
                    catch (EdmPrimitiveTypeException e) {
                        throw new SerializerException("Wrong value for property!", (Throwable)e, SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, property.getName(), property.getValue().toString());
                    }
                }
                case COLLECTION_GEOSPATIAL: {
                    throw new SerializerException("Property type not yet supported!", SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, property.getName());
                }
            }
            throw new SerializerException("Property type not yet supported!", SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, property.getName());
        }
        json.writeEndArray();
    }

    private void writeComplexCollection(ServiceMetadata metadata, EdmComplexType type, Property property, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, SerializerException {
        json.writeStartArray();
        block3: for (Object value : property.asCollection()) {
            switch (property.getValueType()) {
                case COLLECTION_COMPLEX: {
                    json.writeStartObject();
                    if (this.isODataMetadataFull) {
                        json.writeStringField("@odata.type", "#" + type.getFullQualifiedName().getFullQualifiedNameAsString());
                    }
                    this.writeComplexValue(metadata, type, ((ComplexValue)value).getValue(), selectedPaths, json);
                    json.writeEndObject();
                    continue block3;
                }
            }
            throw new SerializerException("Property type not yet supported!", SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, property.getName());
        }
        json.writeEndArray();
    }

    private void writePrimitive(EdmPrimitiveType type, Property property, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, JsonGenerator json) throws EdmPrimitiveTypeException, IOException, SerializerException {
        if (property.isPrimitive()) {
            this.writePrimitiveValue(property.getName(), type, property.asPrimitive(), isNullable, maxLength, precision, scale, isUnicode, json);
        } else {
            if (property.isGeospatial()) {
                throw new SerializerException("Property type not yet supported!", SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, property.getName());
            }
            if (property.isEnum()) {
                this.writePrimitiveValue(property.getName(), type, property.asEnum(), isNullable, maxLength, precision, scale, isUnicode, json);
            } else {
                throw new SerializerException("Inconsistent property type!", SerializerException.MessageKeys.INCONSISTENT_PROPERTY_TYPE, property.getName());
            }
        }
    }

    protected void writePrimitiveValue(String name, EdmPrimitiveType type, Object primitiveValue, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, JsonGenerator json) throws EdmPrimitiveTypeException, IOException {
        String value = type.valueToString(primitiveValue, isNullable, maxLength, precision, scale, isUnicode);
        if (value == null) {
            json.writeNull();
        } else if (type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Boolean)) {
            json.writeBoolean(Boolean.parseBoolean(value));
        } else if (type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Byte) || type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Double) || type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Int16) || type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Int32) || type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.SByte) || type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Single) || (type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Decimal) || type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Int64)) && !this.isIEEE754Compatible) {
            json.writeNumber(value);
        } else if (type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Stream)) {
            if (primitiveValue instanceof Link) {
                Link stream = (Link)primitiveValue;
                if (!this.isODataMetadataNone) {
                    if (stream.getMediaETag() != null) {
                        json.writeStringField(name + "@odata.mediaEtag", stream.getMediaETag());
                    }
                    if (stream.getType() != null) {
                        json.writeStringField(name + "@odata.mediaContentType", stream.getType());
                    }
                }
                if (this.isODataMetadataFull) {
                    if (stream.getRel() != null && stream.getRel().equals("http://docs.oasis-open.org/odata/ns/mediaresource/")) {
                        json.writeStringField(name + "@odata.mediaReadLink", stream.getHref());
                    }
                    if (stream.getRel() == null || stream.getRel().equals("http://docs.oasis-open.org/odata/ns/edit-media/")) {
                        json.writeStringField(name + "@odata.mediaEditLink", stream.getHref());
                    }
                }
            }
        } else {
            json.writeString(value);
        }
    }

    protected void writeComplexValue(ServiceMetadata metadata, EdmComplexType type, List<Property> properties, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, SerializerException {
        for (String propertyName : type.getPropertyNames()) {
            Property property = this.findProperty(propertyName, properties);
            if (selectedPaths != null && !ExpandSelectHelper.isSelected(selectedPaths, propertyName)) continue;
            this.writeProperty(metadata, (EdmProperty)type.getProperty(propertyName), property, selectedPaths == null ? null : ExpandSelectHelper.getReducedSelectedPaths(selectedPaths, propertyName), json);
        }
    }

    protected void writeProperties(ServiceMetadata metadata, EdmStructuredType type, List<Property> properties, SelectOption select, JsonGenerator json) throws IOException, SerializerException {
        boolean all = ExpandSelectHelper.isAll(select);
        Set<Object> selected = all ? new HashSet() : ExpandSelectHelper.getSelectedPropertyNames(select.getSelectItems());
        for (String propertyName : type.getPropertyNames()) {
            if (!all && !selected.contains(propertyName) || properties.isEmpty()) continue;
            EdmProperty edmProperty = type.getStructuralProperty(propertyName);
            Property property = this.findProperty(propertyName, properties);
            Set<List<String>> selectedPaths = all || edmProperty.isPrimitive() ? null : ExpandSelectHelper.getSelectedPaths(select.getSelectItems(), propertyName);
            this.writeProperty(metadata, edmProperty, property, selectedPaths, json);
        }
    }

    protected void writeNavigationProperties(ServiceMetadata metadata, EdmStructuredType type, Linked linked, ExpandOption expand, String name, JsonGenerator json, boolean isFullRepresentation) throws SerializerException, IOException {
        if (ExpandSelectHelper.hasExpand(expand)) {
            boolean expandAll = ExpandSelectHelper.isExpandAll(expand);
            Set<Object> expanded = expandAll ? new HashSet() : ExpandSelectHelper.getExpandedPropertyNames(expand.getExpandItems());
            for (String propertyName : type.getNavigationPropertyNames()) {
                ExpandItem innerOptions;
                if (!expandAll && !expanded.contains(propertyName)) continue;
                EdmNavigationProperty property = type.getNavigationProperty(propertyName);
                Link navigationLink = linked.getNavigationLink(property.getName());
                ExpandItem expandItem = innerOptions = expandAll ? null : ExpandSelectHelper.getExpandItem(expand.getExpandItems(), propertyName);
                if (innerOptions != null && innerOptions.getLevelsOption() != null) {
                    throw new SerializerException("Expand option $levels is not supported.", SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
                }
                if (navigationLink != null) {
                    EdmNavigationProperty navProperty = type.getNavigationProperty(propertyName);
                    String navEntitySetName = this.getNavigatedEntitySetName(metadata, navProperty.getType().getFullQualifiedName().getFullQualifiedNameAsString());
                    this.writeExpandedNavigationProperty(metadata, property, navigationLink, innerOptions == null ? null : innerOptions.getExpandOption(), innerOptions == null ? null : innerOptions.getSelectOption(), innerOptions == null ? null : innerOptions.getCountOption(), innerOptions == null ? false : innerOptions.hasCountPath(), innerOptions == null ? false : innerOptions.isRef(), navEntitySetName != null ? navEntitySetName : name + "/" + property.getName(), json, isFullRepresentation);
                    continue;
                }
                json.writeFieldName(property.getName());
                if (property.isCollection()) {
                    json.writeStartArray();
                    json.writeEndArray();
                    continue;
                }
                json.writeNull();
            }
        }
    }

    private String getNavigatedEntitySetName(ServiceMetadata metadata, String fullQualifiedName) {
        List<EdmEntitySet> entitySets = metadata.getEdm().getEntityContainer().getEntitySets();
        for (EdmEntitySet entitySet : entitySets) {
            if (!entitySet.getEntityType().getFullQualifiedName().getFullQualifiedNameAsString().equals(fullQualifiedName)) continue;
            return entitySet.getName();
        }
        return null;
    }

    protected void writeEntitySet(ServiceMetadata metadata, EdmEntityType entityType, AbstractEntityCollection entitySet, ExpandOption expand, SelectOption select, boolean onlyReference, String name, JsonGenerator json, boolean isFullRepresentation) throws IOException, SerializerException {
        if (entitySet instanceof AbstractEntityCollection) {
            AbstractEntityCollection entities = entitySet;
            json.writeStartArray();
            for (Entity entity : entities) {
                if (onlyReference) {
                    json.writeStartObject();
                    json.writeStringField("@odata.id", this.getEntityId(entity, entityType, null));
                    json.writeEndObject();
                    continue;
                }
                if (entity instanceof DeletedEntity) {
                    this.writeDeletedEntity(entity, json);
                    continue;
                }
                this.writeAddedUpdatedEntity(metadata, entityType, entity, expand, select, null, false, name, json, isFullRepresentation);
            }
            json.writeEndArray();
        }
    }

    protected void writeExpandedNavigationProperty(ServiceMetadata metadata, EdmNavigationProperty property, Link navigationLink, ExpandOption innerExpand, SelectOption innerSelect, CountOption innerCount, boolean writeOnlyCount, boolean writeOnlyRef, String name, JsonGenerator json, boolean isFullRepresentation) throws IOException, SerializerException {
        if (property.isCollection()) {
            if (navigationLink == null || navigationLink.getInlineEntitySet() == null) {
                json.writeFieldName(property.getName());
                json.writeStartArray();
                json.writeEndArray();
            } else if (navigationLink.getInlineEntitySet() != null) {
                if (isFullRepresentation) {
                    json.writeFieldName(property.getName());
                } else {
                    json.writeFieldName(property.getName() + "@" + "delta");
                }
                this.writeEntitySet(metadata, property.getType(), navigationLink.getInlineEntitySet(), innerExpand, innerSelect, writeOnlyRef, name, json, isFullRepresentation);
            }
        } else {
            if (isFullRepresentation) {
                json.writeFieldName(property.getName());
            } else {
                json.writeFieldName(property.getName() + "@" + "delta");
            }
            if (navigationLink == null || navigationLink.getInlineEntity() == null) {
                json.writeNull();
            } else if (navigationLink.getInlineEntity() != null) {
                if (navigationLink.getInlineEntity() instanceof DeletedEntity) {
                    this.writeDeletedEntity(navigationLink.getInlineEntity(), json);
                } else {
                    this.writeAddedUpdatedEntity(metadata, property.getType(), navigationLink.getInlineEntity(), innerExpand, innerSelect, null, writeOnlyRef, name, json, isFullRepresentation);
                }
            }
        }
    }

    private String getEntityId(Entity entity, EdmEntityType entityType, String name) throws SerializerException {
        try {
            if (entity != null) {
                if (entity.getId() == null) {
                    if (entityType == null || entityType.getKeyPredicateNames() == null || name == null) {
                        throw new SerializerException("Entity id is null.", SerializerException.MessageKeys.MISSING_ID, new String[0]);
                    }
                    UriHelperImpl uriHelper = new UriHelperImpl();
                    entity.setId(URI.create(name + '(' + uriHelper.buildKeyPredicate(entityType, entity) + ')'));
                    return entity.getId().toASCIIString();
                }
                return entity.getId().toASCIIString();
            }
            return null;
        }
        catch (Exception e) {
            throw new SerializerException("Entity id is null.", SerializerException.MessageKeys.MISSING_ID, new String[0]);
        }
    }

    void writeInlineCount(Integer count, JsonGenerator json) throws IOException {
        if (count != null) {
            String countValue = this.isIEEE754Compatible ? String.valueOf(count) : String.valueOf(count);
            json.writeStringField("@count", countValue);
        }
    }

    ContextURL checkContextURL(ContextURL contextURL) throws SerializerException {
        if (this.isODataMetadataNone) {
            return null;
        }
        if (contextURL == null) {
            throw new SerializerException("ContextURL null!", SerializerException.MessageKeys.NO_CONTEXT_URL, new String[0]);
        }
        return contextURL;
    }

    void writeContextURL(ContextURL contextURL, JsonGenerator json) throws IOException {
        if (!this.isODataMetadataNone && contextURL != null) {
            String context = "@context";
            json.writeStringField(context, ContextURLBuilder.create(contextURL).toASCIIString() + "/$delta");
        }
    }

    boolean writeNextLink(AbstractEntityCollection entitySet, JsonGenerator json) throws IOException {
        if (entitySet.getNext() != null) {
            json.writeStringField("@nextLink", entitySet.getNext().toASCIIString());
            return true;
        }
        return false;
    }

    void writeDeltaLink(AbstractEntityCollection entitySet, JsonGenerator json, boolean pagination) throws IOException {
        if (entitySet.getDeltaLink() != null && !pagination) {
            json.writeStringField("@deltaLink", entitySet.getDeltaLink().toASCIIString());
        }
    }
}

