/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.GeoUtils;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.edm.geo.GeospatialCollection;
import org.apache.olingo.commons.api.edm.geo.LineString;
import org.apache.olingo.commons.api.edm.geo.MultiLineString;
import org.apache.olingo.commons.api.edm.geo.MultiPoint;
import org.apache.olingo.commons.api.edm.geo.MultiPolygon;
import org.apache.olingo.commons.api.edm.geo.Point;
import org.apache.olingo.commons.api.edm.geo.Polygon;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDouble;

class JsonGeoValueDeserializer {
    JsonGeoValueDeserializer() {
    }

    private Point point(Iterator<JsonNode> itor, EdmPrimitiveTypeKind type, SRID srid) {
        Point point = null;
        if (itor.hasNext()) {
            point = new Point(GeoUtils.getDimension(type), srid);
            try {
                point.setX(EdmDouble.getInstance().valueOfString(itor.next().asText(), null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null, Double.class));
                point.setY(EdmDouble.getInstance().valueOfString(itor.next().asText(), null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null, Double.class));
            }
            catch (EdmPrimitiveTypeException e) {
                throw new IllegalArgumentException("While deserializing point coordinates as double", e);
            }
        }
        return point;
    }

    private MultiPoint multipoint(Iterator<JsonNode> itor, EdmPrimitiveTypeKind type, SRID srid) {
        MultiPoint multiPoint;
        if (itor.hasNext()) {
            ArrayList<Point> points = new ArrayList<Point>();
            while (itor.hasNext()) {
                Iterator mpItor = itor.next().elements();
                points.add(this.point(mpItor, type, srid));
            }
            multiPoint = new MultiPoint(GeoUtils.getDimension(type), srid, points);
        } else {
            multiPoint = new MultiPoint(GeoUtils.getDimension(type), srid, Collections.emptyList());
        }
        return multiPoint;
    }

    private LineString lineString(Iterator<JsonNode> itor, EdmPrimitiveTypeKind type, SRID srid) {
        LineString lineString;
        if (itor.hasNext()) {
            ArrayList<Point> points = new ArrayList<Point>();
            while (itor.hasNext()) {
                Iterator mpItor = itor.next().elements();
                points.add(this.point(mpItor, type, srid));
            }
            lineString = new LineString(GeoUtils.getDimension(type), srid, points);
        } else {
            lineString = new LineString(GeoUtils.getDimension(type), srid, Collections.emptyList());
        }
        return lineString;
    }

    private MultiLineString multiLineString(Iterator<JsonNode> itor, EdmPrimitiveTypeKind type, SRID srid) {
        MultiLineString multiLineString;
        if (itor.hasNext()) {
            ArrayList<LineString> lineStrings = new ArrayList<LineString>();
            while (itor.hasNext()) {
                Iterator mlsItor = itor.next().elements();
                lineStrings.add(this.lineString(mlsItor, type, srid));
            }
            multiLineString = new MultiLineString(GeoUtils.getDimension(type), srid, lineStrings);
        } else {
            multiLineString = new MultiLineString(GeoUtils.getDimension(type), srid, Collections.emptyList());
        }
        return multiLineString;
    }

    private Polygon polygon(Iterator<JsonNode> itor, EdmPrimitiveTypeKind type, SRID srid) {
        Iterator intItor;
        Iterator extItor;
        ArrayList<Point> extPoints = null;
        if (itor.hasNext() && (extItor = itor.next().elements()).hasNext()) {
            extPoints = new ArrayList<Point>();
            while (extItor.hasNext()) {
                Iterator mpItor = ((JsonNode)extItor.next()).elements();
                extPoints.add(this.point(mpItor, type, srid));
            }
        }
        ArrayList<Point> intPoints = null;
        if (itor.hasNext() && (intItor = itor.next().elements()).hasNext()) {
            intPoints = new ArrayList<Point>();
            while (intItor.hasNext()) {
                Iterator mpItor = ((JsonNode)intItor.next()).elements();
                intPoints.add(this.point(mpItor, type, srid));
            }
        }
        return new Polygon(GeoUtils.getDimension(type), srid, intPoints, extPoints);
    }

    private MultiPolygon multiPolygon(Iterator<JsonNode> itor, EdmPrimitiveTypeKind type, SRID srid) {
        MultiPolygon multiPolygon;
        if (itor.hasNext()) {
            ArrayList<Polygon> polygons = new ArrayList<Polygon>();
            while (itor.hasNext()) {
                Iterator mpItor = itor.next().elements();
                polygons.add(this.polygon(mpItor, type, srid));
            }
            multiPolygon = new MultiPolygon(GeoUtils.getDimension(type), srid, polygons);
        } else {
            multiPolygon = new MultiPolygon(GeoUtils.getDimension(type), srid, Collections.emptyList());
        }
        return multiPolygon;
    }

    private GeospatialCollection collection(Iterator<JsonNode> itor, EdmPrimitiveTypeKind type, SRID srid) {
        GeospatialCollection collection;
        if (itor.hasNext()) {
            ArrayList<Geospatial> geospatials = new ArrayList<Geospatial>();
            while (itor.hasNext()) {
                JsonNode geo = itor.next();
                String collItemType = geo.get("type").asText();
                String callAsType = EdmPrimitiveTypeKind.GeographyCollection.name().equals(collItemType) || EdmPrimitiveTypeKind.GeometryCollection.name().equals(collItemType) ? collItemType : (type == EdmPrimitiveTypeKind.GeographyCollection ? "Geography" : "Geometry") + collItemType;
                geospatials.add(this.deserialize(geo, new EdmTypeInfo.Builder().setTypeExpression(callAsType).build()));
            }
            collection = new GeospatialCollection(GeoUtils.getDimension(type), srid, geospatials);
        } else {
            collection = new GeospatialCollection(GeoUtils.getDimension(type), srid, Collections.emptyList());
        }
        return collection;
    }

    public Geospatial deserialize(JsonNode node, EdmTypeInfo typeInfo) {
        EdmPrimitiveTypeKind actualType;
        if ((typeInfo.getPrimitiveTypeKind() == EdmPrimitiveTypeKind.Geography || typeInfo.getPrimitiveTypeKind() == EdmPrimitiveTypeKind.Geometry) && node.has("type")) {
            String nodeType = node.get("type").asText();
            if (nodeType.startsWith("Geo")) {
                int yIdx = nodeType.indexOf(121);
                nodeType = nodeType.substring(yIdx + 1);
            }
            actualType = EdmPrimitiveTypeKind.valueOfFQN(typeInfo.getFullQualifiedName().toString() + nodeType);
        } else {
            actualType = typeInfo.getPrimitiveTypeKind();
        }
        Iterator cooItor = node.has("coordinates") ? node.get("coordinates").elements() : Collections.emptyList().iterator();
        SRID srid = null;
        if (node.has("crs")) {
            srid = SRID.valueOf(node.get("crs").get("properties").get("name").asText().split(":")[1]);
        }
        Geospatial value = null;
        switch (actualType) {
            case GeographyPoint: 
            case GeometryPoint: {
                value = this.point(cooItor, actualType, srid);
                break;
            }
            case GeographyMultiPoint: 
            case GeometryMultiPoint: {
                value = this.multipoint(cooItor, actualType, srid);
                break;
            }
            case GeographyLineString: 
            case GeometryLineString: {
                value = this.lineString(cooItor, actualType, srid);
                break;
            }
            case GeographyMultiLineString: 
            case GeometryMultiLineString: {
                value = this.multiLineString(cooItor, actualType, srid);
                break;
            }
            case GeographyPolygon: 
            case GeometryPolygon: {
                value = this.polygon(cooItor, actualType, srid);
                break;
            }
            case GeographyMultiPolygon: 
            case GeometryMultiPolygon: {
                value = this.multiPolygon(cooItor, actualType, srid);
                break;
            }
            case GeographyCollection: 
            case GeometryCollection: {
                value = this.collection(node.get("geometries").elements(), actualType, srid);
                break;
            }
        }
        return value;
    }
}

