/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.batch;

import org.apache.olingo.client.api.communication.request.ODataBatchableRequest;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchRequest;
import org.apache.olingo.client.api.communication.request.batch.ODataSingleRequest;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.client.core.communication.request.AbstractODataRequest;
import org.apache.olingo.client.core.communication.request.batch.AbstractODataBatchRequestItem;
import org.apache.olingo.client.core.communication.request.batch.ODataBatchRequestContext;
import org.apache.olingo.client.core.communication.request.batch.ODataSingleResponseItem;
import org.apache.olingo.commons.api.http.HttpMethod;

public class ODataSingleRequestImpl
extends AbstractODataBatchRequestItem
implements ODataSingleRequest {
    private final ODataSingleResponseItem expectedResItem;
    private ODataBatchRequestContext batchRequestController;

    ODataSingleRequestImpl(ODataBatchRequest req, ODataSingleResponseItem expectedResItem) {
        super(req);
        this.expectedResItem = expectedResItem;
    }

    public ODataSingleRequestImpl(ODataBatchRequest req, ODataSingleResponseItem expectedResItem, ODataBatchRequestContext batchRequestController) {
        this(req, expectedResItem);
        this.batchRequestController = batchRequestController;
    }

    @Override
    protected void closeItem() {
    }

    @Override
    public ODataSingleRequest setRequest(ODataBatchableRequest request) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Current batch item is closed");
        }
        this.hasStreamedSomething = true;
        int contentId = this.batchRequestController.getAndIncrementContentId();
        if (request.getMethod() == HttpMethod.GET) {
            this.streamRequestHeader(request);
        } else {
            this.streamRequestHeader(String.valueOf(contentId));
            request.batch(this.req, String.valueOf(contentId));
        }
        this.close();
        this.expectedResItem.addResponse(String.valueOf(contentId), (ODataResponse)((AbstractODataRequest)((Object)request)).getResponseTemplate());
        return this;
    }
}

