/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;

@JsonDeserialize(using=PropertyDeserializer.class)
class ClientCsdlProperty
extends CsdlProperty
implements Serializable {
    private static final long serialVersionUID = -4521766603286651372L;

    ClientCsdlProperty() {
    }

    static class PropertyDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlProperty> {
        PropertyDeserializer() {
        }

        @Override
        protected ClientCsdlProperty doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlProperty property = new ClientCsdlProperty();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Name".equals(jp.getCurrentName())) {
                        property.setName(jp.nextTextValue());
                    } else if ("Type".equals(jp.getCurrentName())) {
                        String metadataTypeName = jp.nextTextValue();
                        if (metadataTypeName.startsWith("Collection(")) {
                            property.setType(metadataTypeName.substring(metadataTypeName.indexOf("(") + 1, metadataTypeName.length() - 1));
                            property.setCollection(true);
                        } else {
                            property.setType(metadataTypeName);
                            property.setCollection(false);
                        }
                    } else if ("Nullable".equals(jp.getCurrentName())) {
                        property.setNullable(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                    } else if ("DefaultValue".equals(jp.getCurrentName())) {
                        property.setDefaultValue(jp.nextTextValue());
                    } else if ("MaxLength".equals(jp.getCurrentName())) {
                        String maxLenght = jp.nextTextValue();
                        property.setMaxLength("max".equalsIgnoreCase(maxLenght) ? Integer.MAX_VALUE : Integer.valueOf(maxLenght));
                    } else if ("Precision".equals(jp.getCurrentName())) {
                        property.setPrecision(Integer.valueOf(jp.nextTextValue()));
                    } else if ("Scale".equals(jp.getCurrentName())) {
                        String scale = jp.nextTextValue();
                        property.setScale("variable".equalsIgnoreCase(scale) || "floating".equalsIgnoreCase(scale) ? 0 : Integer.valueOf(scale));
                        property.setScaleAsString(scale);
                    } else if ("Unicode".equals(jp.getCurrentName())) {
                        property.setUnicode(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                    } else if ("SRID".equals(jp.getCurrentName())) {
                        String srid = jp.nextTextValue();
                        if (srid != null) {
                            property.setSrid(SRID.valueOf(srid));
                        }
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        property.getAnnotations().add((CsdlAnnotation)jp.readValueAs(ClientCsdlAnnotation.class));
                    }
                }
                jp.nextToken();
            }
            return property;
        }
    }
}

