/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.http;

import java.net.URI;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.olingo.client.core.http.DefaultHttpClientFactory;
import org.apache.olingo.commons.api.http.HttpMethod;

public class BasicAuthHttpClientFactory
extends DefaultHttpClientFactory {
    private final String username;
    private final String password;

    public BasicAuthHttpClientFactory(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public HttpClient create(HttpMethod method, URI uri) {
        try {
            Class.forName("org.apache.http.impl.client.HttpClientBuilder");
            HttpClientBuilder clientBuilder = HttpClientBuilder.create();
            clientBuilder.setUserAgent(USER_AGENT);
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            return clientBuilder.build();
        }
        catch (ClassNotFoundException e) {
            DefaultHttpClient httpclient = (DefaultHttpClient)super.create(method, uri);
            httpclient.getCredentialsProvider().setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            return httpclient;
        }
    }
}

