/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.serialization.ODataDeserializer;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.client.core.serialization.JsonEntityDeserializer;
import org.apache.olingo.client.core.serialization.JsonEntitySetDeserializer;
import org.apache.olingo.client.core.serialization.JsonGeoValueDeserializer;
import org.apache.olingo.client.core.serialization.JsonODataErrorDeserializer;
import org.apache.olingo.client.core.serialization.JsonPropertyDeserializer;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.Annotatable;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Linked;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.PropertyType;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.ex.ODataError;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;

public class JsonDeserializer
implements ODataDeserializer {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    protected final Pattern CUSTOM_ANNOTATION = Pattern.compile("(.+)@(.+)\\.(.+)");
    protected final boolean serverMode;
    private JsonGeoValueDeserializer geoDeserializer;
    private JsonParser parser;

    public JsonDeserializer(boolean serverMode) {
        this.serverMode = serverMode;
    }

    private JsonGeoValueDeserializer getGeoDeserializer() {
        if (this.geoDeserializer == null) {
            this.geoDeserializer = new JsonGeoValueDeserializer();
        }
        return this.geoDeserializer;
    }

    protected String getJSONAnnotation(String string) {
        return StringUtils.prependIfMissing((String)string, (CharSequence)"@", (CharSequence[])new CharSequence[0]);
    }

    protected String getTitle(Map.Entry<String, JsonNode> entry) {
        return entry.getKey().substring(0, entry.getKey().indexOf(64));
    }

    protected String setInline(String name, String suffix, JsonNode tree, ObjectCodec codec, Link link) throws IOException {
        String entityNamePrefix = name.substring(0, name.indexOf(suffix));
        Integer count = null;
        if (tree.hasNonNull(entityNamePrefix + "@odata.count")) {
            count = tree.get(entityNamePrefix + "@odata.count").asInt();
        }
        if (tree.has(entityNamePrefix)) {
            JsonNode inline = tree.path(entityNamePrefix);
            JsonEntityDeserializer entityDeserializer = new JsonEntityDeserializer(this.serverMode);
            if (inline instanceof ObjectNode) {
                link.setType(Constants.ENTITY_NAVIGATION_LINK_TYPE);
                link.setInlineEntity(entityDeserializer.doDeserialize(inline.traverse(codec)).getPayload());
            } else if (inline instanceof ArrayNode) {
                link.setType(Constants.ENTITY_SET_NAVIGATION_LINK_TYPE);
                EntityCollection entitySet = new EntityCollection();
                if (count != null) {
                    entitySet.setCount(count);
                }
                Iterator entries = inline.elements();
                while (entries.hasNext()) {
                    entitySet.getEntities().add(entityDeserializer.doDeserialize(((JsonNode)entries.next()).traverse(codec)).getPayload());
                }
                link.setInlineEntitySet(entitySet);
            }
        }
        return entityNamePrefix;
    }

    protected void links(Map.Entry<String, JsonNode> field, Linked linked, Set<String> toRemove, JsonNode tree, ObjectCodec codec) throws IOException {
        if (this.serverMode) {
            this.serverLinks(field, linked, toRemove, tree, codec);
        } else {
            this.clientLinks(field, linked, toRemove, tree, codec);
        }
    }

    private void clientLinks(Map.Entry<String, JsonNode> field, Linked linked, Set<String> toRemove, JsonNode tree, ObjectCodec codec) throws IOException {
        if (field.getKey().endsWith("@odata.navigationLink")) {
            Link link = new Link();
            link.setTitle(this.getTitle(field));
            link.setRel("http://docs.oasis-open.org/odata/ns/related/" + this.getTitle(field));
            if (field.getValue().isValueNode()) {
                link.setHref(field.getValue().textValue());
                link.setType(Constants.ENTITY_NAVIGATION_LINK_TYPE);
            }
            linked.getNavigationLinks().add(link);
            toRemove.add(field.getKey());
            toRemove.add(this.setInline(field.getKey(), "@odata.navigationLink", tree, codec, link));
        } else if (field.getKey().endsWith("@odata.associationLink")) {
            Link link = new Link();
            link.setTitle(this.getTitle(field));
            link.setRel("http://docs.oasis-open.org/odata/ns/relatedlinks/" + this.getTitle(field));
            link.setHref(field.getValue().textValue());
            link.setType(Constants.ASSOCIATION_LINK_TYPE);
            linked.getAssociationLinks().add(link);
            toRemove.add(field.getKey());
        }
    }

    private void serverLinks(Map.Entry<String, JsonNode> field, Linked linked, Set<String> toRemove, JsonNode tree, ObjectCodec codec) throws IOException {
        if (field.getKey().endsWith("@odata.bind") || field.getKey().endsWith("@odata.navigationLink")) {
            if (field.getValue().isValueNode()) {
                String suffix = field.getKey().replaceAll("^.*@", "@");
                Link link = new Link();
                link.setTitle(this.getTitle(field));
                link.setRel("http://docs.oasis-open.org/odata/ns/related/" + this.getTitle(field));
                link.setHref(field.getValue().textValue());
                link.setType(Constants.ENTITY_NAVIGATION_LINK_TYPE);
                linked.getNavigationLinks().add(link);
                toRemove.add(this.setInline(field.getKey(), suffix, tree, codec, link));
            } else if (field.getValue().isArray()) {
                Iterator itor = field.getValue().elements();
                while (itor.hasNext()) {
                    JsonNode node = (JsonNode)itor.next();
                    Link link = new Link();
                    link.setTitle(this.getTitle(field));
                    link.setRel("http://docs.oasis-open.org/odata/ns/related/" + this.getTitle(field));
                    link.setHref(node.asText());
                    link.setType(Constants.ENTITY_SET_NAVIGATION_LINK_TYPE);
                    linked.getNavigationLinks().add(link);
                    toRemove.add(this.setInline(field.getKey(), "@odata.bind", tree, codec, link));
                }
            }
            toRemove.add(field.getKey());
        }
    }

    private Map.Entry<PropertyType, EdmTypeInfo> guessPropertyType(JsonNode node) {
        PropertyType type;
        String typeExpression = null;
        if (node.isValueNode() || node.isNull()) {
            type = PropertyType.PRIMITIVE;
            typeExpression = this.guessPrimitiveTypeKind(node).getFullQualifiedName().toString();
        } else if (node.isArray()) {
            type = PropertyType.COLLECTION;
            if (node.has(0) && node.get(0).isValueNode()) {
                typeExpression = "Collection(" + (Object)((Object)this.guessPrimitiveTypeKind(node.get(0))) + ')';
            }
        } else if (node.isObject()) {
            if (node.has("type")) {
                type = PropertyType.PRIMITIVE;
                typeExpression = "Edm.Geography" + node.get("type").asText();
            } else {
                type = PropertyType.COMPLEX;
            }
        } else {
            type = PropertyType.EMPTY;
        }
        EdmTypeInfo typeInfo = typeExpression == null ? null : new EdmTypeInfo.Builder().setTypeExpression(typeExpression).build();
        return new AbstractMap.SimpleEntry<PropertyType, EdmTypeInfo>(type, typeInfo);
    }

    private EdmPrimitiveTypeKind guessPrimitiveTypeKind(JsonNode node) {
        return node.isShort() ? EdmPrimitiveTypeKind.Int16 : (node.isInt() ? EdmPrimitiveTypeKind.Int32 : (node.isLong() ? EdmPrimitiveTypeKind.Int64 : (node.isBoolean() ? EdmPrimitiveTypeKind.Boolean : (node.isFloat() ? EdmPrimitiveTypeKind.Single : (node.isDouble() ? EdmPrimitiveTypeKind.Double : (node.isBigDecimal() ? EdmPrimitiveTypeKind.Decimal : EdmPrimitiveTypeKind.String))))));
    }

    protected void populate(Annotatable annotatable, List<Property> properties, ObjectNode tree, ObjectCodec codec) throws IOException, EdmPrimitiveTypeException {
        String type = null;
        Annotation annotation = null;
        Iterator itor = tree.fields();
        while (itor.hasNext()) {
            Property property;
            Map.Entry field = (Map.Entry)itor.next();
            Matcher customAnnotation = this.CUSTOM_ANNOTATION.matcher((CharSequence)field.getKey());
            if (((String)field.getKey()).charAt(0) == '@') {
                Annotation entityAnnot = new Annotation();
                entityAnnot.setTerm(((String)field.getKey()).substring(1));
                this.value(entityAnnot, (JsonNode)field.getValue(), codec);
                if (annotatable == null) continue;
                annotatable.getAnnotations().add(entityAnnot);
                continue;
            }
            if (type == null && ((String)field.getKey()).endsWith(this.getJSONAnnotation("@odata.type"))) {
                type = ((JsonNode)field.getValue()).asText();
                continue;
            }
            if (((String)field.getKey()).endsWith(this.getJSONAnnotation("@odata.count"))) {
                property = new Property();
                property.setName((String)field.getKey());
                property.setValue(ValueType.PRIMITIVE, Integer.parseInt(((JsonNode)field.getValue()).asText()));
                properties.add(property);
                continue;
            }
            if (annotation == null && customAnnotation.matches() && !"odata".equals(customAnnotation.group(2))) {
                annotation = new Annotation();
                annotation.setTerm(customAnnotation.group(2) + "." + customAnnotation.group(3));
                this.value(annotation, (JsonNode)field.getValue(), codec);
                continue;
            }
            property = new Property();
            property.setName((String)field.getKey());
            property.setType(type == null ? null : new EdmTypeInfo.Builder().setTypeExpression(type).build().internal());
            type = null;
            this.value(property, (JsonNode)field.getValue(), codec);
            properties.add(property);
            if (annotation == null) continue;
            property.getAnnotations().add(annotation);
            annotation = null;
        }
    }

    private Object fromPrimitive(JsonNode node, EdmTypeInfo typeInfo) throws EdmPrimitiveTypeException {
        return node.isNull() ? null : (typeInfo == null ? node.asText() : (typeInfo.getPrimitiveTypeKind().isGeospatial() ? this.getGeoDeserializer().deserialize(node, typeInfo) : (node.isBigDecimal() ? ((EdmPrimitiveType)typeInfo.getType()).valueOfString(node.asText(), true, null, node.decimalValue().precision(), node.decimalValue().scale(), true, ((EdmPrimitiveType)typeInfo.getType()).getDefaultType()) : ((EdmPrimitiveType)typeInfo.getType()).valueOfString(node.asText(), true, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, true, ((EdmPrimitiveType)typeInfo.getType()).getDefaultType()))));
    }

    private Object fromComplex(ObjectNode node, ObjectCodec codec) throws IOException, EdmPrimitiveTypeException {
        ComplexValue complexValue = new ComplexValue();
        HashSet<String> toRemove = new HashSet<String>();
        Iterator itor = node.fields();
        while (itor.hasNext()) {
            Map.Entry field = (Map.Entry)itor.next();
            this.links(field, complexValue, toRemove, (JsonNode)node, codec);
        }
        node.remove(toRemove);
        this.populate(complexValue, complexValue.getValue(), node, codec);
        return complexValue;
    }

    private void fromCollection(Valuable valuable, Iterator<JsonNode> nodeItor, EdmTypeInfo typeInfo, ObjectCodec codec) throws IOException, EdmPrimitiveTypeException {
        EdmTypeInfo type;
        ArrayList<Object> values = new ArrayList<Object>();
        ValueType valueType = ValueType.COLLECTION_PRIMITIVE;
        EdmTypeInfo edmTypeInfo = type = typeInfo == null ? null : new EdmTypeInfo.Builder().setTypeExpression(typeInfo.getFullQualifiedName().toString()).build();
        while (nodeItor.hasNext()) {
            JsonNode child = nodeItor.next();
            if (child.isValueNode()) {
                if (typeInfo == null || typeInfo.isPrimitiveType()) {
                    Object value = this.fromPrimitive(child, type);
                    valueType = value instanceof Geospatial ? ValueType.COLLECTION_GEOSPATIAL : ValueType.COLLECTION_PRIMITIVE;
                    values.add(value);
                    continue;
                }
                valueType = ValueType.COLLECTION_ENUM;
                values.add(child.asText());
                continue;
            }
            if (!child.isContainerNode()) continue;
            EdmTypeInfo childType = null;
            if (child.has("@odata.type")) {
                String typeName = child.get("@odata.type").asText();
                childType = typeName == null ? null : new EdmTypeInfo.Builder().setTypeExpression(typeName).build();
                ((ObjectNode)child).remove("@odata.type");
            }
            Object value = this.fromComplex((ObjectNode)child, codec);
            if (childType != null) {
                ((ComplexValue)value).setTypeName(childType.external());
            }
            valueType = ValueType.COLLECTION_COMPLEX;
            values.add(value);
        }
        valuable.setValue(valueType, values);
    }

    protected void value(Valuable valuable, JsonNode node, ObjectCodec codec) throws IOException, EdmPrimitiveTypeException {
        EdmTypeInfo typeInfo = StringUtils.isBlank((CharSequence)valuable.getType()) ? null : new EdmTypeInfo.Builder().setTypeExpression(valuable.getType()).build();
        Map.Entry<PropertyType, EdmTypeInfo> guessed = this.guessPropertyType(node);
        if (typeInfo == null) {
            typeInfo = guessed.getValue();
        }
        PropertyType propType = typeInfo == null ? guessed.getKey() : (typeInfo.isCollection() ? PropertyType.COLLECTION : (typeInfo.isPrimitiveType() ? PropertyType.PRIMITIVE : (node.isValueNode() ? PropertyType.ENUM : PropertyType.COMPLEX)));
        switch (propType) {
            case COLLECTION: {
                this.fromCollection(valuable, node.elements(), typeInfo, codec);
                break;
            }
            case COMPLEX: {
                Object value;
                if (node.has("@odata.type")) {
                    valuable.setType(node.get("@odata.type").asText());
                    ((ObjectNode)node).remove("@odata.type");
                }
                if ((value = this.fromComplex((ObjectNode)node, codec)) instanceof ComplexValue) {
                    ((ComplexValue)value).setTypeName(valuable.getType());
                }
                valuable.setValue(ValueType.COMPLEX, value);
                break;
            }
            case ENUM: {
                if (node.isNull()) break;
                valuable.setValue(ValueType.ENUM, node.asText());
                break;
            }
            case PRIMITIVE: {
                Object primitiveValue;
                if (valuable.getType() == null && typeInfo != null) {
                    valuable.setType(typeInfo.getFullQualifiedName().toString());
                }
                valuable.setValue((primitiveValue = this.fromPrimitive(node, typeInfo)) instanceof Geospatial ? ValueType.GEOSPATIAL : ValueType.PRIMITIVE, primitiveValue);
                break;
            }
            default: {
                valuable.setValue(ValueType.PRIMITIVE, "");
            }
        }
    }

    @Override
    public ResWrap<EntityCollection> toEntitySet(InputStream input) throws ODataDeserializerException {
        try {
            this.parser = new JsonFactory((ObjectCodec)objectMapper).createParser(input);
            return new JsonEntitySetDeserializer(this.serverMode).doDeserialize(this.parser);
        }
        catch (IOException e) {
            throw new ODataDeserializerException(e);
        }
    }

    @Override
    public ResWrap<Entity> toEntity(InputStream input) throws ODataDeserializerException {
        try {
            this.parser = new JsonFactory((ObjectCodec)objectMapper).createParser(input);
            return new JsonEntityDeserializer(this.serverMode).doDeserialize(this.parser);
        }
        catch (IOException e) {
            throw new ODataDeserializerException(e);
        }
    }

    @Override
    public ResWrap<Property> toProperty(InputStream input) throws ODataDeserializerException {
        try {
            this.parser = new JsonFactory((ObjectCodec)objectMapper).createParser(input);
            return new JsonPropertyDeserializer(this.serverMode).doDeserialize(this.parser);
        }
        catch (IOException e) {
            throw new ODataDeserializerException(e);
        }
    }

    @Override
    public ODataError toError(InputStream input) throws ODataDeserializerException {
        try {
            this.parser = new JsonFactory((ObjectCodec)objectMapper).createParser(input);
            return new JsonODataErrorDeserializer(this.serverMode).doDeserialize(this.parser);
        }
        catch (IOException e) {
            throw new ODataDeserializerException(e);
        }
    }
}

