/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.annotation;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.annotation.EdmCast;
import org.apache.olingo.commons.api.edm.annotation.EdmExpression;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlCast;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.edm.annotation.AbstractEdmAnnotatableDynamicExpression;

public class EdmCastImpl
extends AbstractEdmAnnotatableDynamicExpression
implements EdmCast {
    private final CsdlCast cast;
    private EdmExpression value;
    private EdmType type;

    public EdmCastImpl(Edm edm, CsdlCast csdlExp) {
        super(edm, "Cast", csdlExp);
        this.cast = csdlExp;
    }

    @Override
    public Integer getMaxLength() {
        return this.cast.getMaxLength();
    }

    @Override
    public Integer getPrecision() {
        return this.cast.getPrecision();
    }

    @Override
    public Integer getScale() {
        return this.cast.getScale();
    }

    @Override
    public SRID getSrid() {
        return this.cast.getSrid();
    }

    @Override
    public EdmType getType() {
        if (this.type == null) {
            if (this.cast.getType() == null) {
                throw new EdmException("Must specify a type for a Cast expression.");
            }
            EdmTypeInfo typeInfo = new EdmTypeInfo.Builder().setEdm(this.edm).setTypeExpression(this.cast.getType()).build();
            this.type = typeInfo.getType();
        }
        return this.type;
    }

    @Override
    public EdmExpression getValue() {
        if (this.value == null) {
            if (this.cast.getValue() == null) {
                throw new EdmException("Cast expressions require an expression value.");
            }
            this.value = EdmCastImpl.getExpression(this.edm, this.cast.getValue());
        }
        return this.value;
    }

    @Override
    public EdmExpression.EdmExpressionType getExpressionType() {
        return EdmExpression.EdmExpressionType.Cast;
    }
}

