/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.io.IOException;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.etag.CustomETagSupport;
import org.apache.olingo.server.api.etag.PreconditionException;
import org.apache.olingo.server.api.processor.ActionComplexCollectionProcessor;
import org.apache.olingo.server.api.processor.ActionComplexProcessor;
import org.apache.olingo.server.api.processor.ActionEntityCollectionProcessor;
import org.apache.olingo.server.api.processor.ActionEntityProcessor;
import org.apache.olingo.server.api.processor.ActionPrimitiveCollectionProcessor;
import org.apache.olingo.server.api.processor.ActionPrimitiveProcessor;
import org.apache.olingo.server.api.processor.ActionVoidProcessor;
import org.apache.olingo.server.api.processor.BatchProcessor;
import org.apache.olingo.server.api.processor.ComplexCollectionProcessor;
import org.apache.olingo.server.api.processor.ComplexProcessor;
import org.apache.olingo.server.api.processor.CountComplexCollectionProcessor;
import org.apache.olingo.server.api.processor.CountEntityCollectionProcessor;
import org.apache.olingo.server.api.processor.CountPrimitiveCollectionProcessor;
import org.apache.olingo.server.api.processor.DeltaProcessor;
import org.apache.olingo.server.api.processor.EntityCollectionProcessor;
import org.apache.olingo.server.api.processor.EntityProcessor;
import org.apache.olingo.server.api.processor.MediaEntityProcessor;
import org.apache.olingo.server.api.processor.MetadataProcessor;
import org.apache.olingo.server.api.processor.PrimitiveCollectionProcessor;
import org.apache.olingo.server.api.processor.PrimitiveProcessor;
import org.apache.olingo.server.api.processor.PrimitiveValueProcessor;
import org.apache.olingo.server.api.processor.ReferenceCollectionProcessor;
import org.apache.olingo.server.api.processor.ReferenceProcessor;
import org.apache.olingo.server.api.processor.ServiceDocumentProcessor;
import org.apache.olingo.server.api.serializer.RepresentationType;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.UriResourceSingleton;
import org.apache.olingo.server.core.ContentNegotiator;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.ODataHandlerException;
import org.apache.olingo.server.core.ODataHandlerImpl;
import org.apache.olingo.server.core.RedirectProcessor;
import org.apache.olingo.server.core.batchhandler.BatchHandler;
import org.apache.olingo.server.core.etag.PreconditionsValidator;

public class ODataDispatcher {
    private static final String NOT_IMPLEMENTED_MESSAGE = "not implemented";
    private final UriInfo uriInfo;
    private final ODataHandlerImpl handler;
    private static final String RETURN_MINIMAL = "return=minimal";
    private static final String RETURN_REPRESENTATION = "return=representation";
    private static final String EDMSTREAM = "Edm.Stream";

    public ODataDispatcher(UriInfo uriInfo, ODataHandlerImpl handler) {
        this.uriInfo = uriInfo;
        this.handler = handler;
    }

    public void dispatch(ODataRequest request, ODataResponse response) throws ODataApplicationException, ODataLibraryException {
        switch (this.uriInfo.getKind()) {
            case metadata: {
                this.checkMethods(request.getMethod(), HttpMethod.GET, HttpMethod.HEAD);
                ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.handler.getCustomContentTypeSupport(), RepresentationType.METADATA);
                this.handler.selectProcessor(MetadataProcessor.class).readMetadata(request, response, this.uriInfo, requestedContentType);
                break;
            }
            case service: {
                this.checkMethods(request.getMethod(), HttpMethod.GET, HttpMethod.HEAD);
                if ("".equals(request.getRawODataPath())) {
                    this.handler.selectProcessor(RedirectProcessor.class).redirect(request, response);
                    break;
                }
                ContentType serviceContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.handler.getCustomContentTypeSupport(), RepresentationType.SERVICE);
                this.handler.selectProcessor(ServiceDocumentProcessor.class).readServiceDocument(request, response, this.uriInfo, serviceContentType);
                break;
            }
            case resource: 
            case entityId: {
                this.handleResourceDispatching(request, response);
                break;
            }
            case batch: {
                this.checkMethod(request.getMethod(), HttpMethod.POST);
                new BatchHandler(this.handler, this.handler.selectProcessor(BatchProcessor.class)).process(request, response, true);
                break;
            }
            default: {
                throw new ODataHandlerException(NOT_IMPLEMENTED_MESSAGE, ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
        }
    }

    private void handleResourceDispatching(ODataRequest request, ODataResponse response) throws ODataApplicationException, ODataLibraryException {
        int lastPathSegmentIndex = this.uriInfo.getUriResourceParts().size() - 1;
        UriResource lastPathSegment = this.uriInfo.getUriResourceParts().get(lastPathSegmentIndex);
        switch (lastPathSegment.getKind()) {
            case action: {
                this.checkMethod(request.getMethod(), HttpMethod.POST);
                this.handleActionDispatching(request, response, (UriResourceAction)lastPathSegment);
                break;
            }
            case function: {
                this.checkMethod(request.getMethod(), HttpMethod.GET);
                this.handleFunctionDispatching(request, response, (UriResourceFunction)lastPathSegment);
                break;
            }
            case entitySet: 
            case navigationProperty: {
                this.handleEntityDispatching(request, response, ((UriResourcePartTyped)lastPathSegment).isCollection(), this.isEntityOrNavigationMedia(lastPathSegment));
                break;
            }
            case singleton: {
                this.handleSingleEntityDispatching(request, response, this.isSingletonMedia(lastPathSegment), true);
                break;
            }
            case count: {
                this.checkMethod(request.getMethod(), HttpMethod.GET);
                this.handleCountDispatching(request, response, lastPathSegmentIndex);
                break;
            }
            case primitiveProperty: {
                this.handlePrimitiveDispatching(request, response, ((UriResourceProperty)lastPathSegment).isCollection());
                break;
            }
            case complexProperty: {
                this.handleComplexDispatching(request, response, ((UriResourceProperty)lastPathSegment).isCollection());
                break;
            }
            case value: {
                this.handleValueDispatching(request, response, lastPathSegmentIndex);
                break;
            }
            case ref: {
                this.handleReferenceDispatching(request, response, lastPathSegmentIndex);
                break;
            }
            default: {
                throw new ODataHandlerException(NOT_IMPLEMENTED_MESSAGE, ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
        }
    }

    private void handleFunctionDispatching(ODataRequest request, ODataResponse response, UriResourceFunction uriResourceFunction) throws ODataApplicationException, ODataLibraryException {
        EdmFunction function = uriResourceFunction.getFunction();
        if (function == null) {
            function = uriResourceFunction.getFunctionImport().getUnboundFunctions().get(0);
        }
        EdmReturnType returnType = function.getReturnType();
        switch (returnType.getType().getKind()) {
            case ENTITY: {
                this.handleEntityDispatching(request, response, returnType.isCollection() && uriResourceFunction.getKeyPredicates().isEmpty(), false);
                break;
            }
            case PRIMITIVE: {
                this.handlePrimitiveDispatching(request, response, returnType.isCollection());
                break;
            }
            case COMPLEX: {
                this.handleComplexDispatching(request, response, returnType.isCollection());
                break;
            }
            default: {
                throw new ODataHandlerException(NOT_IMPLEMENTED_MESSAGE, ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
        }
    }

    private void handleActionDispatching(ODataRequest request, ODataResponse response, UriResourceAction uriResourceAction) throws ODataApplicationException, ODataLibraryException {
        EdmAction action = uriResourceAction.getAction();
        if (action.isBound()) {
            this.validatePreconditions(request, false);
        }
        ContentType requestFormat = this.getSupportedContentType(request.getHeader("Content-Type"), RepresentationType.ACTION_PARAMETERS, false);
        EdmReturnType returnType = action.getReturnType();
        if (returnType == null) {
            this.handler.selectProcessor(ActionVoidProcessor.class).processActionVoid(request, response, this.uriInfo, requestFormat);
        } else {
            boolean isCollection = returnType.isCollection();
            switch (returnType.getType().getKind()) {
                case ENTITY: {
                    ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.handler.getCustomContentTypeSupport(), isCollection ? RepresentationType.COLLECTION_ENTITY : RepresentationType.ENTITY);
                    if (isCollection) {
                        this.handler.selectProcessor(ActionEntityCollectionProcessor.class).processActionEntityCollection(request, response, this.uriInfo, requestFormat, responseFormat);
                        break;
                    }
                    this.handler.selectProcessor(ActionEntityProcessor.class).processActionEntity(request, response, this.uriInfo, requestFormat, responseFormat);
                    break;
                }
                case PRIMITIVE: {
                    ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.handler.getCustomContentTypeSupport(), isCollection ? RepresentationType.COLLECTION_PRIMITIVE : RepresentationType.PRIMITIVE);
                    if (isCollection) {
                        this.handler.selectProcessor(ActionPrimitiveCollectionProcessor.class).processActionPrimitiveCollection(request, response, this.uriInfo, requestFormat, responseFormat);
                        break;
                    }
                    this.handler.selectProcessor(ActionPrimitiveProcessor.class).processActionPrimitive(request, response, this.uriInfo, requestFormat, responseFormat);
                    break;
                }
                case COMPLEX: {
                    ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.handler.getCustomContentTypeSupport(), isCollection ? RepresentationType.COLLECTION_COMPLEX : RepresentationType.COMPLEX);
                    if (isCollection) {
                        this.handler.selectProcessor(ActionComplexCollectionProcessor.class).processActionComplexCollection(request, response, this.uriInfo, requestFormat, responseFormat);
                        break;
                    }
                    this.handler.selectProcessor(ActionComplexProcessor.class).processActionComplex(request, response, this.uriInfo, requestFormat, responseFormat);
                    break;
                }
                default: {
                    throw new ODataHandlerException(NOT_IMPLEMENTED_MESSAGE, ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
                }
            }
        }
    }

    private void handleReferenceDispatching(ODataRequest request, ODataResponse response, int lastPathSegmentIndex) throws ODataApplicationException, ODataLibraryException {
        HttpMethod httpMethod = request.getMethod();
        boolean isCollection = ((UriResourcePartTyped)this.uriInfo.getUriResourceParts().get(lastPathSegmentIndex - 1)).isCollection();
        if (isCollection && httpMethod == HttpMethod.GET) {
            this.validatePreferHeader(request);
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.handler.getCustomContentTypeSupport(), RepresentationType.COLLECTION_REFERENCE);
            this.handler.selectProcessor(ReferenceCollectionProcessor.class).readReferenceCollection(request, response, this.uriInfo, responseFormat);
        } else if (isCollection && httpMethod == HttpMethod.POST) {
            ContentType requestFormat = this.getSupportedContentType(request.getHeader("Content-Type"), RepresentationType.REFERENCE, true);
            this.handler.selectProcessor(ReferenceProcessor.class).createReference(request, response, this.uriInfo, requestFormat);
        } else if (!isCollection && httpMethod == HttpMethod.GET) {
            this.validatePreferHeader(request);
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.handler.getCustomContentTypeSupport(), RepresentationType.REFERENCE);
            this.handler.selectProcessor(ReferenceProcessor.class).readReference(request, response, this.uriInfo, responseFormat);
        } else if (!(isCollection || httpMethod != HttpMethod.PUT && httpMethod != HttpMethod.PATCH)) {
            ContentType requestFormat = this.getSupportedContentType(request.getHeader("Content-Type"), RepresentationType.REFERENCE, true);
            this.handler.selectProcessor(ReferenceProcessor.class).updateReference(request, response, this.uriInfo, requestFormat);
        } else if (httpMethod == HttpMethod.DELETE) {
            this.validatePreferHeader(request);
            this.handler.selectProcessor(ReferenceProcessor.class).deleteReference(request, response, this.uriInfo);
        } else {
            this.throwMethodNotAllowed(httpMethod);
        }
    }

    private void handleValueDispatching(ODataRequest request, ODataResponse response, int lastPathSegmentIndex) throws ODataApplicationException, ODataLibraryException {
        UriResource resource = this.uriInfo.getUriResourceParts().get(lastPathSegmentIndex - 1);
        if (resource instanceof UriResourceProperty || resource instanceof UriResourceFunction && ((UriResourceFunction)resource).getType().getKind() == EdmTypeKind.PRIMITIVE) {
            this.handlePrimitiveValueDispatching(request, response, resource);
        } else {
            this.handleMediaValueDispatching(request, response, resource);
        }
    }

    private void handleMediaValueDispatching(ODataRequest request, ODataResponse response, UriResource resource) throws ContentNegotiatorException, ODataApplicationException, ODataLibraryException, ODataHandlerException, PreconditionException {
        HttpMethod method = request.getMethod();
        this.validatePreferHeader(request);
        if (method == HttpMethod.GET) {
            ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.handler.getCustomContentTypeSupport(), RepresentationType.MEDIA);
            this.handler.selectProcessor(MediaEntityProcessor.class).readMediaEntity(request, response, this.uriInfo, requestedContentType);
        } else if (method == HttpMethod.PUT && (this.isEntityOrNavigationMedia(resource) || this.isSingletonMedia(resource))) {
            this.validatePreconditions(request, true);
            ContentType requestFormat = ContentType.parse(request.getHeader("Content-Type"));
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.handler.getCustomContentTypeSupport(), RepresentationType.ENTITY);
            this.handler.selectProcessor(MediaEntityProcessor.class).updateMediaEntity(request, response, this.uriInfo, requestFormat, responseFormat);
        } else if (method == HttpMethod.DELETE && this.isEntityOrNavigationMedia(resource)) {
            this.validatePreconditions(request, true);
            this.handler.selectProcessor(MediaEntityProcessor.class).deleteMediaEntity(request, response, this.uriInfo);
        } else {
            this.throwMethodNotAllowed(method);
        }
    }

    private void handlePrimitiveValueDispatching(ODataRequest request, ODataResponse response, UriResource resource) throws ContentNegotiatorException, ODataApplicationException, ODataLibraryException, ODataHandlerException, PreconditionException {
        RepresentationType valueRepresentationType;
        HttpMethod method = request.getMethod();
        EdmType type = resource instanceof UriResourceProperty ? ((UriResourceProperty)resource).getType() : ((UriResourceFunction)resource).getType();
        RepresentationType representationType = valueRepresentationType = type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Binary) ? RepresentationType.BINARY : RepresentationType.VALUE;
        if (method == HttpMethod.GET) {
            this.validatePreferHeader(request);
            ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.handler.getCustomContentTypeSupport(), valueRepresentationType);
            this.handler.selectProcessor(PrimitiveValueProcessor.class).readPrimitiveValue(request, response, this.uriInfo, requestedContentType);
        } else if (method == HttpMethod.PUT && resource instanceof UriResourceProperty) {
            this.validatePreconditions(request, false);
            ContentType requestFormat = this.getSupportedContentType(request.getHeader("Content-Type"), valueRepresentationType, true);
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.handler.getCustomContentTypeSupport(), valueRepresentationType);
            this.handler.selectProcessor(PrimitiveValueProcessor.class).updatePrimitiveValue(request, response, this.uriInfo, requestFormat, responseFormat);
        } else if (method == HttpMethod.DELETE && resource instanceof UriResourceProperty) {
            this.validatePreferHeader(request);
            this.validatePreconditions(request, false);
            this.handler.selectProcessor(PrimitiveValueProcessor.class).deletePrimitiveValue(request, response, this.uriInfo);
        } else {
            this.throwMethodNotAllowed(method);
        }
    }

    private void handleComplexDispatching(ODataRequest request, ODataResponse response, boolean isCollection) throws ODataApplicationException, ODataLibraryException {
        RepresentationType complexRepresentationType;
        HttpMethod method = request.getMethod();
        RepresentationType representationType = complexRepresentationType = isCollection ? RepresentationType.COLLECTION_COMPLEX : RepresentationType.COMPLEX;
        if (method == HttpMethod.GET) {
            this.validatePreferHeader(request);
            ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.handler.getCustomContentTypeSupport(), complexRepresentationType);
            if (isCollection) {
                this.handler.selectProcessor(ComplexCollectionProcessor.class).readComplexCollection(request, response, this.uriInfo, requestedContentType);
            } else {
                this.handler.selectProcessor(ComplexProcessor.class).readComplex(request, response, this.uriInfo, requestedContentType);
            }
        } else if (method == HttpMethod.PUT || method == HttpMethod.PATCH || method == HttpMethod.POST && isCollection) {
            this.validatePreconditions(request, false);
            ContentType requestFormat = this.getSupportedContentType(request.getHeader("Content-Type"), complexRepresentationType, true);
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.handler.getCustomContentTypeSupport(), complexRepresentationType);
            if (isCollection) {
                this.handler.selectProcessor(ComplexCollectionProcessor.class).updateComplexCollection(request, response, this.uriInfo, requestFormat, responseFormat);
            } else {
                this.handler.selectProcessor(ComplexProcessor.class).updateComplex(request, response, this.uriInfo, requestFormat, responseFormat);
            }
        } else if (method == HttpMethod.DELETE) {
            this.validatePreferHeader(request);
            this.validatePreconditions(request, false);
            if (isCollection) {
                this.handler.selectProcessor(ComplexCollectionProcessor.class).deleteComplexCollection(request, response, this.uriInfo);
            } else {
                this.handler.selectProcessor(ComplexProcessor.class).deleteComplex(request, response, this.uriInfo);
            }
        } else {
            this.throwMethodNotAllowed(method);
        }
    }

    private void handlePrimitiveDispatching(ODataRequest request, ODataResponse response, boolean isCollection) throws ODataApplicationException, ODataLibraryException {
        RepresentationType representationType;
        HttpMethod method = request.getMethod();
        RepresentationType representationType2 = representationType = isCollection ? RepresentationType.COLLECTION_PRIMITIVE : RepresentationType.PRIMITIVE;
        if (method == HttpMethod.GET) {
            this.validatePreferHeader(request);
            ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.handler.getCustomContentTypeSupport(), representationType);
            if (isCollection) {
                this.handler.selectProcessor(PrimitiveCollectionProcessor.class).readPrimitiveCollection(request, response, this.uriInfo, requestedContentType);
            } else {
                this.handler.selectProcessor(PrimitiveProcessor.class).readPrimitive(request, response, this.uriInfo, requestedContentType);
            }
        } else if (method == HttpMethod.PUT || method == HttpMethod.PATCH || method == HttpMethod.POST && isCollection) {
            this.validatePreconditions(request, false);
            ContentType requestFormat = null;
            List<UriResource> uriResources = this.uriInfo.getUriResourceParts();
            UriResource uriResource = uriResources.get(uriResources.size() - 1);
            requestFormat = uriResource instanceof UriResourcePrimitiveProperty && ((UriResourcePrimitiveProperty)uriResource).getType().getFullQualifiedName().getFullQualifiedNameAsString().equalsIgnoreCase(EDMSTREAM) ? ContentType.parse(request.getHeader("Content-Type")) : this.getSupportedContentType(request.getHeader("Content-Type"), representationType, true);
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.handler.getCustomContentTypeSupport(), representationType);
            if (isCollection) {
                this.handler.selectProcessor(PrimitiveCollectionProcessor.class).updatePrimitiveCollection(request, response, this.uriInfo, requestFormat, responseFormat);
            } else {
                this.handler.selectProcessor(PrimitiveProcessor.class).updatePrimitive(request, response, this.uriInfo, requestFormat, responseFormat);
            }
        } else if (method == HttpMethod.DELETE) {
            this.validatePreferHeader(request);
            this.validatePreconditions(request, false);
            if (isCollection) {
                this.handler.selectProcessor(PrimitiveCollectionProcessor.class).deletePrimitiveCollection(request, response, this.uriInfo);
            } else {
                this.handler.selectProcessor(PrimitiveProcessor.class).deletePrimitive(request, response, this.uriInfo);
            }
        } else {
            this.throwMethodNotAllowed(method);
        }
    }

    private void handleCountDispatching(ODataRequest request, ODataResponse response, int lastPathSegmentIndex) throws ODataApplicationException, ODataLibraryException {
        this.validatePreferHeader(request);
        UriResource resource = this.uriInfo.getUriResourceParts().get(lastPathSegmentIndex - 1);
        if (resource instanceof UriResourceEntitySet || resource instanceof UriResourceNavigation || resource instanceof UriResourceFunction && ((UriResourceFunction)resource).getType().getKind() == EdmTypeKind.ENTITY) {
            this.handler.selectProcessor(CountEntityCollectionProcessor.class).countEntityCollection(request, response, this.uriInfo);
        } else if (resource instanceof UriResourcePrimitiveProperty || resource instanceof UriResourceFunction && ((UriResourceFunction)resource).getType().getKind() == EdmTypeKind.PRIMITIVE) {
            this.handler.selectProcessor(CountPrimitiveCollectionProcessor.class).countPrimitiveCollection(request, response, this.uriInfo);
        } else {
            this.handler.selectProcessor(CountComplexCollectionProcessor.class).countComplexCollection(request, response, this.uriInfo);
        }
    }

    private void handleEntityDispatching(ODataRequest request, ODataResponse response, boolean isCollection, boolean isMedia) throws ODataApplicationException, ODataLibraryException {
        if (isCollection) {
            this.handleEntityCollectionDispatching(request, response, isMedia);
        } else {
            this.handleSingleEntityDispatching(request, response, isMedia, false);
        }
    }

    private void handleEntityCollectionDispatching(ODataRequest request, ODataResponse response, boolean isMedia) throws ContentNegotiatorException, ODataApplicationException, ODataLibraryException, ODataHandlerException {
        HttpMethod method = request.getMethod();
        if (method == HttpMethod.GET) {
            this.validatePreferHeader(request);
            ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.handler.getCustomContentTypeSupport(), RepresentationType.COLLECTION_ENTITY);
            this.handler.selectProcessor(EntityCollectionProcessor.class).readEntityCollection(request, response, this.uriInfo, requestedContentType);
        } else if (method == HttpMethod.POST) {
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.handler.getCustomContentTypeSupport(), RepresentationType.ENTITY);
            if (isMedia) {
                this.validatePreferHeader(request);
                ContentType requestFormat = ContentType.parse(request.getHeader("Content-Type"));
                this.handler.selectProcessor(MediaEntityProcessor.class).createMediaEntity(request, response, this.uriInfo, requestFormat, responseFormat);
            } else {
                try {
                    ContentType requestFormat = request.getHeader("Content-Type") == null && (request.getBody() == null || request.getBody().available() == 0) ? this.getSupportedContentType(request.getHeader("Content-Type"), RepresentationType.ENTITY, false) : this.getSupportedContentType(request.getHeader("Content-Type"), RepresentationType.ENTITY, true);
                    this.handler.selectProcessor(EntityProcessor.class).createEntity(request, response, this.uriInfo, requestFormat, responseFormat);
                }
                catch (IOException e) {
                    throw new ODataHandlerException("There is problem in the payload.", ODataHandlerException.MessageKeys.INVALID_PAYLOAD, new String[0]);
                }
            }
        } else if (method == HttpMethod.PUT && this.uriInfo.getUriResourceParts().size() == 2) {
            if (isMedia) {
                this.validatePreferHeader(request);
            }
            this.validatePreconditions(request, false);
            ContentType requestFormat = this.getSupportedContentType(request.getHeader("Content-Type"), RepresentationType.ENTITY, true);
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.handler.getCustomContentTypeSupport(), RepresentationType.ENTITY);
            this.handler.selectProcessor(EntityProcessor.class).updateEntity(request, response, this.uriInfo, requestFormat, responseFormat);
        } else if (method == HttpMethod.PATCH) {
            this.validatePreconditions(request, false);
            ContentType requestFormat = this.getSupportedContentType(request.getHeader("Content-Type"), RepresentationType.COLLECTION_ENTITY, true);
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.handler.getCustomContentTypeSupport(), RepresentationType.COLLECTION_ENTITY);
            this.handler.selectProcessor(DeltaProcessor.class).updateEntityCollection(request, response, this.uriInfo, requestFormat, responseFormat);
        } else {
            this.throwMethodNotAllowed(method);
        }
    }

    private void validatePreferHeader(ODataRequest request) throws ODataHandlerException {
        List<String> returnPreference = request.getHeaders("Prefer");
        if (null != returnPreference) {
            for (String preference : returnPreference) {
                if (!preference.equals(RETURN_MINIMAL) && !preference.equals(RETURN_REPRESENTATION)) continue;
                throw new ODataHandlerException("Prefer Header not supported: " + preference, ODataHandlerException.MessageKeys.INVALID_PREFER_HEADER, preference);
            }
        }
    }

    private boolean isSingletonMedia(UriResource pathSegment) {
        return pathSegment instanceof UriResourceSingleton && ((UriResourceSingleton)pathSegment).getEntityType().hasStream();
    }

    private void handleSingleEntityDispatching(ODataRequest request, ODataResponse response, boolean isMedia, boolean isSingleton) throws ContentNegotiatorException, ODataApplicationException, ODataLibraryException, ODataHandlerException, PreconditionException {
        HttpMethod method = request.getMethod();
        if (method == HttpMethod.GET) {
            this.validatePreferHeader(request);
            ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.handler.getCustomContentTypeSupport(), RepresentationType.ENTITY);
            this.handler.selectProcessor(EntityProcessor.class).readEntity(request, response, this.uriInfo, requestedContentType);
        } else if (method == HttpMethod.PUT || method == HttpMethod.PATCH) {
            if (isMedia) {
                this.validatePreferHeader(request);
            }
            this.validatePreconditions(request, false);
            ContentType requestFormat = this.getSupportedContentType(request.getHeader("Content-Type"), RepresentationType.ENTITY, true);
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.handler.getCustomContentTypeSupport(), RepresentationType.ENTITY);
            this.handler.selectProcessor(EntityProcessor.class).updateEntity(request, response, this.uriInfo, requestFormat, responseFormat);
        } else if (method == HttpMethod.DELETE && !isSingleton) {
            this.validateIsSingleton(method);
            this.validatePreconditions(request, false);
            this.validatePreferHeader(request);
            if (isMedia) {
                this.handler.selectProcessor(MediaEntityProcessor.class).deleteEntity(request, response, this.uriInfo);
            } else {
                this.handler.selectProcessor(EntityProcessor.class).deleteEntity(request, response, this.uriInfo);
            }
        } else {
            this.throwMethodNotAllowed(method);
        }
    }

    private void validateIsSingleton(HttpMethod method) throws ODataHandlerException {
        int lastPathSegmentIndex = this.uriInfo.getUriResourceParts().size() - 1;
        UriResource pathSegment = this.uriInfo.getUriResourceParts().get(lastPathSegmentIndex);
        if (pathSegment instanceof UriResourceNavigation && this.uriInfo.getUriResourceParts().get(lastPathSegmentIndex - 1) instanceof UriResourceEntitySet && ((UriResourceEntitySet)this.uriInfo.getUriResourceParts().get(lastPathSegmentIndex - 1)).getEntitySet().getRelatedBindingTarget(pathSegment.getSegmentValue()) instanceof EdmSingleton) {
            this.throwMethodNotAllowed(method);
        }
    }

    private void validatePreconditions(ODataRequest request, boolean isMediaValue) throws PreconditionException {
        CustomETagSupport eTagSupport = this.handler.getCustomETagSupport();
        if (eTagSupport != null && new PreconditionsValidator(this.uriInfo).mustValidatePreconditions(eTagSupport, isMediaValue) && request.getHeader("If-Match") == null && request.getHeader("If-None-Match") == null) {
            throw new PreconditionException("Expected an if-match or if-none-match header.", PreconditionException.MessageKeys.MISSING_HEADER, new String[0]);
        }
    }

    private void checkMethod(HttpMethod requestMethod, HttpMethod allowedMethod) throws ODataHandlerException {
        if (requestMethod != allowedMethod) {
            this.throwMethodNotAllowed(requestMethod);
        }
    }

    private void checkMethods(HttpMethod requestMethod, HttpMethod ... allowedMethods) throws ODataHandlerException {
        for (int i = 0; i < allowedMethods.length; ++i) {
            if (requestMethod != allowedMethods[i]) continue;
            return;
        }
        this.throwMethodNotAllowed(requestMethod);
    }

    private void throwMethodNotAllowed(HttpMethod httpMethod) throws ODataHandlerException {
        throw new ODataHandlerException("HTTP method " + (Object)((Object)httpMethod) + " is not allowed.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, httpMethod.toString());
    }

    private ContentType getSupportedContentType(String contentTypeHeader, RepresentationType representationType, boolean mustNotBeNull) throws ODataHandlerException, ContentNegotiatorException {
        ContentType contentType;
        if (contentTypeHeader == null) {
            if (mustNotBeNull) {
                throw new ODataHandlerException("ContentTypeHeader parameter is null", ODataHandlerException.MessageKeys.MISSING_CONTENT_TYPE, new String[0]);
            }
            return ContentType.APPLICATION_JSON;
        }
        try {
            contentType = ContentType.create(contentTypeHeader);
        }
        catch (IllegalArgumentException e) {
            throw new ODataHandlerException("Illegal content type.", (Throwable)e, ODataHandlerException.MessageKeys.INVALID_CONTENT_TYPE, contentTypeHeader);
        }
        ContentNegotiator.checkSupport(contentType, this.handler.getCustomContentTypeSupport(), representationType);
        return contentType;
    }

    private boolean isEntityOrNavigationMedia(UriResource pathSegment) {
        return pathSegment instanceof UriResourceEntitySet && ((UriResourceEntitySet)pathSegment).getEntityType().hasStream() || pathSegment instanceof UriResourceNavigation && ((EdmEntityType)((UriResourceNavigation)pathSegment).getType()).hasStream();
    }
}

