/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri;

import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.core.uri.UriResourceImpl;

public abstract class UriResourceWithKeysImpl
extends UriResourceImpl
implements UriResourcePartTyped {
    private EdmType collectionTypeFilter = null;
    protected List<UriParameter> keyPredicates = null;
    private EdmType entryTypeFilter = null;

    public UriResourceWithKeysImpl(UriResourceKind kind) {
        super(kind);
    }

    public EdmType getTypeFilterOnCollection() {
        return this.collectionTypeFilter;
    }

    public EdmType getTypeFilterOnEntry() {
        return this.entryTypeFilter;
    }

    public List<UriParameter> getKeyPredicates() {
        return this.keyPredicates == null ? Collections.emptyList() : Collections.unmodifiableList(this.keyPredicates);
    }

    public UriResourceWithKeysImpl setKeyPredicates(List<UriParameter> list) {
        this.keyPredicates = list;
        return this;
    }

    public UriResourceWithKeysImpl setEntryTypeFilter(EdmType entryTypeFilter) {
        this.entryTypeFilter = entryTypeFilter;
        return this;
    }

    public UriResourceWithKeysImpl setCollectionTypeFilter(EdmType collectionTypeFilter) {
        this.collectionTypeFilter = collectionTypeFilter;
        return this;
    }

    @Override
    public String getSegmentValue(boolean includeFilters) {
        if (includeFilters) {
            StringBuilder tmp = new StringBuilder();
            if (this.collectionTypeFilter != null) {
                tmp.append(this.getFQN(this.collectionTypeFilter));
            }
            if (this.entryTypeFilter != null) {
                if (tmp.length() == 0) {
                    tmp.append(this.getFQN(this.entryTypeFilter));
                } else {
                    tmp.append("/()").append(this.getFQN(this.entryTypeFilter));
                }
            }
            if (tmp.length() != 0) {
                return this.getSegmentValue() + "/" + tmp.toString();
            }
        }
        return this.getSegmentValue();
    }

    @Override
    public String toString(boolean includeFilters) {
        return this.getSegmentValue(includeFilters);
    }

    private String getFQN(EdmType type) {
        return type.getFullQualifiedName().getFullQualifiedNameAsString();
    }
}

