/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.olingo.commons.api.data.EntityMediaObject;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.deserializer.batch.ODataResponsePart;
import org.apache.olingo.server.api.serializer.BatchSerializerException;
import org.apache.olingo.server.api.serializer.FixedFormatSerializer;
import org.apache.olingo.server.api.serializer.PrimitiveValueSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerStreamResult;
import org.apache.olingo.server.core.ODataWritableContent;
import org.apache.olingo.server.core.serializer.AsyncResponseSerializer;
import org.apache.olingo.server.core.serializer.BatchResponseSerializer;

public class FixedFormatSerializerImpl
implements FixedFormatSerializer {
    public static final int COPY_BUFFER_SIZE = 8192;

    @Override
    public InputStream binary(byte[] binary) throws SerializerException {
        return new ByteArrayInputStream(binary);
    }

    protected void binary(EntityMediaObject mediaEntity, OutputStream outputStream) throws SerializerException {
        try {
            outputStream.write(mediaEntity.getBytes());
        }
        catch (IOException e) {
            throw new SerializerException("IO Exception occured ", (Throwable)e, SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
    }

    protected void binary(InputStream inputStream, OutputStream outputStream) throws SerializerException {
        byte[] buffer = new byte[8192];
        try {
            int count;
            while ((count = inputStream.read(buffer)) > -1) {
                outputStream.write(buffer, 0, count);
            }
            outputStream.flush();
        }
        catch (IOException e) {
            throw new SerializerException("IO Exception occured ", (Throwable)e, SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
    }

    public void binaryIntoStreamed(EntityMediaObject mediaEntity, OutputStream outputStream) throws SerializerException {
        this.binary(mediaEntity, outputStream);
    }

    public void binaryIntoStreamed(InputStream inputStream, OutputStream outputStream) throws SerializerException {
        this.binary(inputStream, outputStream);
    }

    @Override
    public SerializerStreamResult mediaEntityStreamed(EntityMediaObject mediaEntity) throws SerializerException {
        return ODataWritableContent.with(mediaEntity, this).build();
    }

    @Override
    public SerializerStreamResult mediaEntityStreamed(InputStream inputStream) throws SerializerException {
        return ODataWritableContent.with(inputStream, this).build();
    }

    @Override
    public InputStream count(Integer count) throws SerializerException {
        try {
            return new ByteArrayInputStream(count.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializerException("UTF-8 is nott supprted as an encoding", (Throwable)e, SerializerException.MessageKeys.UNSUPPORTED_ENCODING, "UTF-8");
        }
    }

    @Override
    public InputStream primitiveValue(EdmPrimitiveType type, Object value, PrimitiveValueSerializerOptions options) throws SerializerException {
        try {
            String result = type.valueToString(value, options.isNullable(), options.getMaxLength(), options.getPrecision(), options.getScale(), options.isUnicode());
            return new ByteArrayInputStream(result.getBytes("UTF-8"));
        }
        catch (EdmPrimitiveTypeException e) {
            throw new SerializerException("Error in primitive-value formatting.", (Throwable)e, SerializerException.MessageKeys.WRONG_PRIMITIVE_VALUE, type.getFullQualifiedName().getFullQualifiedNameAsString(), value.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializerException("Encoding exception.", (Throwable)e, SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
    }

    @Override
    public InputStream asyncResponse(ODataResponse odataResponse) throws SerializerException {
        AsyncResponseSerializer serializer = new AsyncResponseSerializer();
        return serializer.serialize(odataResponse);
    }

    @Override
    public InputStream batchResponse(List<ODataResponsePart> batchResponses, String boundary) throws BatchSerializerException {
        BatchResponseSerializer serializer = new BatchResponseSerializer();
        return serializer.serialize(batchResponses, boundary);
    }
}

