/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.uri;

import org.apache.olingo.client.api.uri.FilterArg;
import org.apache.olingo.client.api.uri.URIFilter;

public class FilterLambda
implements FilterArg {
    private final FilterArg collection;
    private final String operator;
    private final URIFilter expression;
    private final String lambdaVariable;
    public static final String COLON = ":";
    public static final String OPENBRAC = "(";
    public static final String CLOSEBRAC = ")";
    public static final String SLASH = "/";

    public FilterLambda(FilterArg collection, String operator, URIFilter expression, String predicate) {
        this.collection = collection;
        this.operator = operator;
        this.expression = expression;
        this.lambdaVariable = predicate;
    }

    @Override
    public String build() {
        StringBuilder builder = new StringBuilder(this.collection.build()).append(SLASH).append(this.operator);
        if (this.lambdaVariable != null && this.lambdaVariable.length() > 0) {
            builder.append(OPENBRAC).append(this.lambdaVariable).append(COLON).append(this.expression.build()).append(CLOSEBRAC);
        } else {
            builder.append(this.expression.build());
        }
        return builder.toString();
    }
}

