/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.xml;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.commons.api.data.AbstractEntityCollection;
import org.apache.olingo.commons.api.data.AbstractEntityCollectionObject;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.ComplexSerializerOptions;
import org.apache.olingo.server.api.serializer.EntityCollectionSerializerOptions;
import org.apache.olingo.server.api.serializer.EntitySerializerOptions;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.PrimitiveSerializerOptions;
import org.apache.olingo.server.api.serializer.ReferenceCollectionSerializerOptions;
import org.apache.olingo.server.api.serializer.ReferenceSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.api.serializer.SerializerStreamResult;
import org.apache.olingo.server.core.serializer.SerializerResultImpl;
import org.apache.olingo.server.core.serializer.utils.CircleStreamBuffer;
import org.apache.olingo.server.core.serializer.utils.OutputStreamHelper;
import org.apache.olingo.server.core.serializer.xml.MetadataDocumentXmlSerializer;

public class ODataXmlSerializer
implements ODataSerializer {
    public static final String DEFAULT_CHARSET = "UTF-8";

    @Override
    public SerializerResult serviceDocument(ServiceMetadata metadata, String serviceRoot) throws SerializerException {
        throw new SerializerException("Service document serialization not implemented for XML format", SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    @Override
    public SerializerResult metadataDocument(ServiceMetadata serviceMetadata) throws SerializerException {
        SerializerResult serializerResult;
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream, DEFAULT_CHARSET);
            MetadataDocumentXmlSerializer serializer = new MetadataDocumentXmlSerializer(serviceMetadata);
            serializer.writeMetadataDocument(writer);
            writer.flush();
            writer.close();
            outputStream.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (IOException | XMLStreamException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
            }
            catch (Throwable throwable) {
                OutputStreamHelper.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        OutputStreamHelper.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    @Override
    public SerializerResult error(ODataServerError error) throws SerializerException {
        throw new SerializerException("Error serialization not implemented for XML format", SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    @Override
    public SerializerResult entityCollection(ServiceMetadata metadata, EdmEntityType entityType, AbstractEntityCollection entitySet, EntityCollectionSerializerOptions options) throws SerializerException {
        throw new SerializerException("Entity Collection serialization not implemented for XML format", SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    @Override
    public SerializerStreamResult entityCollectionStreamed(ServiceMetadata metadata, EdmEntityType entityType, AbstractEntityCollectionObject entities, EntityCollectionSerializerOptions options) throws SerializerException {
        throw new SerializerException("Entity Collection serialization not implemented for XML format", SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    @Override
    public SerializerResult entity(ServiceMetadata metadata, EdmEntityType entityType, Entity entity, EntitySerializerOptions options) throws SerializerException {
        throw new SerializerException("Entity serialization not implemented for XML format", SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    @Override
    public SerializerResult primitive(ServiceMetadata metadata, EdmPrimitiveType type, Property property, PrimitiveSerializerOptions options) throws SerializerException {
        throw new SerializerException("Property serialization not implemented for XML format", SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    @Override
    public SerializerResult complex(ServiceMetadata metadata, EdmComplexType type, Property property, ComplexSerializerOptions options) throws SerializerException {
        throw new SerializerException("Property serialization not implemented for XML format", SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    @Override
    public SerializerResult primitiveCollection(ServiceMetadata metadata, EdmPrimitiveType type, Property property, PrimitiveSerializerOptions options) throws SerializerException {
        throw new SerializerException("Property serialization not implemented for XML format", SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    @Override
    public SerializerResult complexCollection(ServiceMetadata metadata, EdmComplexType type, Property property, ComplexSerializerOptions options) throws SerializerException {
        throw new SerializerException("Property serialization not implemented for XML format", SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    @Override
    public SerializerResult reference(ServiceMetadata metadata, EdmEntitySet edmEntitySet, Entity entity, ReferenceSerializerOptions options) throws SerializerException {
        throw new SerializerException("Reference serialization not implemented for XML format", SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    @Override
    public SerializerResult referenceCollection(ServiceMetadata metadata, EdmEntitySet edmEntitySet, AbstractEntityCollection entityCollection, ReferenceCollectionSerializerOptions options) throws SerializerException {
        throw new SerializerException("Reference collection serialization not implemented for XML format", SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }
}

